<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_templates extends leadflow {

  static $template_folder_url = '';
  static $img_src_to_upload_url = array();

  static function fix_img_path(&$item, $key) {
    if (fnmatch("*.jpg", $item) || fnmatch("*.jpeg", $item) || fnmatch("*.png", $item) || fnmatch("*.gif", $item) ) {	
      if (!empty($item)) {
        $image_url = self::$template_folder_url . $item;
        #$image = wp_remote_get($image_url);
		$media = media_sideload_image($image_url, 0, '', 'src');
		if(!is_wp_error($media)) {
			self::$img_src_to_upload_url[$item] = $media;
		}
      }
      // $item
    }
  } // fix_img_path


  static function download_template_file() {
    // Template key
    $key = trim($_POST['template_key']);
    
    global $leadflow_lc;
	$auth_query = '&key='.$leadflow_lc->get_decryptedoption($leadflow_lc->authkey).'&domain='.$_SERVER['SERVER_NAME'].'&email='.$leadflow_lc->get_decryptedoption($leadflow_lc->email);
    
    // Fetch template setup array
    $call_proxy = wp_remote_get(LF_TEMPLATES_SERVER . '?fetch-templates=true&template_key=' . $key . $auth_query, array('sslverify' => false));
	// Decode template setup array
    $template = json_decode($call_proxy['body']);

    // Get template data url
    $template_data_url = $template->data->template_data;
    self::$template_folder_url = $template->data->template_url;

    // Remote get template data url
    $template_data = wp_remote_get($template_data_url, array('sslverify' => false));

    // If the template data url exists and is reachable
    if (!empty($template_data['response']['code']) && $template_data['response']['code'] == 200) {
      $optin_layout = base64_decode($template_data['body']);
      $optin_layout = unserialize($optin_layout);
	  array_walk_recursive($optin_layout, array(__CLASS__, 'fix_img_path'));

      // After recursive - MUST
      $optin_layout = json_encode($optin_layout);
      foreach (self::$img_src_to_upload_url as $img_key => $img_url) {
        $optin_layout = str_replace($img_key, $img_url, $optin_layout);
      }
      // Json decode before saving
      $optin_layout = json_decode($optin_layout, true);
      $optin_layout = serialize($optin_layout);
      $installed_templates = get_option(LF_INSTALLED_TEMPLATES);
	  update_option('lfp_template_downloaded', $template);
      $installed_templates[$key]['version'] = $template->data->template_version;
      $installed_templates[$key]['types'] = $template->data->template_types;
      $installed_templates[$key]['thumb'] = $template->data->thumb;
      $installed_templates[$key]['name'] = $template->data->name;
      $installed_templates[$key]['url'] = $template->data->url;
      $installed_templates[$key]['layout'] = $optin_layout;
	  $installed_templates[$key]['description'] = $template->data->description;

      ksort($installed_templates);

      update_option(LF_INSTALLED_TEMPLATES, $installed_templates);	  
      wp_send_json_success('Download done.');
    }

    // Error
    wp_send_json_error('Download failed, maybe template data file does not exist.');
  } // download_template_file


  static function cron_download_templates() {
    // Send a call to server
    
	global $leadflow_lc;
	$auth_query = '&key='.$leadflow_lc->get_decryptedoption($leadflow_lc->authkey).'&domain='.$_SERVER['SERVER_NAME'].'&email='.$leadflow_lc->get_decryptedoption($leadflow_lc->email);
    
    $call_proxy = wp_remote_get(LF_TEMPLATES_SERVER . '?fetch-templates=true' . $auth_query, array('sslverify' => false));
    
    if (is_wp_error($call_proxy) || $call_proxy['body'] == '0' || empty($call_proxy['body'])) {
      update_option( LF_TEMPLATES_CRON, time().' || Error - License invalid.' );
    } else {
      $body = json_decode($call_proxy['body']);

      if ($body->success) {
        $templates = json_decode($call_proxy['body']);
        $templates = $templates->data->templates;
        update_option(LF_TEMPLATES_OPTION, $templates);
		update_option( LF_TEMPLATES_CRON, time().' || Templates updated.' );
      } else {
        update_option( LF_TEMPLATES_CRON, time().' || Error - License invalid.' );
      }
    }
  } // download_templates


	
  static function download_templates() {
    // Send a call to server
    
	global $leadflow_lc;
	$auth_query = '&key='.$leadflow_lc->get_decryptedoption($leadflow_lc->authkey).'&domain='.$_SERVER['SERVER_NAME'].'&email='.$leadflow_lc->get_decryptedoption($leadflow_lc->email);
    
    $call_proxy = wp_remote_get(LF_TEMPLATES_SERVER . '?fetch-templates=true' . $auth_query);
    
    if (is_wp_error($call_proxy) || $call_proxy['body'] == '0' || empty($call_proxy['body'])) {
      wp_send_json_error('Error - License invalid.');
    } else {
      $body = json_decode($call_proxy['body']);

      if ($body->success) {
        $templates = json_decode($call_proxy['body']);
        $templates = $templates->data->templates;
        update_option(LF_TEMPLATES_OPTION, $templates);
        wp_send_json_success('Templates updated.');
      } else {
        wp_send_json_error('Error - License invalid.');
      }
    }

    wp_send_json_error('Error occured.');
  } // download_templates


  static function settings() {

    echo '<div id="leadflow-options-page-tabs">';
    echo '<div class="container" style="padding:0px;">';

    // download
    echo '<div id="download-geoip">';
    echo '<table class="form-table">';
    echo '<tbody>';
    echo '<tr>
    <td colspan="2"><label style="display: inline-block; line-height: 45px; padding-right: 20px;" for="download_templates">Refresh the list of available templates</label><input type="button" id="download_templates" value="Refresh" class="button button-primary" /></td>
    </tr>';
    echo '<tr>';
    echo '<td colspan="2">';
    echo '<hr/>';
    echo '<h3>Available templates:</h3>';

    $templates = get_option(LF_TEMPLATES_OPTION);

    if (!empty($templates)) {

      $installed_templates = get_option(LF_INSTALLED_TEMPLATES);


      echo '<ul class="lf-template-list">';
      foreach ($templates as $key => $template) {

        // Vars
        if (!empty($installed_templates[$key])) {
          $installed_version = $installed_templates[$key]['version'];
        } else {
          $installed_version = 'Not Installed.';
        }
        $remote_version = $template->version;

        echo '<li>';
        echo '<h3>' . $template->name . '</h3>';
        echo '<img src="' . $template->thumb . '"/>';

        if (!empty($installed_version)) {
          echo '<div><b>Installed:</b> ' . $installed_version . '</div>';
        } elseif (!empty($installed_templates[$key])) {
          echo '<div><b>Installed:</b> Unknown.</div>';
        } else {
          echo '<div><b>Not Installed.</b></div>';
        }

        if (!empty($remote_version)) {
          echo '<div><b>Available:</b> ' . $template->version . '</div>';
        }

        if (!empty($template->types)) {
          echo '<div><b>Optin types: </b>';
          $out = '';
          foreach ($template->types as $k => $type) {
            $out .= ucfirst($type) . ', ';
          }
          $out = rtrim($out, ', ');
          echo $out;
          echo '</div>';
        }

		if (!empty($template->url)) {
			echo '<a class="lf-preview-template button button-primary" target="_blank" href="'.$template->url.'">Preview</a>';
		}

        if (!empty($installed_templates[$key])) {

          if (version_compare($remote_version, $installed_version, '>')) {
            echo '<a href="#" class="lf-download-template button button-primary button-update red" data-template-key="' . $key . '">Update</a>';
          } else {
            echo '<a href="#" class="lf-download-template button button-primary button-update" data-template-key="' . $key . '">Re-Download</a>';
          }


        } else {
          echo '<a href="#" class="lf-download-template button button-primary" data-template-key="' . $key . '">Download</a>';
        }

        echo '</li>';
      }
      echo '</ul>';
    }

    echo '</td>';
    echo '</tr>';
    echo '</tbody>';
    echo '</table>';
    echo '</div>';


    echo '</div>';
  } // settings



} // leadflow_templates