<?php
/**
* LeadsFlow ProPro Integration
*
* Allows integration with LeadsFlowPro
*
* @class 		WC_Integration_LeadsFlowPro
* @extends		WC_Integration
* @version		1.0.1
* @package		WooCommerce LeadsFlowPro
*/

class leadflow_woocommerce_integration extends WC_Integration {

  /**
  * Init and hook in the integration.
  *
  * @access public
  * @return void
  */
  public function __construct() {

    $this->id                 = 'leadsflowpro';
    $this->method_title       = __( 'LeadsFlowPro', 'wc_leadsflowpro' );
    $this->method_description = __( 'LeadsFlowPro is a popular lead generation, tracking and management system for Wordpress.', 'wc_leadsflowpro' );

    // Load the settings.
    $this->init_settings();

    $this->init_form_fields();

    // Hooks
    add_action('woocommerce_update_options_integration', array($this, 'process_admin_options'));
    add_action('woocommerce_update_options_integration_' . $this->id, array($this, 'process_admin_options'));

    // Checkout change status
    add_action('woocommerce_checkout_update_order_meta', array($this, 'order_status_changed' ), 1000, 1);

    // Admin change status
    add_action('woocommerce_order_status_changed', array($this, 'order_status_changed' ), 10, 3);
  } // __construct


  /**
  * order_status_changed function.
  *
  * @access public
  * @return void
  */
  public function order_status_changed($id, $status = 'new', $new_status = 'pending') {
    global $woocommerce;

    if ($new_status == 'completed') {
      $order = $this->wc_get_order($id);

      $flow_settings = get_option('woocommerce_leadsflowpro_settings');
      $flow_id = $flow_settings['lfp_flow_id'];

      $firstname = get_post_meta($order->id, '_billing_first_name', true);
      $lastname = get_post_meta($order->id, '_billing_last_name', true);

      lfp_ecommerce_flow($flow_id, array('email' => $order->billing_email, 'price' => $woocommerce->cart->total, 'firstname' => $firstname, 'lastname' => $lastname));
    }
  } // order_status_changed


  /**
  * Initialize Settings Form Fields
  *
  * @access public
  * @return void
  */
  function init_form_fields() {
    $leadflows = array();

    if ( is_admin() && ! is_ajax() ) {
      $flow_lists = array('0' => 'None, disable integration');
      $flows = get_posts(array('post_type' => 'lead-flows', 'posts_per_page' => -1, 'meta_key' => 'flow_type', 'meta_value' => 'ecommerce', 'order' => 'ASC', 'orderby' => 'title', 'post_status' => 'publish'));
      if ($flows) {
        foreach ($flows as $flow) {
          if ($flow->post_title) {
            $flow_lists[$flow->ID] = $flow->post_title;  
          } else {
            $flow_lists[$flow->ID] = '(no title)';
          }
        }
      }

      $this->form_fields = array(
        'lfp_flow_id' => array(
          'title'       => 'LFP Ecommerce Flow',
          'type'        => 'select',
          'description' => 'Select the LeadsFlow Pro Ecommerce Flow that will process all WooCommerce orders.',
          'default'     => '0',
          'options'     => $flow_lists,
        )
      );
    }
  } // End init_form_fields()


  private function wc_get_order( $order_id ) {
    if ( function_exists( 'wc_get_order' ) ) {
      return wc_get_order( $order_id );
    } else {
      return new WC_Order( $order_id );
    }
  } // wc_get_order
  

  /**
  * Admin Panel Options
  */
  function admin_options() {
    echo '<h3>LeadsFlow Pro</h3>';
    echo '<p>Select the Ecommerce Flow that will handle all your WooCommerce orders. Orders themselves will not be changed in any way.</p>';
    echo '<table class="form-table">';
    $this->generate_settings_html();
    echo '</table>';
  } // admin_options

} // WC_Integration_LeadsFlowPro