/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

jQuery(document).ready(function($){

  var pushed = 0;
  var errors = 0;
  var skipped = 0;
  var total = 0;
  var offset = 0;
  var total_fails = 0;
  var failed_offsets = [];
  var loops = 0;
  
  $(document).ajaxError(function (e, jqXHR, ajaxSettings, thrownError) {
    return;
});

  $('form[name="lf-flow-push-ajax"]').on('submit', function(e){
    
    e.preventDefault();
    var form = $(this);
    var submit_btn = $('#submit', form);
  
    // Get inputs
    var records = $('input[name="lf-subscriber-records"]', form).val();
    var query = $('input[name="lf-subscriber-query"]', form).val();
    var selected = $('input[name="lf-subscriber-selected"]', form).val();
    var flow_id = $('input[name="lf-subscriber-flow"]', form).val();
    var insert_per_call = 10;
	
    // Quick fix if we have less records then insers per row
    if (records < 10) {
      insert_per_call = 1;
    }
	
    // Ajax Params
    var params = {records:records, offset:offset, query:query, selected_users:selected, insert_per_call:insert_per_call, flow_id:flow_id};
    
    startingpoint = $.Deferred();
    startingpoint.resolve();
    
    
    
    // Total number of required loops
    loops = Math.ceil(records/insert_per_call);
    
    // Disable button while working
    $('#lf-push-data-btn').addClass('loading');
	$('#lf-flow-push-status').show();
	do_push(params);
    
    return false;
  });
  
  // handle each individual ajax call
  function do_push(params) {
	return $.ajax({ type: 'POST',
      url: ajaxurl,
	  data: {action: 'lf_push_flow',  
             offset: params.offset, 
             insert_per_call: params.insert_per_call,
             skip:params.skip,
             selected_users:params.selected_users,
             query:params.query,
             flow_id:params.flow_id
      },
      dataType: 'json'})
      .always(function(response) {
		if(total_fails>10){
		  return false;	 
		}	 
		 
		if(typeof response.data !== 'undefined'){			 
		  if (!response.success) {
			alert('Invalid option. Please reload');
			return;
		  }
		  
		  if(response.data){
			  pushed += response.data.pushed;
			  errors += response.data.errors;
		  }
		  
		  if(response.data.errors){
			 jQuery('#lf-push-debugger').show();
			 jQuery('#lf-push-debugger').append(response.data.error_msg);	
			 jQuery('#lf-push-debugger').scrollTop(jQuery('#lf-push-debugger').prop("scrollHeight"));
		  }		 
		} 
				
		if(pushed == params.records){
			jQuery('.lf-progress').hide();	
			jQuery('#lf-push-data-btn').hide();	
			jQuery('.lf-push-finished').show();
		}
		
		$('#lf-pushed-rows>span', '#lf-flow-push-status').html(pushed);
		$('#lf-errors-rows>span', '#lf-flow-push-status').html(errors);
		
		
		if (loops == params.offset+1) {
		  progress = 100;
		} else {
		  progress = Math.round((((params.offset+1)*params.insert_per_call)/params.records)*100);
		}
				
		$('div.lf-progress-bar', '#lf-flow-push-status').css('width',progress + '%');
		$('div.lf-progress-text', '#lf-flow-push-status').html(progress + '%');
		params.offset++;	
		if (params.offset<loops){		
		  do_push(params);			
		} else {
		  $('.lf-progress').hide();	
		  $('#lf-push-data-btn').hide();	
	      $('.lf-push-finished').show();	
		  if(pushed == params.records){
			$('.lf-push-finished').html('Flow Push Finished');	
		  } else {
			$('.lf-push-finished').html('Flow Push Finished with errors');	 
		  }
		  $('div.lf-progress-bar', '#lf-flow-push-status').css('width','100%');
		  $('div.lf-progress-text', '#lf-flow-push-status').html('100%');	
		}
      }) // success
      .fail(function(response){
		if(total_fails>10){
		   jQuery('#lf-push-debugger').append('Push stopped. Please check your server configuration and try again.<br />'); 	 
        } else {  
		   total_fails++;
		   errors += params.insert_per_call;
		   jQuery('#lf-push-debugger').show();
		   $('#lf-errors-rows>span', '#lf-flow-push-status').html(errors);
		   var start_fail=params.offset*params.insert_per_call-params.insert_per_call;
		   var end_fail=start_fail+10;
		   jQuery('#lf-push-debugger').append('Error: Subscribers '+start_fail+' to '+end_fail+' were not processed. Server request failed: '+response.status+'<br />');
		   jQuery('#lf-push-debugger').scrollTop(jQuery('#lf-push-debugger').prop("scrollHeight"));
		}
      });
	  
    } // do_push

}); // jQuery.ready