/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

jQuery(document).ready(function($){
  
  var tmp_fseek = 0;
  var updated = 0;
  var inserted = 0;
  var invalid = 0;
  var skipped = 0;
  var total = 0;
  
  $('.lf-setting-var').select2_sortable({
   placeholder: "Select",
   allowClear: true,
   tags:true,
  });
  
  // Import CSV Ajax
  $('form[name="lf-test-settings"]').on('submit', function(e){
    var form_status = false;
    var form_email = false;
    $('.lf-setting-var').each(function(i, item) {
      val = $(item).val();
      if (val != 'ignore') {
        form_status = true;
      }
      
      if (val == 'email') {
        form_email = true;
      }
    });
    
    if (form_status && form_email) {
      return true;
    } else {
      if (!form_email) {
        alert('You need to specify at least one relationship as e-mail!');
      } else if (!form_status) {
        alert('You need to specify at least one relationship!');
      }
      return false;
    }
    
  });
  
  $('form[name="lf-import-csv-ajax"]').on('submit', function(e){
    e.preventDefault();
    var form = $(this);
  
    // Get inputs
    var file = $('input[name="lf-csv-import"]', form).val();
    var settings = $('input[name="lf-setting-var"]', form).val();
    var tags = $('input[name="lf-import-tags"]', form).val();
    var records = $('input[name="lf-csv-records"]', form).val();
    var insert_per_call = $('input[name="lf-csv-insert-per-ajax"]', form).val();
    var skip_if_exists = $('input[name="lf-csv-exists"]').val();
    var delimiter = $('input[name="lf-csv-delimiter"]', form).val();
    var enclosure = $('input[name="lf-csv-enclosure"]', form).val();
    var escape = $('input[name="lf-csv-escape"]', form).val();

    
    // Ajax Params
    var params = {file:file, settings:settings, 
                  offset:0, insert_per_call:insert_per_call, 
                  tags:tags, skip:skip_if_exists, delimiter:delimiter, 
                  enclosure:enclosure, records:records, escape:escape};
    
    startingpoint = $.Deferred();
    startingpoint.resolve();
    
    // Quick fix if we have less records then insers per row
    if (records < 10) {
      insert_per_call = 1;
    }
    
    // Total number of required loops
    loops = Math.ceil(records/insert_per_call);
    
    // Disable button while working
    $('#lf-import-data-btn').attr('disabled', 'disabled');
    
    for (var i=0;i+1 <= loops; i++) {
      startingpoint = startingpoint.pipe( function() {
        $('#lf-import-sample-table').hide();
        $('#lf-import-status').show();
        params.offset++;
        
		// Current progress
        progress = Math.round( (params.offset/loops)*100 );
        
        $('div.lf-progress-bar', '#lf-import-status').css('width',progress + '%');
        $('div.lf-progress-text', '#lf-import-status').html(progress + '%');
        
        return do_import(params);
      });
    } // each action 
    
    return false;
  });
  
  // handle each individual ajax call
  function do_import(params) {
    return $.ajax({ type: 'POST',
      url: ajaxurl,
      data: {action: 'lf_import_csv', 
             file:params.file, 
             offset: params.offset, 
             insert_per_call: params.insert_per_call,
             settings:params.settings,
             tags:params.tags,
             fseek_offset: tmp_fseek,
             skip:params.skip,
             delimiter:params.delimiter,
             enclosure:params.enclosure,
			 total:params.records,
             escape:params.escape
      },
      dataType: 'json'})
      .done(function(response) {
        if (!response.success) {
          alert('Invalid option. Please reload');
          return;
        }
        
        tmp_fseek = response.data.ftell;
        
        inserted += response.data.inserted; // fix for counting header
        skipped += response.data.skipped;
        updated += response.data.updated;
        invalid += response.data.invalid;
        total = inserted+skipped+updated+invalid;
        
		if(response.data.invalid>0){
			$('.lf-import-invalid').show();
			jQuery('.lf-import-invalid').append(response.data.invalid_emails+'<br />');						
		}
		
        $('#lf-inserted-rows>span', '#lf-import-status').html(inserted);
        $('#lf-skipped-rows>span', '#lf-import-status').html(skipped);
        $('#lf-updated-rows>span', '#lf-import-status').html(updated);
        $('#lf-total-rows>span', '#lf-import-status').html(total);
		
		if(invalid>0) {
			$('#lf-invalid-rows').show();
		}
        $('#lf-invalid-rows>span', '#lf-import-status').html(invalid);
        
		if(total == $('input[name="lf-csv-records"]').val()) {
			jQuery('.lf-progress').hide();
			jQuery('#lf-import-data-btn').hide();
			jQuery('.lf-import-finished').html('Import Finished');			
		}
      })
      .fail(function(response){
        alert('An undocumented error has occured. Please reload the page and try again.');
      });
  } // do_import

}); // jQuery.ready