/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/



jQuery(document).ready(function($){

  // Add new bulk action
  if($('select[name="action"]').length) {
    $('select[name="action"]').append('<option value="lf_bulk_edit">Edit Optin Tags</option>');
  }

  // Scroll from top
  if ($('body').hasClass('post-type-optin-pages')) {
    $(window).scroll(function() {
      if ($(this).scrollTop() >= 130) { // this refers to window
        $('#side-sortables').addClass('fixed');
      } else {
        $('#side-sortables').removeClass('fixed');
      }
    });
  }

  // Optin Type
  $('.optin_type_box').hover(function() {
    $(this).addClass('selected_hover');
    },
    function() {
      $(this).removeClass('selected_hover');
  });

  // Optin Template
  $('.optin_template_box').hover(function() {
    $(this).addClass('selected_hover');
    },
    function() {
      $(this).removeClass('selected_hover');
  });

  // Optin Type Selected
  $('.optin_type_box').on('click', function() {
    type = $(this).data('optin_type');

    $('#optin_type').val(type);
    $('.optin_type_box').removeClass('selected');
    $(this).addClass('selected');

    // Remove template
    $('.optin_template_box', '#optin-template').not(':first').hide();
    $('.optin_template_box.selected', '#optin-template').removeClass('selected');
    $('.optin_template_box:first-of-type', '#optin-template').addClass('selected');
    $('.optin_template_box.available_' + type, '#optin-template').show();

  });

  // Optin Template Selected
  
  var preview_template='';
  $('.optin_template_box').on('click', function() {
	$('.optin_template_box').removeClass('selected');  
	$(this).addClass('selected');  
	preview_template=$(this).data('optin_template');
	var preview_html='<div class="optin_template_preview_box_thumbnail"><img src="'+$(this).data('optin_template-thumb')+'" /></div>';
	preview_html+='<div class="optin_template_preview_box_title">'+$(this).data('optin_template-name')+'</div>';
	preview_html+='<div class="optin_template_preview_box_description">'+$(this).data('optin_template-description')+'</div>';
	if($(this).data('optin_template-url')) preview_html+='<a href="'+$(this).data('optin_template-url')+'" target="_blank" class="optin_template_preview_box_preview button button-primary"><i data-fip-value="icon-eye" class="icon-eye"></i>Preview</a>';
	preview_html+='<div class="optin_template_preview_box_warning">Applying this template will delete all widgets and settings for this optin.</div>';
	preview_html+='<div class="optin_template_preview_box_cancel button"><i data-fip-value="icon-cancel" class="icon-cancel"></i>Cancel</div>';
	preview_html+='<div class="optin_template_preview_box_apply button button-primary"><i data-fip-value="icon-ok" class="icon-ok"></i>Apply</div>';
	
	$('.optin_template_preview_box').html(preview_html);  
    $('.optin_template_preview_box_wrapper').show();  
    
  });
  
  $('.optin_template_preview_box').on('click', '.optin_template_preview_box_cancel', function(){
	  $('.optin_template_preview_box_wrapper').hide(); 
	  $('.optin_template_preview_box').html(''); 
	  preview_template='';
  });
  
  $('.optin_template_preview_box').on('click', '.optin_template_preview_box_apply', function(){
	  $('.optin_template_preview_box_wrapper').hide(); 
	  $('.optin_template_preview_box').html(''); 
	  $('#optin_template').val(preview_template);
	  $('#post').submit();
  });
  
  $(document).mouseup(function (e)
  {
	  var export_template_popup = $(".optin_template_preview_box");
  
	  if (!export_template_popup.is(e.target) 
		  && export_template_popup.has(e.target).length === 0) 
	  {
		  $('.optin_template_preview_box_wrapper').hide();
	  }
					  
  });
  
  

  $('#form_after-subscribe-url').lf_select2();
  $('#form_after-subscribe-url').on('change', function(e){
    var select = $(this);
    if ($(select).val() == 'custom-url') {
      $('.lf-after-subscribe-custom-url').show();
    } else {
      $('.lf-after-subscribe-custom-url').hide();
    }
  }).trigger('change');

  $('#popup_conditions, #popup_on_posts, #popup_on_pages, #popup_on_categories').lf_select2();

  $('#header_conditions, #header_on_posts, #header_on_pages, #header_on_categories').lf_select2();
 	
  $('#pullout_conditions, #pullout_on_posts, #pullout_on_pages, #pullout_on_categories').lf_select2();

  $('#welcome_conditions, #welcome_on_posts, #welcome_on_pages, #welcome_on_categories').lf_select2();


  // Optin Add New Widget
  $('.optin-layout').on('click', '.lf-add-widget', function(e){
    e.preventDefault();

    obj = $(this);
    row_id = $(obj).data('row-id');
    row = $(obj).closest('li.child');
    layout = $(obj).parents('ol.optin-layout');
    widget_dialog = $(layout).next('.widgets-dialog-outer-container');

    $('input[name="connect_to_row"]', widget_dialog).val(row_id);
    $(widget_dialog).show();

    return false;
  });

  // Optin Add New Widget - Selected Widget in Dialog
  $('.optin-available-widgets').on('click', 'a', function(e) {
    e.preventDefault();

    var obj = $(this);
    var container = $(this).closest('.widgets-dialog-outer-container');
    var row_id = $('input[name="connect_to_row"]', container).val();

    var target = $(this).parents('ul').data('connected-to');
    var optin_box = $(this).parents('ul').data('optin-box');
    var box = target; // first-box-layout, second-box-layout
    var target = $('#' + box);
    var ajax_action = 'lf_generate_widget_' + optin_box;

    var widget_type = $(this).parents('li').data('widget-type');
    var next_id = get_next_widget_id(target);

    var row_box = $('li[data-optin-widget-id="' + row_id + '"] ol', '#' + box);

    $.post(ajaxurl,
      {action: ajax_action, 'id': next_id, 'widget_type': widget_type, 'container_id':row_id},
      function(response) {
        if (response.success) {

          container.hide();
          tmp = $(response.data).appendTo(row_box).hide();
          $(tmp).slideDown(500);
		  	  
          widget_settings_init(tmp);
		  
		  active_widget_window = $(this).parents('.optin-layout');
    	  $('.widget-outer-container', tmp).show();
        } else {
          alert('Unable to add selected widget. Please reload the page and try again.');
        }
      },
      'json'
    ).fail(function() {
      alert('An unknown error has occured. Please reload the page and try again.');
    });

    return false;
  });
  
  
  $('.wrap').on('click', '.toggle_editor_visual', function(){
	 var editor_id=this.id.replace('_text-tmce','');
	 
	 $('#'+editor_id+'_text-html').removeClass('toggle_editor_active');
	 $('#'+editor_id+'_text-tmce').addClass('toggle_editor_active');
	 $('#'+editor_id).addClass('lfp-tinymce');
	 tinymce.init({
			selector: "textarea#"+editor_id, theme:"modern",skin:"lightgray",language:"en",formats:{alignleft: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"left"}},{selector: "img,table,dl.wp-caption", classes: "alignleft"}],aligncenter: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"center"}},{selector: "img,table,dl.wp-caption", classes: "aligncenter"}],alignright: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"right"}},{selector: "img,table,dl.wp-caption", classes: "alignright"}],strikethrough: {inline: "del"}},relative_urls:false,remove_script_host:false,convert_urls:false,browser_spellcheck:true,fix_list_elements:true,entities:"38,amp,60,lt,62,gt",entity_encoding:"raw",keep_styles:false,cache_suffix:"wp-mce-4208-20151113",preview_styles:"font-family font-size font-weight font-style text-decoration text-transform",end_container_on_empty_block:true,wpeditimage_disable_captions:false,wpeditimage_html5_captions:true,plugins:"charmap,colorpicker,hr,lists,media,paste,tabfocus,textcolor,fullscreen,wordpress,wpautoresize,wpeditimage,wpemoji,wpgallery,wplink,wpdialogs,wptextpattern,wpview,wpembed",wp_lang_attr:"en-US",resize:"vertical",menubar:false,wpautop:true,indent:false,toolbar1:"bold,italic,strikethrough,bullist,numlist,blockquote,hr,alignleft,aligncenter,alignright,link,unlink,wp_more,spellchecker,fullscreen,wp_adv",toolbar2:"formatselect,underline,alignjustify,forecolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help",toolbar3:"",toolbar4:"",tabfocus_elements:":prev,:next",body_class:"optin_widget_first_optin_2_settings_text post-type-optin-pages post-status-publish locale-en-us"
	}); 
  });
  
  $('.wrap').on('click', '.toggle_editor_text', function(){
	 var editor_id=this.id.replace('_text-html','');
	 $('#'+editor_id+'_text-tmce').removeClass('toggle_editor_active');
	 $('#'+editor_id+'_text-html').addClass('toggle_editor_active');
	 $('#'+editor_id).removeClass('lfp-tinymce');
	 tinyMCE.execCommand('mceRemoveEditor', false, editor_id); 
  });

  // Optin Add New Row
  $('.lf-add-row').on('click', function(e){
    e.preventDefault();

    var obj = $(this);
    target = $(obj).closest('.optin-layout');
    box = $(target).attr('id'); // first-box-layout, second-box-layout
    target = $('#' + box);

    if (box == 'first-optin-layout') {
      ajax_action = 'lf_generate_widget_first_optin';
    } else {
      ajax_action = 'lf_generate_widget_second_optin';
    }


    widget_type = $(this).parents('li').data('widget-type');
    next_id = get_next_widget_id(target);

    $.post(ajaxurl,
      {action: ajax_action, 'id': next_id, 'widget_type': 'row', 'container_id':'0'},
      function(response) {
        if (response.success) {
          tmp = $(response.data).insertBefore('ol#' + box + '>li:last-child').hide();
          $(tmp).slideDown(500);
          widget_settings_init(tmp);
        } else {
          alert('Unable to add selected widget. Please reload the page and try again.');
        }
      },
      'json'
    ).fail(function() {
      alert('An unknown error has occured. Please reload the page and try again.');
    });

    return false;
  });


  function get_next_widget_id(container) {
    max = 0;

    $('li.row, li.child', container).each(function(ind, element) {
      if ($(element).data('optin-widget-id') > max) {
        max = $(element).data('optin-widget-id');
      }
    });

    return max + 1;
  } // get_next_widget_id

  // ----------------------

  $('#customurl-parse-html').on('click', function(e) {
    e.preventDefault();
    html = $.parseHTML('<div id="parse-tmp">' + $('#optin-form_custom-url-html').val() + '</div>');

    $('#optin-form_custom-url').val($('form', html).attr('action'));

    params = '';
    $('input[type=hidden]', html).each(function(ind, el) {
      params += $(el).attr('name') + '=' + $(el).attr('value') + '&';
    });

    $('#optin-form_custom-url-extra').val(params);

    inputs = '';
    $('input[type=text]', html).each(function(ind, el) {
      name = $(el).attr('name');
      if (name == 'email' || name == 'from') {
        $('#optin-form_custom-email-field').val(name);
        inputs = '';
        return false;
      } else {
        inputs += ' ' + $(el).attr('name') + "\n";
      }
    });
    if (inputs) {
      alert('Important! Your custom form does NOT contain the "email" input field. The field in your form has a different name. Please check which field it is and enter the value in the "Form Email Field". Here is the list of fields we found:\n' + inputs);
    } else {
      alert('Done parsing the form!');
    }
  });

  // Media Upload
  if ($('.set_custom_images').length > 0) {
    if ( typeof wp !== 'undefined' && wp.media && wp.media.editor) {
      $('.wrap').on('click', '.set_custom_images', function(e) {
        e.preventDefault();
        var button = $(this);
        var id = button.prev();
        custom_uploader = wp.media.frames.file_frame = wp.media({
          title: 'Choose image',
          button: {
            text: 'Use selected image'
          },
          multiple: false
        });
        custom_uploader.on('select', function() {
          attachment = custom_uploader.state().get('selection').first().toJSON();
          id.val(attachment.url);
          id.prev().find('img').attr('src', attachment.url);
        });
        custom_uploader.open();
      });
    }
  }

  // Add Background Field
  $('.add-new-bg').click(function(){
    var holder = $(this).prev('.bg-input-holder');
    var input = $('.bg-input:last-of-type', holder);
    var clone = $(input).clone();
    $('input', clone).val('');
    clone.appendTo(holder);
    return false;
  });

  // Remove Background
  $('.remove-bg').click(function(){
    $(this).parent().remove();
    return false;
  });

  // Remove Background
  $('.remove-bg2').click(function(){
    $(this).siblings('input').val('');
    return false;
  });

  // After Subscribe
  $('#form_after-subscribe-action').change(function(){
    var selected = $(this).val();
    $('.redirect, .stay-alert').hide();
    if (selected == 'hide') { selected = 'stay-alert'; }
    $('.' + selected).show();
	
    if (selected == 'redirect' && $('#form_after-subscribe-url').val() == 'custom-url') {
      $('.redirect-custom-url').show();
    } else {
      $('.redirect-custom-url').hide();
    }

  });
  
  $('#form_after-subscribe-url').change(function(){
	var selected = $(this).val();
	
	if (selected == 'custom-url') {
      $('.redirect-custom-url').show();
    } else {
      $('.redirect-custom-url').hide();
    }
  });
  
  $('#form_after-subscribe-action').trigger('change');

  // Prevent from Leaving
  $('#general_prevent-from-leaving').change(function(){
    var selected = $(this).val();
    if (selected == '1') {
      $('.prevent-alert').show();
    } else {
      $('.prevent-alert').hide();
    }
  });
  $('#general_prevent-from-leaving').trigger('change');

  // background type
  $('#background_type').change(function(){
    var selected = $(this).val();
    if (selected == 'image') {
      $('.bg-slider').hide();
      $('.bg-image').show();
      $('.bg-video').hide();
    } else if (selected == 'video') {
      $('.bg-slider').hide();
      $('.bg-image').hide();
      $('.bg-video').show();
    } else if (selected == 'slider') {
      $('.bg-slider').show();
      $('.bg-image').hide();
      $('.bg-video').hide();
    } else {
      alert('Undocumented error. Unknown background type. Please reaload the page.');
    }
  });
  $('#background_type').trigger('change');

  // form fields
  $('#optin-form_form-fields').change(function(){
    selected = $(this).val();
    if (selected == 'email') {
      $('.placeholder-name-row').hide();
    } else {
      $('.placeholder-name-row').show();
    }
  });
  $('#optin-form_form-fields').trigger('change');

  $('.refresh-lists').on('click', function() {
    if(confirm('Page will reload. All unsaved changes will be lost. Continue?')) {
      return true;
    } else {
      return false;
    }
  });

  $('#clone-optin').on('click', function() {
    if(confirm('Page will not be saved before cloning. All unsaved changes will be lost. Continue?')) {
      return true;
    } else {
      return false;
    }
  });


  // Live Functions
  function widget_settings_init(widget) {
    // Icon Picker
    var fnt_icons_categorized = {
      'Web Application Icons' : ["icon-mail", "icon-mail-alt", "icon-th-large", "icon-th", "icon-th-list", "icon-help-circled", "icon-info-circled", "icon-info", "icon-home", "icon-link", "icon-unlink", "icon-link-ext", "icon-link-ext-alt", "icon-attach", "icon-tag", "icon-tags", "icon-bookmark", "icon-bookmark-empty", "icon-download", "icon-upload", "icon-download-cloud", "icon-upload-cloud", "icon-reply", "icon-reply-all"],
      'Form Control Icons' : ["icon-search", "icon-ok", "icon-ok-circled", "icon-ok-circled2", "icon-ok-squared", "icon-cancel", "icon-cancel-circled", "icon-cancel-circled2", "icon-plus", "icon-plus-circled", "icon-plus-squared", "icon-plus-squared-small", "icon-minus", "icon-minus-circled", "icon-minus-squared", "icon-minus-squared-alt", "icon-minus-squared-small", "icon-quote-right", "icon-code", "icon-comment-empty", "icon-chat-empty"],'Media Icons' : ["icon-video", "icon-videocam", "icon-picture", "icon-camera", "icon-camera-alt", "icon-export", "icon-export-alt", "icon-pencil", "icon-pencil-squared", "icon-edit", "icon-print"],
      'Popular Icons' : ["icon-heart", "icon-heart-empty", "icon-star", "icon-star-empty", "icon-star-half", "icon-star-half-alt", "icon-user", "icon-users", "icon-male", "icon-female", "icon-forward", "icon-quote-left", "icon-retweet", "icon-keyboard", "icon-gamepad", "icon-comment", "icon-chat"],'Others' : ["icon-music", "icon-help", "icon-lock", "icon-lock-open", "icon-lock-open-alt", "icon-pin", "icon-eye", "icon-eye-off", "icon-flag", "icon-flag-empty", "icon-flag-checkered", "icon-thumbs-up", "icon-thumbs-down", "icon-thumbs-up-alt", "icon-thumbs-down-alt", "icon-bell", "icon-bell-alt"]};

    $('.icon-select', widget).fontIconPicker({
      source: fnt_icons_categorized,
      theme: 'fip-darkgrey'
    });

    // Datetime picker
    $('.datetimepicker', widget).datetimepicker({ dateFormat: "dd/mm/yy"});

    // ImagePicker
    $('.image-picker', widget).imagepicker();

    // WP ColorPicker
    $('.colorpicker').wpColorPicker();


    // Button Type Picker
    $('.lf-widget-button-type').on('change', function(e){
      var parent = $(this).parents('.widget-ic-inner');
      var selected = $(this).val();
      $('#image-button, #css-button', parent).hide();
      $('#' + selected + '-button', parent).show();
    });

    // Button Style Picker
    $('.lf-css-button-style').on('change', function(){
      var parent = $(this).parents('.widget-ic-inner');
      var selected = $(this).val();
      var sample = $('.lf-button-sample', parent);
      $('a', sample).attr('class', selected);
    });

    // Row Drag
    $('.optin-layout').sortable({
      handle:'.move_row'
    });

    // Widget Drag
    $('.optin-layout>li ol').sortable({
      handle:'.move_widget',
      connectWith: '.optin-layout>li ol',
      placeholder: 'ph',
      dropOnEmpty: true,
      stop:function(event, ui) {

        widget = $(ui.item);
        parent_row = $(widget).closest('li.row');
        parent_row_ID = $(parent_row).data('optin-widget-id');
        $('input.container_id', widget).val(parent_row_ID);

      }
    });

    // edit optin row
    $(widget).on('click', 'a.edit_row', function(e){
      e.preventDefault();

      row = $(this).closest('li.row');
      $('.row-outer-container', row).show();

      return false;
    });

    // resize optin widget
    $(widget).on('click', 'a.width_widget', function(e){
      e.preventDefault();

      widget = $(this).closest('li.child');
      optin_id = $(this).closest('.optin-layout').attr('id');


      if (optin_id == 'first-optin-layout') {
        box = 'first_optin';
      } else {
        box = 'second_optin';
      }

      if ($(widget).hasClass('col-lg-12')) {
        widget_id = $(widget).data('optin-widget-id');
        width = $('input[name="optin_widget[' + box + '][' + widget_id + '][width]"]', widget).val('col-lg-6');

        $(widget).removeClass('col-lg-12').addClass('col-lg-6');
        $('.width_widget i', widget).removeClass('icon-resize-small').addClass('icon-resize-full');
      } else if ($(widget).hasClass('col-lg-6')) {
        widget_id = $(widget).data('optin-widget-id');
        width = $('input[name="optin_widget[' + box + '][' + widget_id + '][width]"]', widget).val('col-lg-12');

        $(widget).removeClass('col-lg-6').addClass('col-lg-12');
        $('.width_widget i', widget).removeClass('icon-resize-full').addClass('icon-resize-small');
      }

      return false;
    });

    // resize optin row
    $(widget).on('click', 'a.width_row', function(e){
      e.preventDefault();

      row = $(this).closest('li.row');
      optin_id = $(this).closest('.optin-layout').attr('id');

      if (optin_id == 'first-optin-layout') {
        box = 'first_optin';
      } else {
        box = 'second_optin';
      }

      if ($(row).hasClass('col-lg-12')) {
        widget_id = $(row).data('optin-widget-id');
        width = $('input[name="optin_row[' + box + '][' + widget_id + '][settings][width]"]', row).val('col-lg-6');

        $(row).removeClass('col-lg-12').addClass('col-lg-6');
        $('.width_row i', row).removeClass('icon-resize-small').addClass('icon-resize-full');
      } else if ($(row).hasClass('col-lg-6')) {
        widget_id = $(row).data('optin-widget-id');
        width = $('input[name="optin_row[' + box + '][' + widget_id + '][settings][width]"]', row).val('col-lg-12');

        $(row).removeClass('col-lg-6').addClass('col-lg-12');
        $('.width_row i', row).removeClass('icon-resize-full').addClass('icon-resize-small');
      }

      return false;
    });

    
    
     
    // edit optin widget
    $(widget).on('click', 'a.edit_widget', function(e){
      e.preventDefault();

      widget = $(this).closest('li.child');
      active_widget_window = $(this).parents('.optin-layout');

      $('.widget-outer-container', widget).show();

      return false;
    });

    // outer layer click
    $('.widgets-dialog-outer-container').on('click', function(e){
      if ($(e.toElement).hasClass('widgets-dialog-outer-container')) {
        $(e.toElement).hide();
      }
    });

    $('.lf-widget-type-close').on('click', function(e){
      $(this).parents('.widgets-dialog-outer-container').hide();
      e.preventDefault();
      return false;
    });

    $('.lf-widget-settings-close').on('click', function(e){
      reset_widget_settings();
      
      var outer = $(this).parents('.widget-outer-container');
      
      outer.hide();
      e.preventDefault();
      return false;
    });

    // outer layer click
    $(widget).on('click', function(e){
      if ($(e.toElement).hasClass('widget-outer-container')) {
        reset_widget_settings();
        $(e.toElement).hide();
      }
    });

    // outer layer click
    $(widget).on('click', function(e){
      if ($(e.toElement).hasClass('row-outer-container')) {
        reset_row_settings();
        $(e.toElement).hide();
      }
    });

    // esc key press
    $(document).keyup(function(e) {
      if (e.keyCode == 27) { // escape key maps to keycode `27`
        $('.widget-outer-container').hide();
        $('.row-outer-container').hide();
      }
    });

    // close edit optin widget dialog
    $(widget).on('click', 'a.widget-inner-close', function(e){
      e.preventDefault();
      overwrite_old_settings();
      dialog = $(this).parents('.widget-outer-container');
      parent = $(this).closest('li.child');
      
            
      // Set widget size
      var width = $('.lf-widget-widget_width', dialog).val();
      
      $(parent).removeClass('col-4');
      $(parent).removeClass('col-5');
      $(parent).removeClass('col-6');
      $(parent).removeClass('col-7');
      $(parent).removeClass('col-8');
      $(parent).removeClass('col-12');
      $(parent).addClass(width);
      
      $(dialog).hide();

      return false;
    });

    // close edit optin widget dialog
    $(widget).on('click', 'a.widget-inner-cancel', function(e){
      //reset_widget_settings();
      $(this).parents('.widget-outer-container').hide();
      e.preventDefault();
      return false;
    });


    // close edit row dialog
    $(widget).on('click', 'a.row-inner-close', function(e){
      e.preventDefault();
      overwrite_row_old_settings();

      dialog = $(this).parents('.row-outer-container');
      parent = $(this).closest('li.row');

      $(dialog).hide();

      return false;
    });


    $(widget).on('click', 'a.row-inner-cancel', function(e){
      e.preventDefault();

      reset_row_settings();
      dialog = $(this).parents('.row-outer-container');
      parent = $(this).closest('li.row');

      $(dialog).hide();

      return false;
    });


    $(widget).on('click', 'a.lf-row-settings-close', function(e){
      reset_row_settings();
      $(this).parents('.row-outer-container').hide();
      e.preventDefault();
      return false;
    });

    // remove optin row
    $(widget).on('click', 'a.remove_row', function(e){
      e.preventDefault();

      if (confirm('Are you sure you want to remove the selected Optin row?')) {
        row = $(this).parents('li.row');
        $(row).slideUp(500, function(){
          $(row).remove();
        });
      }

      return false;
    });

    // remove optin widget
    $(widget).on('click', 'a.remove_widget', function(e){
      e.preventDefault();

      if (confirm('Are you sure you want to remove the selected Optin widget?')) {
        widget = $(this).closest('li.child');
        $(widget).slideUp(500, function(){
          $(widget).remove();
        });
      }

      return false;
    });
	
  }

  widget_settings_init('.optin-layout');

  $('#minor-publishing-actions').html('<input type="submit" name="lf-optin-preview" value="Save & Preview" class="button button-primary lf-button-large" />');

  $('.postbox').each(function(i, item) {
    var description = $('p.description', item);
    if (description.length) {
      postbox = $('.handlediv', item);
      $('<div class="lf-more-info"><i class="dashicons dashicons-editor-help"></i></a>').insertAfter(postbox);
    }
  });

  $('.postbox h3').unbind('click');

  $('.postbox').on('click', '.lf-more-info', function(e){
    postbox = $(this).closest('.postbox');
    $('p.description', postbox).slideToggle(500);
    return false;
  });

  // Disabled optin box hide options
  $('#second-optin_disable-second-optin').trigger('change');
  $('#second-optin_disable-second-optin').on('change', function(e){
    e.preventDefault();

    obj = $(this);
    parent = $(obj).closest('.inside');

    if ($(obj).val() == '1') {
      $('.meta-container:not(:first-of-type),.lf-second-box-options', parent).hide();
    } else {
      $('.meta-container:not(:first-of-type),.lf-second-box-options', parent).show();
    }

    return false;
  });

  // Auto popup
  $('#popup_optin_auto_popup').trigger('change');
  $('#popup_optin_auto_popup').on('change', function(e) {
    e.preventDefault();

    value = $(this).val();

    if (value == '0') {
      $('#optin-conditional-options').hide();
    } else {
      $('#optin-conditional-options').show();
    }
  });

  // PHP Conditionals
  $('[name="_ab-test"]').trigger('change');
  $('[name="_ab-test"]').on('change', function(e) {

    e.preventDefault();

    value = $(this).val();

    if (value == '0') {
      $('#optin-php-conditional-options').show();
    } else {
      $('#optin-php-conditional-options').hide();
    }
  });

  // Auto popup
  $('#welcome_optin_auto_welcome').trigger('change');
  $('#welcome_optin_auto_welcome').on('change', function(e) {
    e.preventDefault();

    value = $(this).val();

    if (value == '0') {
      $('#optin-conditional-options').hide();
    } else {
      $('#optin-conditional-options').show();
    }
  });

  // enable/disable custom URL
  $('#general_custom_url').on('change', function() {
    if ($(this).val() == '1') {
      $('.custom_url_box').show();
    } else {
      $('.custom_url_box').hide();
    }
  }).trigger('change');
}); // onload


function reset_row_settings() {
  var $ = jQuery.noConflict();

  var row_settings_container = $('.row-outer-container:visible');
  var row_settings = $('input[type="text"],textarea,select', row_settings_container);
  $.each(row_settings, function(i, item) {
    old_value = $(item).attr('data-old-value');

    if ($(item).hasClass('colorpicker')) {
      $(item).wpColorPicker('color', old_value);
    }

    $(item).val(old_value);
  });

} // reset_row_settings


function overwrite_row_old_settings() {
  var $ = jQuery.noConflict();

  var row_settings_container = $('.row-outer-container:visible');
  var row_settings = $('input[type="text"],textarea,select', row_settings_container);

  $.each(row_settings, function(i, item) {
    value = $(item).val();

    if ($(item).hasClass('colorpicker')) {
      $(item).wpColorPicker('color', value);
    }

    $(item).attr('data-old-value', value);
  });
} // overwrite_row_old_settings


function reset_widget_settings() {
  var $ = jQuery.noConflict();

  var widget_settings_container = $('.widget-outer-container:visible');
  var widget_settings = $('input[type="text"],textarea,select', widget_settings_container);
  $.each(widget_settings, function(i, item) {
    old_value = $(item).attr('data-old-value');
    $(item).val(old_value);
  });

} // reset_widget_settings


function overwrite_old_settings() {
  var $ = jQuery.noConflict();

  var widget_settings_container = $('.widget-outer-container:visible');
  var widget_settings = $('input[type="text"],textarea,select', widget_settings_container);

  widget_preview(widget_settings_container, widget_settings);

  $.each(widget_settings, function(i, item) {
    value = $(item).val();
    $(item).attr('data-old-value', value);
  });
} // overwrite_old_settings


function widget_preview(widget_settings_container, settings) {
  var $ = jQuery.noConflict();

  widget_type = $('.lf-widget-type', widget_settings_container).val();
  
  var widget_id=$('.preview-editor', widget_settings_container).attr('id');
  var is_tinymce_active = $('#'+widget_id).hasClass('lfp-tinymce');
  widget_preview_field = $('.preview-editor', widget_settings_container).val();
		  
  widget = $(widget_settings_container).closest('li');
  $('.preview-field', widget).val(widget_preview_field);
  
  if(widget_preview_field) {
	  if(is_tinymce_active){	
	  	  $('.widget-preview', widget).html(tinyMCE.get(widget_id).getContent().replace(/<(?:.|\n)*?>/gm, ''));
	  } else {
	  	  if( widget_type == 'video'){
		    $('.widget-preview', widget).html(widget_preview_field);
		  } else if ( widget_type == 'image' ) {
		  	$('.widget-preview', widget).html('<img src="'+widget_preview_field+'" width="100" />');
		  } else {
		  	$('.widget-preview', widget).html(widget_preview_field.replace(/<(?:.|\n)*?>/gm, ''));
		  }
	  }
  }

} // widget_preview

jQuery(window).on('load', function(){
  if (jQuery(this).scrollTop() >= 130) { // this refers to window
    jQuery('#side-sortables').addClass('fixed');
  } else {
    jQuery('#side-sortables').removeClass('fixed');
  }
});



