/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

jQuery(document).ready(function($){

  $('#lf-settings-tabs').tabs({
    active: optin_active_tab(),
    activate: function(event, ui) {
      $.cookie('lf_settings_tab', $(this).tabs('option', 'active'), { expires: 30 });
    },
    beforeActivate: function(event, ui) {
      var old_tab = ui.oldTab;
      var new_tab = ui.newTab;

      $(old_tab).removeClass('nav-tab-active');
      $(new_tab).addClass('nav-tab-active');
    },
    create: function(event, ui) {
      $('#lf-settings-tabs .ui-state-active').addClass('nav-tab-active');
    }
  });

  function optin_active_tab() {
    hash = window.location.hash;
	hash = hash.replace('#', '');
    if (hash != '') {
      return parseInt(0+hash, 10);
    } else {
      return parseInt(0 + $.cookie('lf_settings_tab'), 10);
    }
  }


  $('#download_geoip').on('click', function(e){
    e.preventDefault();
    button = this;
    $(button).addClass('loading');

    $.ajax({type:'POST',
           url: ajaxurl,
           data: {
             action: 'lf_download_geoip',
             geoip_check: 'true',
             force: 'true'
           },
           dataType: 'json',
           }).done(function(response){
             if (response.success) {
               window.location.reload();
             } else {
               alert(response.data);
             }
           }).fail(function(response) {
             alert('An undocumented error has occured. Please reload the page and try again.');
           }).always(function(response) {
             $(button).removeClass('loading');
           });

    return false;
  }); // download geoip


  $('.lf-download-template').on('click', function(e){
    e.preventDefault();
    button = this;
    $(button).addClass('loading');

    $.ajax({type:'POST',
           url: ajaxurl,
           data: {
             action: 'lf_download_template_file',
             template_key: $(this).data('template-key'),
             force: 'true'
           },
           dataType: 'json',
           }).done(function(response){
             if (response.success) {
               if ($(button).hasClass('button-update')) {
                 alert('Template has been updated. The page will reload.');
               } else {
                 alert('Template has been downloaded. The page will reload.');
               }
               window.location.reload();
             } else {
               alert(response.data);
             }
           }).fail(function(response) {
             alert('An undocumented error has occured. Please reload the page and try again.');
           }).always(function(response) {
             $(button).removeClass('loading');
           });

    return false;
  }); // download_template_file


  $('#download_templates').on('click', function(e){
    e.preventDefault();
    button = this;
    $(button).addClass('loading');

    $.ajax({type:'POST',
           url: ajaxurl,
           data: {
             action: 'lf_download_templates',
           },
           dataType: 'json',
           }).done(function(response){
             if (response.success) {
               alert('Templates list has been refreshed. The page will reload.');
               window.location.reload();
             } else {
               alert(response.data);
             }
           }).fail(function(response) {
             alert('An undocumented error has occured. Please reload the page and try again.');
           }).always(function(response) {
             $(button).removeClass('loading');
           });

    return false;
  }); // download_templates


  // Activate Service
  $('a.lf-service-activate').on('click', function(e){
    e.preventDefault();

    var parent = $(this).parents('.settings_service_box');
    var provider = $('input[name="provider_name"]', parent).val();

    $(parent).fadeOut(500);

    $.post(ajaxurl, {action: 'lf_activate_service', provider: provider},
            function(response){
              $('.lf-service-overlay', parent).hide();

              $(parent).removeClass('lf-overlay-active');
              $(parent).detach().appendTo('#settings_services_container_active').fadeIn(500);

              $('.api-status', parent).html('<label>Status:</label> <span class="dashicons dashicons-no"></span>');
              $('.api-lists', parent).html('');

              $('html, body').animate({ scrollTop: $(parent).offset().top - 50 }, 700);
            }).fail(function(){
              alert('Undocmented error. Please reload the page.');
            }).always(function() {
              // no inactive services left
              if ($('#settings_services_container_inactive div.settings_service_box').length == 0) {
                $('#settings_services_container_inactive p.empty_message').show();
              }
              if ($('#settings_services_container_active div.settings_service_box').length > 0) {
                $('#settings_services_container_active p.empty_message').hide();
              }
            });

    return false;
  }); // activate service

  // show help when tooltip icon is clicked
  var lf_pointer;
  $('.settings_service_box').on('click', '.service-box-info', function() {
    var parent = $(this).parents('.settings_service_box');
    var title = $('.service-box-title h4', parent).html();
	var text = $('p.help', parent).html() || 'No help available.';
    attach_to = $('label:first', parent);
    if (attach_to.length != 1) {
      attach_to = $('p.api-status', parent);
    }

    if(lf_pointer && lf_pointer !== undefined) {
      $(lf_pointer).pointer('close');
    }

    lf_pointer = $(attach_to).pointer({
        content: '<h3>How to setup &amp; activate ' + title + '</h3><p>' + text +'</p>',
        pointerClass: 'wp_pointer lf_pointer',
        position: {
            edge: 'bottom',
            align: 'left'
        },
        width: 400
      }).pointer('open');

    return false;
  }); // tooltip click


  $('#lf-reset-stats').on('click', function() {
    if (confirm('Are you sure you want to reset all statistics? There is no undo!')) {
      button = $(this);
      $(button).addClass('loading');
      $.get(ajaxurl, {'action': 'lf_reset_stats'}, function(response) {
        if (!response.success) {
          alert('Undocumented error. Please reload the page.');
        } else {
          alert('All statistics have been reset.');
        }
      }, 'json')
      .fail(function() { alert('Undocumented error. Please reload the page.')})
      .always(function() { $(button).removeClass('loading'); });
    }

    return false;
  }); // reset stats


  $('#lf-delete-temp').on('click', function() {
    if (confirm('Are you sure you want to delete all temporary data? There is no undo!')) {
      button = $(this);
      $(button).addClass('loading');
      $.get(ajaxurl, {'action': 'lf_delete_temp'}, function(response) {
        if (!response.success) {
          alert('Undocumented error. Please reload the page.');
        } else {
          alert('All temporary data has been deleted. The page will reload.');
          window.location.reload();
        }
      }, 'json')
      .fail(function() { alert('Undocumented error. Please reload the page.')})
      .always(function() { $(button).removeClass('loading'); });
    }

    return false;
  }); // delete temp


  $('#mobile').on('click', '#lf_send_api_info', function(e) {
    e.preventDefault();

    notification_type = $(this).data('type');
    button = this;

    if (notification_type == 'sms') {
      to = prompt('Enter your mobile phone number in full international format, ie +1123456:');
      if (to === null) {
        return;
      } else if (!to) {
        alert('Please double-check your phone number.');
        return;
      }
    } else if (notification_type == 'email') {
      to = prompt('Enter your email address:', $(this).data('email'));

      if (to === null) {
        return;
      } else if (to.length < 5) {
        alert('Please double-check your email address.');
        return;
      }
    } else {
      alert('Unknown notification type');
      return false;
    }

    $(button).addClass('loading');
    $.get(ajaxurl, {'action': 'lf_send_api_info', 'to': to, 'notification_type': notification_type}, function(response) {
      if (!response.success) {
        alert('Error - ' + response.data);
      } else {
        alert('Done. ' + response.data);
      }
    }, 'json')
    .fail(function() { alert('Undocumented error. Please reload the page.'); })
    .always(function() { $(button).removeClass('loading'); });

    return false;
  })// click send api info


  $('.lf-save-api-provider').on('click', function(e) {
    e.preventDefault();

    var parent = $(this).parent().parent();
    var button = $(this);

    var fields = $('input, textarea, select', parent);

    $(button).addClass('loading');
    $.post(ajaxurl,
           {action: 'lf_save_api', fields: $(fields).serialize()},
           function(response) {
             if (response && response.success) {
               $(button).removeClass('disabled')
               $('.api-status', parent).html(response.data.status);
               $('.api-lists', parent).html(response.data.lists);
               alert('Service settings have been verified and saved.');
             } else {
               $(button).removeClass('disabled')
               $('.api-status', parent).html(response.data.status);
               $('.api-lists', parent).html(response.data.lists);
               alert('Unable to connect. Please double-check the details for selected service.');
             }
           }, 'json').fail(function() {
             alert('An undocumented error has occured. Please refresh the page!');
           }).always(function() {
             $(button).removeClass('disabled');
             $(button).removeClass('loading');
           });

    return false;
  }); // save api settings


  $('.lf-remove-api-provider').on('click', function(e) {
    e.preventDefault();
    parent = $(this).parents('.settings_service_box');
    button = this;

    provider = $('input[name=provider_name]', parent).val();
    $(button).addClass('loading');
	
	if(lf_pointer && lf_pointer !== undefined ) {
		$(lf_pointer).pointer('close');
	}
	
    $.post(ajaxurl, {action: 'lf_deactivate_service', provider: provider},
          function(response){
            if (response.success) {
              $(parent).fadeOut(500, function(){
                $('.lf-service-overlay', this).show();
                $(this).addClass('lf-overlay-active');
                $(this).detach().appendTo('#settings_services_container_inactive').fadeIn(500);

                // no active services left
                if ($('#settings_services_container_inactive div.settings_service_box').length > 0) {
                  $('#settings_services_container_inactive p.empty_message').hide();
                }
                if ($('#settings_services_container_active div.settings_service_box').length == 0) {
                  $('#settings_services_container_active p.empty_message').show();
                }
              });
            } else {
              alert('Undocumented error. Please reload the page.');
            }
          }).fail(function(){
            alert('Undocumented error. Please reload the page.');
          }).always(function() {
            $(button).removeClass('loading');
          });

    return false;
  }); // remove api settings


  $('#aweber_authorize').on('click', function(e) {
    app = $('#aweber-app_id').val();
    if (!app || app.length < 8) {
      e.preventDefault();
      return false;
      alert('Please enter Aweber App ID before authorizing. If you do not have your own app you can use ours - bc1b62cc');
    } else {
      $(this).attr('href', 'https://auth.aweber.com/1.0/oauth/authorize_app/' + app);
    }
  }); // aweber authorize
  
  
  
  		
			  (function(d, s, id){
				 var js, fjs = d.getElementsByTagName(s)[0];
				 if (d.getElementById(id)) {return;}
				 js = d.createElement(s); js.id = id;
				 js.src = "//connect.facebook.net/en_US/sdk.js";
				 fjs.parentNode.insertBefore(js, fjs);
			   }(document, 'script', 'facebook-jssdk'));
			   
				
				function subscribeApp(page_id, page_access_token){
					FB.api(
						'/'+page_id+'/subscribed_apps',
						'post',
						{access_token:page_access_token},
						function(response){
						});
				}
				
						
				function LFPFacebookLogin() {
				  FB.init({
				  appId      : $('#facebook-app_id').val(),
				  xfbml      : true,
				  version    : 'v2.5'
				});
				  FB.login(function(response){
					  FB.api('/me/accounts', function(response){
						
						var pages=response.data;
						jQuery('#lfp_facebook_pages_all').val(JSON.stringify(pages));
						var ul = document.getElementById('list');
						
						$('#lfp_facebook_page').find('option').remove();
		
						for(var i=0, len= pages.length; i<len; i++ ){
							
							$('#lfp_facebook_page').append($('<option>', {
								value: pages[i].id,
								text: pages[i].name
							}));
						}
					  });
				   },{scope: 'manage_pages'});
				}
				
				$('#lfp_facebook_login_button').on('click', function(){
					LFPFacebookLogin();
				});
  
  
  
  
});