/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */


if(typeof jQuery == 'undefined') {
  lfp_log('jQuery not found, loading it.');
  head = document.getElementsByTagName('head')[0];
  jq = document.createElement('script');
  jq.type = 'text/javascript';
  jq.src = 'https://code.jquery.com/jquery-1.11.3.min.js';
  jq.onload = lfp_do_tracking;
  head.appendChild(jq);
} else {
  lfp_log('jQuery found.');
  lfp_do_tracking();
}
 
function lfp_do_tracking() { 
  jQuery(document).ready(function($){
    parent_script = $('#lfp-tracking');
    
    flow_id = $(parent_script).data('lfpId');
    if (!flow_id) {
      lfp_log('Flow ID is not defined. Aborting.');
      return false;
    } else {
      lfp_log('Flow ID: ' + flow_id);
    }
    
    ajaxurl = $(parent_script).data('lfpAjaxurl');
    if (!ajaxurl) {
      lfp_log('AJAX URL is not defined. Aborting.');
      return false;
    } else {
      lfp_log('AJAX URL: ' + ajaxurl);
    }
    
    script_vars = $(parent_script).data();
    
    get_vars = lfp_getQueryParams(document.location.search);
    if (!Object.keys(get_vars).length) {
      get_vars = false;
    }
    
    lfp_log('Script vars: ', script_vars);
    lfp_log('GET vars: ', get_vars);
    
    $.ajax({ url: ajaxurl,
             method: 'POST',
             crossDomain: true,
             dataType: 'json',
             timeout: 3000,
             xhrFields: { withCredentials: true },
             data: { action: 'lfp_track_ecommerce', get_vars: get_vars, script_vars: script_vars }
    }).done(function(response) {
             if (response.success) {
               lfp_log('Transaction successfully processed! User ID #' + response.data + '.');
             } else {
               lfp_log('Unable to process transaction. Error: ' + response.data + '');
             }
    }).fail(function(type) {
            lfp_log('Unable to process transaction. Unknown error.');
    });
  }); // onload
} // lfp_do_tracking


function lfp_log(message, message2) {
  if (typeof console == 'object' && typeof console.log == 'function') {
    if (message2) {
      console.log('LFP - ', message, message2);  
    } else {
      console.log('LFP - ', message);
    }
  }
} // lfp_log


function lfp_getQueryParams(qs) {
  qs = qs.split('+').join(' ');
  var params = {},
      tokens,
      re = /[?&]?([^=]+)=([^&]*)/g;

  while (tokens = re.exec(qs)) {
      params[decodeURIComponent(tokens[1])]
          = decodeURIComponent(tokens[2]);
  }

  return params;
} // lfp_getQueryParams