<?php
/*
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_ab_general_settings extends leadflow {
  
  static function content() {
    global $post,$wpdb;
    $field_generator = new leadflow_field_generator();
    
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Custom URL:', 'general', 'custom-url', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'general', 'custom_url', array('1' => 'Enabled', '0' => 'Disabled'), '', true, false, 'If the default URL (' . get_permalink($post->ID) . ') doesn\'t suite your needs you can define a custom one by enabling this option and entering an URL below.', '', array('default' => '0'));
    echo $field_generator->end_row();

    echo $field_generator->start_row('custom_url_box');
    echo $field_generator->generate('label', '', 'general', 'abtests-custom-url', '', '', true, '', '', '');
    echo $field_generator->generate('input', 'Custom URL', 'general', 'abtests-custom-url', '', '', '','', 'URL has to start and end with a forward slash -  "/". Multiple flows, A/B tests and/or OptIns can\'t share the same URL and if more than one are defined on the same one whichever was defined first will be the one to get loaded.', true, array('class' => 'normal-text code', '_before_field' => home_url()));
    
	?>
       <script>
	   <?php 	   
	   echo 'var custom_urls_in_use=JSON.parse(\''.json_encode( leadflow_common::custom_url_print_all_urls_as_js() ).'\');'."\r\n";   
	   echo 'var current_post_id='.$post->ID.';';
	   ?>
	   
	   var custom_urls_in_use_html = '';
	   function check_url_exists(value){
		   custom_urls_in_use_html = '';
		   for(i in custom_urls_in_use){
			   if( i != current_post_id && custom_urls_in_use[i].url == value.replace(/[^a-z0-9-]+/gi, '')){
				   custom_urls_in_use_html = 'This URL is already in use by <a href="'+custom_urls_in_use[i].permalink+'">'+custom_urls_in_use[i].title+'</a>'; 
			   }
		   }
		   jQuery('#custom_url_in_use').html(custom_urls_in_use_html);
	   }
	   jQuery('#general_abtests-custom-url').on('change', function(){
		  check_url_exists(jQuery('#general_abtests-custom-url').val()); 
	   });
	   
	   jQuery('#general_abtests-custom-url').on('keyup', function(){
		  check_url_exists(jQuery('#general_abtests-custom-url').val()); 
	   });
	   
	   </script>
       
       <?php
	   
       $custom_url_used = leadflow_common::custom_url_usage_check($post->ID, 'abtests');
       if (!empty($custom_url_used)) {
         echo '<div class="lf-error-label" id="custom_url_in_use">This URL is already in use by another ' . $custom_url_used['type'] . ' <br/>' . $custom_url_used['found'] . '</div>';
       } else {
		   echo '<div class="lf-error-label" id="custom_url_in_use"></div>';
	   }
       
    echo $field_generator->end_row();
  } // content
} // leadflow_ab_general_settings