<?php
/*
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_flow_components extends leadflow {
  static $component_id = null;


  static function content() {
    global $post;
    $field_generator = new leadflow_field_generator();

    echo '<div class="lf-flow-layout-widgets">';
    echo '<h2 style="margin: 0 0 13px 0; padding: 0; font-weight: bold;">Available Components</h2>';
    echo '<div class="lf-components-search-wrapper">';
    echo '<span class="dashicons dashicons-search input-icon"></span>';
    echo '<input type="search" placeholder="filter components" value="" id="lf-components-search">';
    echo '</div>';
    echo '<ul class="flow-components-list" id="flow_available_components">';
    $providers = leadflow_external_api::get_options(true);

    $providers['custom_url'] = array('name' => 'Custom URL', 'status' => 'active');
    $providers['email'] = array('name' => 'Email', 'status' => 'active');
    if (leadflow_flow_common::get_flow_type($post->ID) != 'internal') {
      $providers['cookie'] = array('name' => 'Cookie', 'status' => 'active');
    }
    $providers['filesystem'] = array('name' => 'Filesystem', 'status' => 'active');
    $providers['mysql'] = array('name' => 'MySQL', 'status' => 'active');
    $providers['php'] = array('name' => 'PHP', 'status' => 'active');
    $providers['wp'] = array('name' => 'WordPress', 'status' => 'active');
    unset($providers['fullcontact'], $providers['jvzoo'], $providers['facebook']);
    ksort($providers);
	
	
	global $leadflow_lc;
	$lclevel = $leadflow_lc->GetLevelNo();
	if($lclevel<2){
		unset($providers['php'], $providers['mysql'], $providers['twilio'], $providers['zapier']);
	}
	
	
    foreach ($providers as $provider => $provider_details) {
      if ($provider_details['status'] == 'active' && !empty($provider_details['name'])) {
        echo '<li data-flow-component="' . $provider . '">';
        echo '<a href="#" class="add-to-flow">';
        echo '<div class="lf-flow-overlay" style="display:none;"><i class="dashicons dashicons-plus-alt"></i></div>';
        echo '<img width="24" src="' . LF_PLUGIN_URL . '/images/services/' . $provider . '.png" /><br>';
        echo '<i>' . $provider_details['name'] . '</i>';
        echo '</a>';
        echo '</li>';
      }
    }
    echo '</ul>';
    echo '<p><i>Additional services can be activated in <a href="' . admin_url('admin.php?page=leadflow-settings#1') . '">Settings - API services</a>.</i></p>';

    echo '</div>'; // left

    echo '<div class="lf-flow-layout-preview">';

    echo '<h2 style="margin: 0; padding: 0; font-weight: bold;">Active Components; drag &amp; drop to rearrange</h2>';
    echo '<ul class="sortable flow-components-list layout" id="flow_active_components">';

    $components = leadflow_flow_common::get_flow_components($post->ID);
    if (is_array($components) && sizeof($components)) {
      foreach ($components as $component) {
        echo self::generate_flow_component($component['_flow-component-type'], $component['_flow-component-id'], $component, $post->ID);
      }
    } else {
      if (leadflow_flow_common::get_flow_type($post->ID) == 'internal') {
        echo self::generate_flow_component('start', 0);
        echo self::generate_flow_component('local_db', 1);
      } elseif (leadflow_flow_common::get_flow_type($post->ID) == 'external') {
        echo self::generate_flow_component('start', 0);
        echo self::generate_flow_component('local_db', 1);
        echo self::generate_flow_component('end', 2);
      } elseif (leadflow_flow_common::get_flow_type($post->ID) == 'ecommerce') {
        echo self::generate_flow_component('start', 0);
        echo self::generate_flow_component('ecommerce', 1);
        echo self::generate_flow_component('local_db', 2);
        echo self::generate_flow_component('end', 3);
      } elseif (leadflow_flow_common::get_flow_type($post->ID) == 'form') {
        echo self::generate_flow_component('start', 0);
        echo self::generate_flow_component('local_db', 1);
      }
    } // empty flow

    echo '</ul>';
    echo '</div>';
    echo '<div class="clear"></div>';
  } // content


  static function get_system_vars($flow_type) {
    $vars = array();

    if ($flow_type == 'internal') {
      $vars = array('_date', '_time', '_timestamp', '_flow_id', '_flow_name', '_rand');
      $vars = array_merge($vars, array('uuid', 'email', 'firstname', 'lastname', 'address', 'phone', 'notes', 'ip', 'region', 'city', 'country', 'stars', 'signup_source', 'source_id', 'lang', 'created', 'modified'));
    } elseif ($flow_type == 'external') {
      $vars = array('_date', '_time', '_timestamp', '_flow_id', '_flow_name', '_ip', '_city', '_region', '_country', '_uuid', '_rand', '_user_agent', '_referer');
    } elseif ($flow_type == 'ecommerce') {
      $vars = array('_date', '_time', '_timestamp', '_flow_id', '_flow_name', '_ip', '_city', '_region', '_country', '_uuid', '_rand', '_user_agent', '_referer', '_remote_site');
    } elseif ($flow_type == 'form') {
      $vars = array('_date', '_time', '_timestamp', '_flow_id', '_flow_name', '_ip', '_city', '_region', '_country', '_uuid', '_rand', '_user_agent', '_referer', '_remote_site', '_form_uuid', '_form_url');
    }

    return $vars;
  } // get_system_vars
  static function vars_box($vars = array(), $protected = null, $options = array(), $flow_id = 0, $fixed_variables = false ) {
    global $predefined_vars;
    $vars_list = array();
    $i = 0;
    $box_name = 'vars';
    $flow_type = leadflow_flow_common::get_flow_type($flow_id);

    if (empty($predefined_vars)) {
      $predefined_vars = array();
    }

    $predefined_vars = array_merge($predefined_vars, self::get_system_vars($flow_type));

    rsort($predefined_vars);
    foreach ($predefined_vars as $var) {
      $vars_list['%%' . $var . '%%'] = '%%' . $var . '%%';
    }

    $out = '<table class="vars_box flow-vars-table">';
    $out .= '<thead>';
    $out .= '<tr>';
    $out .= '<th>Variable name</th>';
    $out .= '<th>Variable value</th>';
    if (!empty($options['disable_new'])) {
      $out .= '<th>&nbsp;</th>';
    } else {
      $out .= '<th></th>';
    }
    $out .= '</tr>';
    $out .= '</thead>';
    $out .= '<tbody>';

	update_option('webinar_vars',$vars);

    if (empty($vars)) {
      $vars[''] = '';
    }

    // foreach TR
    foreach ($vars as $name => $value) {
      $choices = array();
	
      if (!isset($value)) {
        $value = array();
      } elseif (!is_array($value)) {
        $value = array($value);
      }

      foreach ($value as $tmp) {
        $choices[(string)$tmp] = $tmp;
      }

      foreach ($vars_list as $key => $val) {
        $choices[$key] = $val;
      }

      if ($protected && is_array($protected) && in_array($name, $protected)) {
        $protect = ' readonly="readonly" ';
      } else {
        $protect = '';
      }

      $out .= '<tr id="'. self::get_field_id($box_name . '-' . $i) . '" data-row-id="' . $i . '">';
      $out .= '<td><input ' . $protect . ' name="' . self::get_field_name($box_name . '][var_names][') . '" id="' . self::get_field_id($box_name . '][var_names-' . $i) . '" type="text" value="' . esc_attr($name) . '"></td>';
      $out .= '<td><select name="' . self::get_field_name($box_name . '][var_values][' . $i .'][') . '" id="' . self::get_field_id($box_name . '][var_values-' . $i) . '" data-tags="true" multiple="multiple" class="select2-vars">';
      $out .= leadflow_common::create_select_options($choices, $value, false);
      $out .= '</select></td>';
      if ($protect) {
        $out .= '<td></td>';
      } else {
        $out .= '<td><a href="#" class="lf-delete-vars-row" data-field-id="' . self::get_field_id($box_name . '-' . $i) . '"><i class="dashicons dashicons-trash"></i></a></td>';
      }
      $out .= '</tr>';
      $i++;
    } // foreach vars

    // template row
    $out .= '<tr style="display: none;" data-row-id="%%__id%%" class="lf_var_template" id="'. self::get_field_id($box_name . '-%%__id%%') . '">';
    $out .= '<td><input name="' . self::get_field_name($box_name . '][var_names][') . '" id="' . self::get_field_id($box_name . '][var_names-%%__id%%') . '" type="text" value=""></td>';
    $out .= '<td><select class="select2-vars skip_select2" name="' . self::get_field_name($box_name . '][var_values][%%__id%%][') . '" id="' . self::get_field_id($box_name . '][var_values-%%__id%%') . '" multiple="multiple" data-tags="true">';
    $out .= leadflow_common::create_select_options($choices, '', false);
    $out .= '</select></td>';
    $out .= '<td><a href="#" class="lf-delete-vars-row" data-field-id="' . self::get_field_id($box_name . '-%%') . '"><i class="dashicons dashicons-trash"></i></a></td>';
    $out .= '</tr>';
    $out .= '</tbody>';
    $out .= '</table>';
    if($fixed_variables) {
		$out .= '<span style="color:#F00;">This API does not support custom fields.</span>';
	} else {
		$out .= '<a href="#" class="lf-add-vars-row"><i class="dashicons dashicons-plus"></i> Add Variable</a>';
	}
    $out .= '<hr class="short-hr" />';

    return $out;
  } // vars_box


  static function vars_box_start($data = array(), $predefined_values = array(), $protected = false) {
    $i = 0;
    $box_name = 'vars';

    $vars = $data['vars'];

    $out = '<table class="flow-vars-table">';
    $out .= '<thead>';
    $out .= '<tr>';
    $out .= '<th class="var-name">External variable name</th>';
    $out .= '<th class="var-rules">Validation rules</th>';
    $out .= '<th align="center"></th>';
    $out .= '</tr>';
    $out .= '</thead>';
    $out .= '<tbody>';

    if (empty($vars)) {
      $vars[''] = '';
    }
    foreach ($vars as $name => $value) {
      $out .= '<tr id="'. self::get_field_id($box_name . '-' . $i) . '" data-row-id="' . $i . '">';
      $out .= '<td class="var-name"><input class="var_name_watch" name="' . self::get_field_name($box_name . '][var_names][') . '" id="' . self::get_field_id($box_name . '][var_names-' . $i) . '" type="text" value="' . esc_attr($name) . '"></td>';
      $out .= '<td class="var-rules"><select class="var_box_chosen" name="' . self::get_field_name($box_name . '][var_values][' . $i .'][') . '" id="' . self::get_field_id($box_name . '][var_values-' . $i) . '" multiple="multiple">';
      $out .= leadflow_common::create_select_options($predefined_values, $value, false);
      $out .= '</select></td>';

      if ($protected && is_array($protected) && in_array($name, $protected)) {
        $out .= '<td></td>';
      } else {
        $out .= '<td><a href="#" class="lf-delete-vars-row" data-field-id="' . self::get_field_id($box_name . '-' . $i) . '"><i class="dashicons dashicons-trash"></i></a></td>';
      }

      $out .= '</tr>';
      $i++;
    } // foreach

    // template row
    $out .= '<tr style="display: none;" data-row-id="%%__id%%" class="lf_var_template" id="'. self::get_field_id($box_name . '-%%__id%%') . '">';
    $out .= '<td><input class="var_name_watch" name="' . self::get_field_name($box_name . '][var_names][') . '" id="' . self::get_field_id($box_name . '][var_names-%%__id%%') . '" type="text" value=""></td>';
    $out .= '<td><select class="var_box_chosen skip_chosen" name="' . self::get_field_name($box_name . '][var_values][%%__id%%][') . '" id="' . self::get_field_id($box_name . '][var_values-%%__id%%') . '" multiple="multiple">';
    $out .= leadflow_common::create_select_options($predefined_values, array(), false);
    $out .= '</select></td>';
    $out .= '<td><a href="#" class="lf-delete-vars-row" data-field-id="' . self::get_field_id($box_name . '-%%') . '"><i class="dashicons dashicons-trash"></i></a></td>';
    $out .= '</tr>';
    $out .= '</tbody>';
    $out .= '</table>';
    $out .= '<a href="#" class="lf-add-vars-row"><i class="dashicons dashicons-plus"></i> Add Variable</a>';

    return $out;
  } // vars_box_start


  static function generate_flow_component($type, $id, $data = array(), $flow_id = 0) {
    $out = $buttons = $class = $move = $template = '';
    $type = strtolower($type);
    $id = self::$component_id = (int) $id;

    if (!$flow_id) {
      global $post;
      $flow_id = $post->ID;
    }

    $active = true;
    $providers = leadflow_external_api::$available_providers;
    $active_apis = get_option('leadflow_external_api');
    
    if (!empty($providers[$type]) && 
        (empty($active_apis[$type]) || $active_apis[$type]['status'] === false)) {
      $active = false;
    }
    // end => $active ide dalje
    $flow_type = leadflow_flow_common::get_flow_type($flow_id);

    $class .= 'flow-component flow-component-' . $type;
    $buttons .= '<a href="#" title="Edit component" class="edit_component"><i class="dashicons dashicons-edit"></i></a>';
    $buttons .= '<a href="#" title="Show component help" class="help_component"><i class="dashicons dashicons-editor-help"></i></a>';
    if ($type == 'start' || $type == 'end') {
      $class .= ' unsortable';
    } else {
      $buttons .= '<a href="#" class="move_component"><i class="dashicons dashicons-menu"></i></a>';
    }
    if ($type == 'start' || $type == 'end' || $type == 'local_db' || $type == 'ecommerce') {
    } else {
      $buttons .= '<a href="#" class="remove_component"><i class="dashicons dashicons-trash"></i></a>';
    }

    $template  = '<li class="' . $class . '" data-flow-component-id="' . $id . '" data-flow-component-type="' . $type . '">';
    $template .= '<input type="hidden" name="' . self::get_field_name('_flow-component-id') . '" value="' . $id . '">';
    $template .= '<input type="hidden" name="' . self::get_field_name('_flow-component-type') . '" value="' . $type . '">';
    $template .= '<div class="header"><div class="title"><img src="%%ICON_URL%%" height="20" title="%%TITLE%%" alt="%%TITLE%%"> %%TITLE%%</div><div class="actions">' . $buttons . '</div></div>';
    $template .= '<div class="settings" style="display: none;">';
    $template .= '<div class="component_help">%%HELP%%</div>';
    $template .= '%%SETTINGS%%</div>';
    $template .= '<div class="short_description">Details are not available. Please <b>configure the component</b>.</div>';
    $template .= '</li>';

    if (method_exists(__CLASS__, 'generate_component_' . $type)) {
      if (!$active) {
        $template = str_replace('%%TITLE%%', '%%TITLE%% - Currently not active.', $template);
      }
      $result = call_user_func(array(__CLASS__, 'generate_component_' . $type), $data, $template, $flow_id, $type);
      if ($result) {
        $out = $result;
        $out = str_replace('%%ICON_URL%%', LF_PLUGIN_URL . '/images/services/' . $type . '.png', $out);
        $out = str_replace('%%HELP%%', self::generate_component_help($type, $flow_type), $out);
      } else {
        $out .= str_replace('%%TITLE%%', 'Error rendering component', $template);
      }
    } else {
      $out = false;
    }

    self::$component_id = null;
    return $out;
  } // generate_flow_component


  static function generate_component_help($component_type, $flow_type) {
    $out = '';

    $out .= '<p><b>System variables</b><br>';
    $out .= 'Besides the variables defined by the user in the Start Component you can also use these system variables in any field. Some fields have a dropdown prefilled with all variable names from which you can easily select one or more variables. For the ones that do not simply write <i>%%VAR_NAME%%</i> and LFP will parse the variable on execution.</p>';

    if ($flow_type == 'external') {
      $out .= '<ul class="vars_list"><li>%%_date%% - date in WP date format</li><li>%%_time%% - time in WP time format</li><li>%%_timestamp%% - UNIX timestamp (not adjusted to local WP timezone)</li><li>%%_flow_id%% - ID of the current flow</li><li>%%_flow_name%% - name of the current flow</li><li>%%_ip%% - user\'s IP address</li><li>%%_city%% - user\'s city</li><li>%%_region%% - user\'s state/region</li><li>%%_country%% - users\'s country</li><li>%%_uuid%% - unique user ID</li><li>%%_rand%% - random number [0, 9999]</li><li>%%_user_agent%% - browser user agent identifier</li><li>%%_referer%% - HTTP referer</li><li>%%_request%% - serialized, raw input variables</li><li>%%_subscriber_VAR_NAME%% - all primary subscriber variables</li><li>%%_custom_VAR_NAME%% - all custom subscriber variables</li><li>%%_cookie_VAR_NAME%% - all cookies set by LFP</li></ul>';
    } elseif ($flow_type == 'internal') {
      $out .= '<ul class="vars_list"><li>%%_date%% - date in WP date format</li><li>%%_time%% - time in WP time format</li><li>%%_timestamp%% - UNIX timestamp</li><li>%%_flow_id%% - ID of the current flow</li><li>%%_flow_name%% - name of the current flow</li><li>%%_rand%% - random number [0, 9999]</li><li>%%_custom_VAR_NAME%% - all custom subscriber variables</li></ul>';
    } elseif ($flow_type == 'ecommerce') {
      $out .= '<ul class="vars_list"><li>%%_date%% - date in WP date format</li><li>%%_time%% - time in WP time format</li><li>%%_timestamp%% - UNIX timestamp (not adjusted to local WP timezone)</li><li>%%_flow_id%% - ID of the current flow</li><li>%%_flow_name%% - name of the current flow</li><li>%%_ip%% - user\'s IP address</li><li>%%_city%% - user\'s city</li><li>%%_region%% - user\'s state/region</li><li>%%_country%% - users\'s country</li><li>%%_uuid%% - unique user ID</li><li>%%_rand%% - random number [0, 9999]</li><li>%%_user_agent%% - browser user agent identifier</li><li>%%_referer%% - HTTP referer</li><li>%%_request%% - serialized, raw input variables</li><li>%%_subscriber_VAR_NAME%% - all primary subscriber variables</li><li>%%_cookie_VAR_NAME%% - all cookie variables set by LFP</li><li>%%_remote_site%% - remote site name</li></ul>';
    } elseif ($flow_type == 'form') {
      $out .= '<ul class="vars_list"><li>%%_date%% - date in WP date format</li><li>%%_time%% - time in WP time format</li><li>%%_timestamp%% - UNIX timestamp (not adjusted to local WP timezone)</li><li>%%_flow_id%% - ID of the current flow</li><li>%%_flow_name%% - name of the current flow</li><li>%%_ip%% - user\'s IP address</li><li>%%_city%% - user\'s city</li><li>%%_region%% - user\'s state/region</li><li>%%_country%% - users\'s country</li><li>%%_uuid%% - unique user ID</li><li>%%_rand%% - random number [0, 9999]</li><li>%%_user_agent%% - browser user agent identifier</li><li>%%_referer%% - HTTP referer</li><li>%%_request%% - serialized, raw input variables</li><li>%%_subscriber_VAR_NAME%% - all primary subscriber variables</li><li>%%_custom_VAR_NAME%% - all custom subscriber variables</li><li>%%_cookie_VAR_NAME%% - all cookies set by LFP</li><li>%%_form_uuid%% - form unique ID</li><li>%%_form_url%% - form URL</li><li>%%_remote_site%% - remote site name</li></ul>';
    }

    return $out;
  } // generate_component_help


  static function generate_flow_component_ajax() {
    $type = trim(@$_POST['component_type']);
    $id = (int) @$_POST['id'];
    $flow_id = (int) @$_POST['flow_id'];
    $data = null;

    $out = self::generate_flow_component($type, $id, array(), $flow_id);
    if ($out) {
      wp_send_json_success($out);
    } else {
      wp_send_json_error('Unknow flow component.');
    }
  } // generate_flow_component_ajax


  static function get_field_name($name, $id = null) {
    if (is_null($id) && is_null(self::$component_id)) {
      return 'unknown_id';
    } elseif (is_numeric(self::$component_id)) {
      $id = self::$component_id;
    }

    $out = 'flow_components[' . $id . '][' . $name . ']';

    return $out;
  } // get_fields_name

  static function get_field_id($name, $id = null) {
    if (is_null($id) && is_null(self::$component_id)) {
      return 'unknown_id';
    } elseif (is_numeric(self::$component_id)) {
      $id = self::$component_id;
    }

    $out = 'flow_components-' . $id . '-' . $name . '';
    $out = str_replace('][', '-', $out);
    $out = trim($out, '-');

    return $out;
  } // get_fields_name


  static function generate_component_start($data, $template, $flow_id) {
    $out = '';
    $flow_type = leadflow_flow_common::get_flow_type($flow_id);
    $_title = 'Flow start';

    if ($flow_type == 'external') {
      $defaults = array('fallback_type' => '0', 'fallback_optin' => '0', 'fallback_custom_url' => '', 'uuid_cookie' => '2', 'vars' => array('email' => array('required', 'email'), 'name' => array('required', '3chars')), 'primary_email_field' => '%%email%%');
    } elseif ($flow_type == 'ecommerce') {
      $defaults = array('fallback_type' => '0', 'fallback_optin' => '0', 'fallback_custom_url' => '', 'uuid_cookie' => '2', 'vars' => array('price' => array('required', 'price')), 'primary_email_field' => '__ecommerce');
    } elseif ($flow_type == 'form') {
      $defaults = array('uuid_cookie' => '2', 'vars' => array('email' => array('required', 'email')), 'primary_email_field' => 'email');
    } elseif ($flow_type == 'internal') {
      $defaults = array('uuid_cookie' => '2', 'vars' => array(), 'primary_email_field' => 'email');
    }

    $data = array_merge($defaults, $data);

    global $predefined_vars;
    $predefined_vars = array_keys($data['vars']);

    $var_filters = array();
    $var_filters[] = array('val' => 'required', 'label' => 'Required');
	$var_filters[] = array('val' => 'notempty', 'label' => 'Not empty');
    $var_filters[] = array('val' => 'email', 'label' => 'Email');
    $var_filters[] = array('val' => 'integer', 'label' => 'Whole number (integer)');
    $var_filters[] = array('val' => '3chars', 'label' => 'At least 3 chars long');
    $var_filters[] = array('val' => '5chars', 'label' => 'At least 5 chars long');
    $var_filters[] = array('val' => '10chars', 'label' => 'At least 10 chars long');
    $var_filters[] = array('val' => '20chars', 'label' => 'At least 20 chars long');
    $var_filters[] = array('val' => 'price', 'label' => 'Price');

	$fallback_types = array();
    $fallback_types[] = array('val' => 0, 'label' => 'Disabled');
	$fallback_types[] = array('val' => 'optin', 'label' => 'Standalone OptIn');
	$fallback_types[] = array('val' => 'custom_url', 'label' => 'Custom URL');
	$fallback_types[] = array('val' => 'custom_url_get', 'label' => 'Custom URL with GET forwarded variables');
	
    $fallback_optins = array();
    $tmp_optins = get_posts(array('post_type' => 'optin-pages', 'posts_per_page' => -1, 'order'=> 'ASC', 'orderby' => 'title', 'meta_key' => 'optin_type', 'meta_value' => 'standalone', 'post_status' => 'publish'));
    foreach ($tmp_optins as $tmp) {
      $fallback_optins[] = array('val' => $tmp->ID, 'label' => get_the_title($tmp->ID));
    }

    $primary_email_fields = array();
    if ($flow_type == 'ecommerce') {
      $primary_email_fields['__ecommerce'] = 'Match subscribers only by UUID cookie, ignore email';
    }
    foreach ($predefined_vars as $tmp) {
      $primary_email_fields['%%' . $tmp . '%%'] = '%%' . $tmp . '%%';
    }

    $uuid_cookies = array();
    $uuid_cookies[] = array('val' => '0', 'label' => 'Don\'t set the tracking cookie');
    $uuid_cookies[] = array('val' => '1', 'label' => 'Set cookie for 90 days.');
    $uuid_cookies[] = array('val' => '2', 'label' => 'Set cookie for lifetime.');

    if ($flow_type != 'internal') {
      $out .= '<strong>External variables:</strong>';
      if ($flow_type == 'ecommerce') {
        $out .= '<br>Important: variables entered in the &lt;script&gt; are automatically camel-capsed. "data-test-var" becomes "testVar".';
      }
	  
	  
	  
	  if($flow_type == 'external'){
	   $providers = leadflow_external_api::get_options(true);
	   
	   if(array_key_exists('facebook', $providers) && $providers['facebook']['status']){  
		  
		   $flow_meta=get_post_meta($flow_id, LF_META,true);
		   $lfp_last_facebook_fields = get_option('lfp_last_facebook_fields');
		   ob_start();	
		   	   
		   ?>
		   <label for"general_facebook-leads">Receive Facebook Leads</label>
		   <select id="general_facebook-leads" name="lf_meta[general][facebook-leads]">
			   <option value="0">Disabled</option>
			   <option value="1" <?php if($flow_meta['general']['facebook-leads'] == 1) echo 'selected="selected"'; ?>>Enabled</option>           
		   </select>
		   
		   <div class="facebook_leads">
				<div class="col-6" style="margin-top: 16px;">
					<strong>Facebook Verify Token:</strong> <input type="text" id="facebook-verify-token" name="facebook-verify-token" value="<?php echo get_post_meta($flow_id,'facebook-verify-token', true); ?>" /> 
				</div>
                
                <?php  
				   if(is_array($lfp_last_facebook_fields)){
					   echo '<strong>Facebook Fields Received on last call:</strong><br />';
					   foreach($lfp_last_facebook_fields as $field){
							echo $field.'<br />';   
					   }
				   }
				   ?>
                
		   </div>
		   <?php           		    
		   $out = ob_get_contents();
		   ob_end_clean();    
		  }
	  }
	  	
      if ($flow_type == 'ecommerce') {
        $out .= self::vars_box_start($data, $var_filters, array());
      } else {
        $out .= self::vars_box_start($data, $var_filters, array('email'));
      }

      $out .= '<hr class="short-hr"/>';
      
      $out .= '<div><label for="' . self::get_field_id('primary_email_field') . '">Primary email variable:</label> <select class="dynamic_update_field_names" name="' . self::get_field_name('primary_email_field') . '" id="' . self::get_field_id('primary_email_field') . '">';
      $out .= leadflow_common::create_select_options($primary_email_fields, $data['primary_email_field'], false);
      $out .= '</select></div>';
    }

    if ($flow_type == 'external') {
	  $out .= '<div><label for="' . self::get_field_id('fallback_type') . '">Fallback Type:</label> <select name="' . self::get_field_name('fallback_type') . '" id="' . self::get_field_id('fallback_type') . '">';
      $out .= leadflow_common::create_select_options($fallback_types, $data['fallback_type'], false);
      $out .= '</select></div>';	
      $out .= '<div class="settings_box settings_box_optin"><label for="' . self::get_field_id('fallback_optin') . '">Fallback Standalone OptIn:</label> <select name="' . self::get_field_name('fallback_optin') . '" id="' . self::get_field_id('fallback_optin') . '">';
      $out .= leadflow_common::create_select_options($fallback_optins, $data['fallback_optin'], false);
      $out .= '</select></div>';
	  $out .= '<div class="settings_box settings_box_custom_url settings_box_custom_url_get"><label for="' . self::get_field_id('fallback_custom_url') . '">Fallback Custom URL:</label> <input type="url" name="' . self::get_field_name('fallback_custom_url') . '" id="' . self::get_field_id('fallback_custom_url') . '" value="' . $data['fallback_custom_url'] . '"> <small>Enter the url including http:// prefix</small></div>';
    }

    $out .= '<div><label for="' . self::get_field_id('uuid_cookie') . '">UUID tracking cookie:</label> <select name="' . self::get_field_name('uuid_cookie') . '" id="' . self::get_field_id('uuid_cookie') . '">';
    $out .= leadflow_common::create_select_options($uuid_cookies, $data['uuid_cookie'], false);
    $out .= '</select></div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_start


  static function generate_component_end($data, $template, $flow_id) {
    $out = '';
    $flow_type = leadflow_flow_common::get_flow_type($flow_id);
    $_title = 'Flow end';

    $actions = array();
    if ($flow_type == 'ecommerce') {
      $actions[] = array('val' => 'auto', 'label' => 'Auto-detect return type');
      $actions[] = array('val' => 'json', 'label' => 'Return user UUID in json format');
      $actions[] = array('val' => 'blank', 'label' => 'End with no output');
      $actions[] = array('val' => 'image', 'label' => 'Display a transparent 1x1 px GIF');
	  $actions[] = array('val' => 'redirect', 'label' => 'Redirect to an URL');
      	
      $defaults = array('action' => 'auto', 'redirect_url' => '_custom-url', 'redirect_url_custom' => '', 'redirect_url_passvars'=>'');
    } else {
      $actions[] = array('val' => 'message', 'label' => 'Display a message');
      $actions[] = array('val' => 'redirect', 'label' => 'Redirect to an URL');
      $actions[] = array('val' => 'return', 'label' => 'Return UUID (for implementing in other plugins)');

      $defaults = array('action' => 'message', 'redirect_url' => '_custom-url', 'redirect_url_custom' => '', 'redirect_url_passvars'=>'', 'message' => '<h1>Thanks!</h1><p>Hey, thanks for filling that form out, it means a lot to us. <b>You Rock!</b></p>', 'tracking_code' => '');
    }
    $data = array_merge($defaults, $data);

    $templates = array();
    $templates[''] = 'Please select a template and click load';
    $templates['_clean'] = 'Clean';
    $templates['_laptop'] = 'Laptop';
	$templates['_desk'] = 'Modern Desk';
	$templates['_balloons'] = 'Balloons';
	$templates['_envelope'] = 'Envelope';

    $locked_pages = array('_custom-url' => 'Custom URL');
    $get_locked_pages = get_posts(array('post_type' => 'page', 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'DESC'));
    if ($get_locked_pages) {
      foreach ($get_locked_pages as $locked_page) {
        $locked = get_post_meta($locked_page->ID, '_lf_lock', true);
        if (!empty($locked) && $locked['lock'] == '1') {
          $locked_pages[$locked_page->ID] = $locked_page->post_title . ' (page locked by LFP)';
        } else {
          $locked_pages[$locked_page->ID] = $locked_page->post_title . ' (page)';
        }
      }
    }

    $get_locked_posts = get_posts(array('post_type' => 'post', 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'DESC'));
    if ($get_locked_posts) {
      foreach ($get_locked_posts as $locked_post) {
        $locked = get_post_meta($locked_post->ID, '_lf_lock', true);
        if (!empty($locked) && $locked['lock'] == '1') {
          $locked_pages[$locked_post->ID] = $locked_post->post_title . ' (post locked by LFP)';
        } else {
          $locked_pages[$locked_post->ID] = $locked_post->post_title . ' (post)';
        }
      }
    }

    $out .= '<div><label for="' . self::get_field_id('action') . '">Action:</label> <select name="' . self::get_field_name('action') . '" id="' . self::get_field_id('action') . '">';
    $out .= leadflow_common::create_select_options($actions, $data['action'], false);
    $out .= '</select></div>';

    if ($flow_type == 'ecommerce') {
		$out .= '<div class="settings_box settings_box_redirect">';
      $out .= '<div><label for="' . self::get_field_id('redirect_url') . '">Redirect URL:</label> <select name="' . self::get_field_name('redirect_url') . '" id="' . self::get_field_id('redirect_url') . '">';
      $out .= leadflow_common::create_select_options($locked_pages, $data['redirect_url'], false);
      $out .= '</select></div>';
	  $out .= '<div class="settings_box_custom_url"><label for="' . self::get_field_id('redirect_url_custom') . '">&nbsp;</label><span>Custom URL:</span> <input type="url" name="' . self::get_field_name('redirect_url_custom') . '" id="' . self::get_field_id('redirect_url_custom') . '" value="' . $data['redirect_url_custom'] . '"> <small>Enter the url including http:// prefix</small></div>';
      $out .= '<div class="settings_box_custom_url"><label for="' . self::get_field_id('redirect_url_passvars') . '">&nbsp;</label><input type="checkbox" name="' . self::get_field_name('redirect_url_passvars') . '" id="' . self::get_field_id('redirect_url_passvars') . '" value="passvars"'.($data['redirect_url_passvars']=='passvars'?'checked="checked"':'').'>&nbsp;<span>Pass flow variables to the url when redirecting</span></div>';
      $out .= '</div>'; // settings_box
	  
    } else {
      $out .= '<div class="settings_box settings_box_redirect">';
      $out .= '<div><label for="' . self::get_field_id('redirect_url') . '">Redirect URL:</label> <select name="' . self::get_field_name('redirect_url') . '" id="' . self::get_field_id('redirect_url') . '">';
      $out .= leadflow_common::create_select_options($locked_pages, $data['redirect_url'], false);
      $out .= '</select></div>';

      $out .= '<div class="settings_box_custom_url"><label for="' . self::get_field_id('redirect_url_custom') . '">&nbsp;</label><span>Custom URL:</span> <input type="url" name="' . self::get_field_name('redirect_url_custom') . '" id="' . self::get_field_id('redirect_url_custom') . '" value="' . $data['redirect_url_custom'] . '"> <small>Enter the url including http:// prefix</small></div>';
      $out .= '<div class="settings_box_custom_url"><label for="' . self::get_field_id('redirect_url_passvars') . '">&nbsp;</label><input type="checkbox" name="' . self::get_field_name('redirect_url_passvars') . '" id="' . self::get_field_id('redirect_url_passvars') . '" value="passvars"'.($data['redirect_url_passvars']=='passvars'?'checked="checked"':'').'>&nbsp;<span>Pass flow variables to the url when redirecting</span></div>';
      $out .= '</div>'; // settings_box

      $out .= '<div class="settings_box settings_box_message">';
      $out .= '<div><label for="' . self::get_field_id('message') . '">Message:</label>';
	  ob_start(); 
      wp_editor($data['message'], self::get_field_id('message'), array('textarea_name'=>self::get_field_name('message'), 'editor_class'=>'wysiwyg') );
      $out .= ob_get_contents();
      ob_end_clean();
	  $out .= '</div>';
      $out .= '<div><label for="' . self::get_field_id('message_template') . '">Message template:</label> <select name="' . self::get_field_name('message_template') . '" id="' . self::get_field_id('message_template') . '">';
      $out .= leadflow_common::create_select_options($templates, '', false);
      $out .= '</select> <input type="button" class="button button-secondary load-end-template" value="Load template" /></div>';
      $out .= '</div>';

      $out .= '<div class="settings_box settings_box_message settings_box_redirect"><label for="' . self::get_field_id('tracking_code') . '">Tracking or retargeting code:</label> <textarea name="' . self::get_field_name('tracking_code') . '" id="' . self::get_field_id('tracking_code') .'">' . $data['tracking_code'] . '</textarea><p class="description">Any piece of HTML will function. An IMG or IFRAME tag, or even multiple SCRIPT tags.</p></div>';
    }

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_end


  static function generate_component_local_db($data, $template, $flow_id) {
    $out = '';
    $flow_type = leadflow_flow_common::get_flow_type($flow_id);
    $_title = 'Local subscribers database';

    if ($flow_type == 'external' || $flow_type == 'form') {
      $defaults = array('auto_set_vars' => '1', 'tags_remove' => '', 'tags_add' => '', 'vars' => array('email' => '%%email%%', 'firstname' => '%%name%%', 'lastname' => '%%lastname%%'));
      $protected = array('email');
    } else {
      $defaults = array('auto_set_vars' => '0', 'tags_remove' => '', 'tags_add' => '', 'vars' => array());
      $protected = array();
    }
    $data = array_merge($defaults, $data);
    $tags_tmp = get_terms('leadflow-subscriber-tags', array('hide_empty' => false, 'fields' => 'all'));
    $tags = array();
    foreach ($tags_tmp as $tag) {
      $tags[] = array('val' => $tag->term_id, 'label' => $tag->name . ' (' . $tag->count . ')');
    }

    $out .= '<div><label for="' . self::get_field_id('auto_set_vars') . '">Auto-set variables:</label> <select name="' . self::get_field_name('auto_set_vars') . '" id="' . self::get_field_id('auto_set_vars') . '">';
    $out .= leadflow_common::create_select_options(array('0' => 'Disabled', '1' => 'Enabled'), $data['auto_set_vars'], false);
    $out .= '</select> <span id="auto_set_vars_off" style="display: none; color: red;">Please don\'t forget to set all needed variables manually!</span>';
    $out .= '<p>If enabled IP, city, region, country and language variables will be automatically set based on data extracted from user\'s request. If disabled, variables have to be manually set via inputs below.<br><b>Important</b>: if the flow request is not made directly by the user (ie for JVZoo flows or when pushing subscribers trough an internal flow) you MUST disable this option as the data will not be correct.';
    $out .= '</div>';

    $out .= '<strong>Subscriber variables to set:</strong>';
    $out .= self::vars_box($data['vars'], $protected, array(), $flow_id);

    $out .= '<br>Email variable is ignored if the subscriber is already in the database. System tags will be added automatically.<br>';
    $out .= '<div><label for="' . self::get_field_id('tags_remove') . '">Custom tags to remove:</label> <select multiple="multiple" id="' . self::get_field_id('tags_remove') . '" class="select2" name="' . self::get_field_name('tags_remove][') . '">';
    $out .= leadflow_common::create_select_options($tags, $data['tags_remove'], false);
    $out .= '</select></div>';

    $out .= '<div><label for="' . self::get_field_id('tags_add') . '">Custom tags to add:</label> <select data-tags="true" multiple="multiple" id="' . self::get_field_id('tags_add') . '" class="select2" name="' . self::get_field_name('tags_add][') . '">';
    $out .= leadflow_common::create_select_options($tags, $data['tags_add'], false);
    $out .= '</select></div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_local_db


  static function generate_component_filesystem($data, $template, $flow_id) {
    $out = '';
    $_title = 'Filesystem';

    $upload_dir = wp_upload_dir();
    $defaults = array('mode' => 'a', 'path' => $upload_dir['basedir'] . '/save.txt', 'format' => "ID,Name,Email;\n%%_uuid%%,%%name%%,%%email%%;\n");
    $data = array_merge($defaults, $data);

    $modes = array();
    $modes[] = array('val' => 'w', 'label' => 'Truncate file if exists, create new one if it doesn\'t (w)');
    $modes[] = array('val' => 'a', 'label' => 'Append to file if exists, create new one if it doesn\'t (a)');

    $out .= '<div><label for="' . self::get_field_id('mode') . '">Mode:</label> <select name="' . self::get_field_name('mode') . '" id="' . self::get_field_id('mode') . '">';
    $out .= leadflow_common::create_select_options($modes, $data['mode'], false);
    $out .= '</select></div>';

    $out .= '<div><label for="' . self::get_field_id('path') . '">File path:</label> <input type="text" value="' . $data['path'] . '" name="' . self::get_field_name('path') . '" id="' . self::get_field_id('path') . '"></div>';

    $out .= '<div><label for="' . self::get_field_id('format') . '">Format:</label> <textarea style="width: 100%;" name="' . self::get_field_name('format') . '" id="' . self::get_field_id('format') . '">' . $data['format'] . '</textarea></div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_filesystem


  static function generate_component_mysql($data, $template, $flow_id) {
    $out = '';
    $_title = 'MySQL';

    global $wpdb;
    $defaults = array('query' => '');
    $data = array_merge($defaults, $data);

    $tables = '';
    $tmp = $wpdb->get_results('SHOW TABLES', ARRAY_N);
    foreach ($tmp as $row) {
      $tables .= '<li>' . $row[0] . '</li>';
    }
    $tables = rtrim($tables, ', ');

    $out .= '<p class="component_help last"><b>Component help</b><br>Please note that there are no restrictions set on the SQL queries you run. Therefore you can easily truncate, drop or edit any table and there is no undo. Please test the queries before using them in a production environment.</p>';

    $out .= '<div><label for="' . self::get_field_id('query') . '">Query:</label> <textarea style="width: 100%;" name="' . self::get_field_name('query') . '" id="' . self::get_field_id('query') . '">' . $data['query'] . '</textarea></div>';
    $out .= '<div><label>Database:</label> ' . DB_NAME . '</div>';
    $out .= '<div><label>Available tables:</label></div>';
    $out .= '<ul class="tables_list">' . $tables . '</ul>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_mysql


  static function generate_component_php($data, $template, $flow_id) {
    $out = '';
    $_title = 'PHP';

    $defaults = array('code' => '', 'save_return' => '');
    $data = array_merge($defaults, $data);

    $out .= '<div class="component_help last"><b>Component help</b><br>Fatal errors in code will halt the flow completely. Do not place PHP tags on the beginning or end of code.<br>If you need to echo something save it in a variable and return it at the end of the code. Then use the variable below to save the value and output it in the End component using that variable name.<br />';
    $out .= '<br /><strong>Example:</strong><br /><hr />$email="%%email%%";<br />$firstname="%%firstname%%";<br />$lastname="%%lastname%%";<br /><strong>return "User $firstname $lastname ($email) subscribed!";</strong></div>';
    $out .= '<div><label for="' . self::get_field_id('code') . '">Code:</label> <textarea style="width: 100%;" name="' . self::get_field_name('code') . '" id="' . self::get_field_id('code') . '">' . $data['code'] . '</textarea>';
    $out .= 'Save returned value to a variable named: <br />%%php_<input type="text" value="' . $data['save_return'] . '" class="var_name_watch var_name_php" name="' . self::get_field_name('save_return') . '" id="' .self::get_field_id('save_return') .'">%%<br /> Variable can be used in other components as any other with the %% syntax.</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_php


  static function generate_component_email($data, $template, $flow_id) {
    $out = '';
    $_title = 'Email';


    $defaults = array('subject' => '', 'recipient' => array('%%email%%'), 'body' => '', 'attachment' => '', 'attachment_id' => '');
    $data = array_merge($defaults, $data);
    if (!is_array($data['recipient'])) {
      $data['recipient'] = array();
    }

    $vars_list = array();
    global $predefined_vars;
    if (empty($predefined_vars)) {
      $predefined_vars = array();
    }
    $predefined_vars = array_merge($predefined_vars, self::get_system_vars(leadflow_flow_common::get_flow_type($flow_id)));
    rsort($predefined_vars);
    foreach ($predefined_vars as $var) {
      $vars_list['%%' . $var . '%%'] = '%%' . $var . '%%';
    }
    foreach ($data['recipient'] as $tmp) {
      $vars_list[(string) $tmp] = $tmp;
    }


    $out .= '<div><label for="' . self::get_field_id('recipient') . '">Recipient:</label>';
    $out .= '<select name="' . self::get_field_name('recipient][') . '" id="' . self::get_field_id('recipient') . '" data-tags="true" multiple="multiple" class="select2-vars">';
    $out .= leadflow_common::create_select_options($vars_list, $data['recipient'], false);
    $out .= '</select></div>';

    $out .= '<div><label for="' . self::get_field_id('subject') . '">Subject:</label> <input type="text" value="' . $data['subject'] . '" name="' . self::get_field_name('subject') . '" id="' .self::get_field_id('subject') .'"></div>';

    $out .= '<div><label for="' . self::get_field_id('body') . '">Message:</label> ';
	
	//$out .= '<textarea name="' . self::get_field_name('body') . '" id="' .self::get_field_id('body') .'">' . $data['body'] . '</textarea>';
	
	/*ob_start(); //Start output buffer
    wp_editor($settings['text'], self::get_field_id('body'), array('textarea_name' => self::get_field_name('body')));
    $out .= ob_get_contents(); //Grab output
    ob_end_clean(); //Discard output buffer
	*/
	
	$out .= '<div class="wp-editor-tools"><div class="wp-editor-tabs">
					<button type="button" id="'.self::get_field_id('body').'-tmce" class="toggle_editor_visual lfp-switch-editor switch-tmce" data-wp-editor-id="'.self::get_field_id('body').'">Visual</button>
					<button type="button" id="'.self::get_field_id('body').'-html" class="toggle_editor_text  lfp-switch-editor switch-html toggle_editor_active"'.self::get_field_id('body').'">Text</button>
					</div></div>';
	$out .= '<div class="clear:both;"><textarea style="width:100%;" name="'.self::get_field_name('body').'" id="'.self::get_field_id('body').'" class="preview-editor">'.$data['body'].' </textarea></div>';
        
	
	
	$out .= '</div>';

    $out .= '<div><label for="' . self::get_field_id('attachment') . '">Attachment:</label> <input type="text" readonly="readonly" value="' . $data['attachment'] . '" name="' . self::get_field_name('attachment') . '" id="' .self::get_field_id('attachment') .'"> <a href="#" class="button button-secondary email-attach">Attach file</a> <a href="#" class="button button-secondary email-detach">Detach file</a></div>';
    $out .= '<input type="hidden" value="' . $data['attachment_id'] . '" name="' . self::get_field_name('attachment_id') . '" id="' .self::get_field_id('attachment_id') .'">';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_email


  static function generate_component_ecommerce($data, $template, $flow_id) {
    $out = '';
    $_title = 'Ecommerce';

    global $predefined_vars, $post;
    $defaults = array('default_price' => '20', 'price_field' => '', 'ecommerce_type' => 'universal');
    $data = array_merge($defaults, $data);

    $types = array();
    $types['universal'] = 'Universal';
    $types['jvzoo'] = 'JVZoo';
    $types['woocommerce'] = 'WooCommerce';

    $tmp_fields = array();
    foreach ($predefined_vars as $var) {
      $tmp_fields['%%' . $var . '%%'] = '%%' . $var . '%%';
    }

    $out .= '<p class="component_help last"><b>Component help</b><br>External price variable has to use the decimal point! If you use a comma (ie $34,45) the price will be wrong (ie $34,45 becomes $3445). You can use the comma as a thousands separator and of course completely ommit any points or commas (ie $67). Any currency references (ie 45USD, 78EUR, $89) will be stripped and only the number part used.</p>';

    $out .= '<div><label for="' . self::get_field_id('ecommerce_type') . '">Ecommerce integration:</label> <select name="' . self::get_field_name('ecommerce_type') . '" id="' .self::get_field_id('ecommerce_type') .'">';
    $out .= leadflow_common::create_select_options($types, $data['ecommerce_type'], false);
    $out .= '</select>';
    $out .= '</div>';

    $out .= '<div class="settings_box settings_box_universal" style="display: none;">';
    $out .= '<label for="' . self::get_field_id('default_price') . '">Default price:</label> <input type="number" class="small-text" value="' . $data['default_price'] . '" name="' . self::get_field_name('default_price') . '" id="' .self::get_field_id('default_price') .'"></div>';
    $out .= '<div class="settings_box settings_box_universal" style="display: none;">';
    $out .= '<label for="' . self::get_field_id('price_field') . '">Price field:</label> <select class="dynamic_update_field_names" name="' . self::get_field_name('price_field') . '" id="' .self::get_field_id('price_field') .'">';
    $out .= leadflow_common::create_select_options($tmp_fields, $data['price_field'], false);
    $out .= '</select>';
    $out .= '</div>'; // universal

    $out .= '<div class="settings_box settings_box_jvzoo" style="display: none;">';

    leadflow_external_api::set_provider('jvzoo');
    $jvzoo_status = leadflow_external_api::get_options();
    if ($jvzoo_status['status'] == true) {
      $flows = get_posts(array('post_type' => 'lead-flows', 'posts_per_page' => -1, 'meta_key' => 'flow_type', 'meta_value' => 'ecommerce', 'order' => 'ASC', 'orderby' => 'title', 'post_status' => 'publish'));

      $jvzoo_flows = array();
      foreach ($flows as $flow) {
        $components = leadflow_flow_common::get_flow_components($flow->ID);
        $types = array_map(function($element){ return (empty($element['ecommerce_type'])? false: $element['ecommerce_type']); }, $components);
        if (in_array('jvzoo', $types) && $flow->ID != $post->ID) {
          $jvzoo_flows[$flow->ID] = get_the_title($flow->ID);
        }
      }

      if (!empty($jvzoo_flows)) {
        $out .= '<p><b style="color: #a00;">Warning! Important!</b><br>You already have an Ecommerce Flow with JVZoo component active. In order not to duplicate transactions pulled from JVZoo, only one flow will be used - the first one created. Please keep only one JVZoo flow active at all times to prevent false stats and transactions.</p>';
      }

      $out .= '<label>Status:</label><br>';
      $out .= 'JVZoo API connection <b>is active</b> and transactions will be pulled from JVZoo into this flow automatically once an hour.<br>Following variables will be sent to the flow so <b>make sure they\'re all configured</b> in the flow\'s Start component: email, firstname, lastname, price, product_name, transaction_id, customer_ip.';
    } else {
      $out .= 'JVZoo API is <b>not active</b>. Go to <a href="' . admin_url('admin.php?page=leadflow-settings#1') . '">Settings - API Services</a> and activate it.';
    } // jv not ok
    $out .= '</div>'; // jvzoo

    $out .= '<div class="settings_box settings_box_woocommerce" style="display: none;">';
    $out .= '<label>Status:</label><br>';
    if (class_exists('WC_Integration')) {
      global $post;
      $flow_settings = get_option('woocommerce_leadsflowpro_settings');
      if ($flow_settings['lfp_flow_id'] == $post->ID) {
        $out .= 'WooCommerce integration <b>is active</b> and transactions will be pushed into this flow automatically as they happen.<br>Following variables will be sent to the flow so <b>make sure they\'re all configured</b> in the flow\'s Start component: email, price, firstname, lastname.';
      } else {
        $out .= 'WooCommerce integration <b>is not setup</b> to send data to this flow. Open <a href="' . admin_url('admin.php?page=wc-settings&tab=integration&section=leadsflowpro') . '">WooCommerce settings</a> and select this flow from the list of available dropdowns.';
      }
    } else {
      $out .= 'WooCommerce plugin <b>is not installed</b>. Please <a href="' . admin_url('plugins.php') . '">install</a> &amp; activate it.';

    } // wc not ok
    $out .= '</div>'; // woocommerce

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_ecommerce


  static function generate_component_cookie($data, $template, $flow_id) {
    $out = '';
    $_title = 'Cookie';

    $defaults = array('expire' => '30', 'vars' => array());
    $data = array_merge($defaults, $data);

    $out .= '<div><label for="' . self::get_field_id('expire') . '">Expires in days:</label> <input type="number" min="0" value="' . $data['expire'] . '" name="' . self::get_field_name('expire') . '" id="' .self::get_field_id('expire') .'"></div>';
    $out .= self::vars_box($data['vars'], array(), array(), $flow_id);
    $out .= '<br>Important - all variable names (cookie names) will be lowercased and prefixed with <i>lfp_</i>. "uuid" cookie name is reserved and you can\'t set a cookie with that name.';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_cookie


  static function generate_component_zapier($data, $template, $flow_id) {
    $out = '';
    $_title = 'Zapier';

    $defaults = array('webhook_url' => '', 'vars' => array('email' => '%%email%%', 'firstname' => '%%name%%', 'lastname' => '%%lastname%%'));
    $data = array_merge($defaults, $data);

    $out .= '<div><label for="' . self::get_field_id('webhook_url') . '">Zap webhook URL:</label> <input type="text" value="' . $data['webhook_url'] . '" name="' . self::get_field_name('webhook_url') . '" id="' .self::get_field_id('webhook_url') .'"> ';
    $out .= '<input type="button" class="test_zap button button-secondary" value="Send test Zap" /></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_zapier


  static function generate_component_aweber($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Aweber';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_aweber


  static function generate_component_mailchimp($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'MailChimp';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_mailchimp


  static function generate_component_infusionsoft($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'InfusionSoft';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'FirstName' => '%%name%%', 'LastName' => '%%lastname%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<p>Important: variable/field names in InfusionSoft are case sensitive! Please verify that they match the field names in your account.</p>';
    $out .= '<div><label for="' . self::get_field_id('list_id') . '">Group:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_infusionsoft


  static function generate_component_ontraport($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Ontraport';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'firstname' => '%%name%%', 'lastname' => '%%lastname%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">Tags &amp; sequences:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_infusionsoft


  static function generate_component_wishlist($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'WishList';

    $defaults = array('list_id' => '', 'vars' => array(
	'email' => '%%email%%', 
	'user_login' => '%%email%%', 
	'user_nicename' => '%%name%%', 
	'company' => '%%company%%', 
	'address1' => '%%address1%%', 
	'address2' => '%%address2%%', 
	'city' => '%%city%%', 
	'state' => '%%state%%', 
	'zip' => '%%zip%%', 
	'country' => '%%country%%'	
	));
	
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">User level:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email', 'user_login'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_wishlist


  static function generate_component_sendinblue($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'SendInBlue';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_sendinblue


  static function generate_component_activecampaign($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'ActiveCampaign';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'first_name' => '%%firstname%%', 'last_name' => '%%lastname%%', 'phone' => '%%phone%%', 'orgname' => '%%orgname%%', 'tags' => '%%tags%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label><select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'));
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_xx


  static function generate_component_twilio($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Twilio';

    $defaults = array('from' => '', 'message' => '', 'to' => '');
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('from') . '">From mobile number:</label> <select class="list_id_dropdown" name="' . self::get_field_name('from') . '" id="' .self::get_field_id('from') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['from'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label for="' . self::get_field_id('to') . '">Recipients:</label> 
	<select class="lfp-twillio-recipients select2-vars"  name="' . self::get_field_name('to') . '[]" id="' .self::get_field_id('to') .'" multiple>';
	
	if(is_array($data['to'])){
		foreach($data['to'] as $selected_tos){
			$out .= '<option value="'.$selected_tos.'" selected="selected">'.$selected_tos.'</option>';	
		}
	}
	$out .= '</select><br />
	<div style="margin-left:179px;">Write numbers in full international format; separate multiple numbers with a comma.</div>
	</div>';
//value="' . $data['to'] . '"
    $out .= '<div><label style="vertical-align: top;" for="' . self::get_field_id('message') . '">Message:</label> <textarea style="width:300px;" name="' . self::get_field_name('message') . '" id="' .self::get_field_id('message') .'">' . $data['message'] . '</textarea>';
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_twilio


  static function generate_component_pushover($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Pushover';

    $defaults = array('sound' => 'pushover', 'subject' => '', 'message' => '', 'to' => '');
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $sounds = leadflow_external_api::get_sounds();

    $out .= '<div><label for="' . self::get_field_id('sound') . '">Sound:</label> <select name="' . self::get_field_name('sound') . '" id="' .self::get_field_id('sound') .'">';
    $out .= leadflow_common::create_select_options($sounds, $data['sound'], false);
    $out .= '</select></div>';

    $out .= '<div><label for="' . self::get_field_id('to') . '">User Keys:</label> <textarea name="' . self::get_field_name('to') . '" id="' .self::get_field_id('to') .'">' . $data['to'] . '</textarea><br>
Regardless of the number of devices you have you only have one unique key and notifications sent to that key will be received on all devices. If you want to send on a per-device basis enter the key in this format: key:device-name.</div>';

    $out .= '<div><label for="' . self::get_field_id('subject') . '">Subject:</label> <input type="text" value="' . $data['subject'] . '" name="' . self::get_field_name('subject') . '" id="' .self::get_field_id('subject') .'"></div>';

    $out .= '<div><label for="' . self::get_field_id('message') . '">Message:</label> <textarea name="' . self::get_field_name('message') . '" id="' .self::get_field_id('message') .'">' . $data['message'] . '</textarea></div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_pushover


  static function generate_component_sendlane($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Sendlane';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'firstname' => '%%firstname%%', 'lastname' => '%%lastname%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email', 'firstname', 'lastname'), array('disable_new' => true), $flow_id, true);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_sendlane


  static function generate_component_mad_mimi($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Mad Mimi';

    $defaults = array('list_id' => '', 'vars' => array('email' => array('%%email%%'), 'name' => array('%%name%%')));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_mad_mimi


  static function generate_component_campaign_monitor($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Campaign Monitor';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_campaign_monitor


  static function generate_component_wp($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'WordPress users';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'user_login' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">Role:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_wp


  static function generate_component_custom_url($data, $template, $flow_id) {
    $out = '';
    $_title = 'Custom URL';

    $defaults = array('request_type' => 'original', 'url' => 'http://', 'vars' => array(), 'save_response' => '');
    $data = array_merge($defaults, $data);

    $request_types = array();
    $request_types[] = array('val' => 'custom', 'label' => 'Set custom POST and GET variables');
    $request_types[] = array('val' => 'original', 'label' => 'Clone POST and GET variables sent to this URL');

    $out .= '<div><label for="' . self::get_field_id('request_type') . '">Request type:</label> <select name="' . self::get_field_name('request_type') . '" id="' . self::get_field_id('request_type') . '">';
    $out .= leadflow_common::create_select_options($request_types, $data['request_type'], false);
    $out .= '</select></div>';

    $out .= '<div><label for="' . self::get_field_id('url') . '">URL:</label> <input type="text" value="' . $data['url'] . '" name="' . self::get_field_name('url') . '" id="' .self::get_field_id('url') .'"></div>';

    $out .= '<div class="settings_box settings_box_custom">';
    $out .= '<div><label>POST variables:</label>';
    $out .= self::vars_box($data['vars'], array(), array(), $flow_id);
    $out .= '</div>';
    $out .= '</div>';

    $out .= 'Save response to a variable named: <input type="text" value="' . $data['save_response'] . '" name="' . self::get_field_name('save_response') . '" id="' .self::get_field_id('save_response') .'"> Variable can be used in other components as any other with the %% syntax.';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_custom_url


    static function generate_component_rapid_mailer($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Rapid Mailer';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_rapid_mailer
  static function generate_component_mymail($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'MyMail';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_mymail
  

  static function generate_component_mailpoet($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'Mail Poet';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'firstname' => '%%name%%', 'lastname' => '%%lastname%%'));
	
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email', 'firstname', 'lastname'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_mailpoet


  static function generate_component_icontact($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'iContact';

    $defaults = array('list_id' => '', 'vars' => array(
		'email' => '%%email%%', 
		'prefix' => '%%prefix%%', 
		'firstname' => '%%firstname%%', 
		'lastname' => '%%lastname%%', 
		'suffix' => '%%suffix%%', 
		'street' => '%%street%%', 
		'street2' => '%%street2%%', 
		'city' => '%%city%%', 
		'state' => '%%state%%', 
		'postalcode' => '%%postalcode%%', 
		'phone' => '%%phone%%', 
		'fax' => '%%fax%%', 
		'business' => '%%business%%'
	));
	
	
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">List name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id, true);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_icontact


  static function generate_component_webinarignition($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'WebinarIgnition';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">Webinar name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_icontact


  static function generate_component_gotowebinar($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'GoToWebinar';

    $defaults = array('list_id' => '', 'vars' => array(
		'email' => '%%email%%', 
		'firstName' => '%%name%%', 
		'lastName' => '%%lastname%%', 
		'source' => '%%source%%', 
		'address' => '%%address%%', 
		'city' => '%%city%%', 
		'state' => '%%state%%', 
		'zipCode' => '%%zipCode%%', 
		'country' => '%%country%%', 
		'phone' => '%%phone%%', 
		'organization' => '%%organization%%', 
		'jobTitle' => '%%jobTitle%%', 
		'questionsAndComments' => '%%questionsAndComments%%', 
		'industry' => '%%industry%%', 
		'numberOfEmployees' => '%%numberOfEmployees%%', 
		'purchasingTimeFrame' => '%%purchasingTimeFrame%%', 
		'purchasingRole' => '%%purchasingRole%%'
	));
	
	
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">Webinar name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email', 'firstName', 'lastName'), array(), $flow_id, true);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_gotowebinar


  static function generate_component_getresponse($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'GetResponse';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">Campaign name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_getresponse


  static function generate_component_webinarjam($data, $template, $flow_id, $type) {
    $out = '';
    $_title = 'WebinarJam';

    $defaults = array('list_id' => '', 'vars' => array('email' => '%%email%%', 'name' => '%%name%%', 'schedule' => '0', 'ip_address' => '%%_ip%%', 'phone' => '%%phone%%'));
    $data = array_merge($defaults, $data);

    leadflow_external_api::set_provider($type);
    $lists = leadflow_external_api::get_lists(false);

    $out .= '<div><label for="' . self::get_field_id('list_id') . '">Webinar name:</label> <select name="' . self::get_field_name('list_id') . '" id="' .self::get_field_id('list_id') .'">';
    $out .= leadflow_common::create_select_options($lists, $data['list_id'], false);
    $out .= '</select> <input type="button" class="button button-secondary refresh-lists-dropdown" value="Refresh"></div>';

    $out .= '<div><label>Custom variables to send:</label>';
    $out .= self::vars_box($data['vars'], array('email', 'name', 'schedule'), array(), $flow_id);
    $out .= '</div>';

    $template = str_replace('%%TITLE%%', $_title, $template);
    $template = str_replace('%%SETTINGS%%', $out, $template);

    return $template;
  } // generate_component_webinarjam
} // leadflow_flow_stream