<?php
/*
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_flow_debug extends leadflow {
  static function content() {
    global $post;
    $field_generator = new leadflow_field_generator();
    $flow_type = leadflow_flow_common::get_flow_type($post->ID);

    $tmp = $field_generator->get_data('debug');
    if (isset($tmp) && isset($tmp['log'])) {
      $tmp = 1;
    } else {
      $tmp = 0;
    }
    echo '<input type="hidden" id="_first_post_save" value="' . $tmp . '">';


    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Debug log:', 'debug', 'log', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'debug', 'log', array('0' => 'Disabled', '1' => 'Enabled'), '', true, false, 'When enabled detailed debug data from the last flow call is displayed in the field below. Please note that ONLY the last flow call data is always available.<br>
    Saved debug data is safe and only available on this page to site administrators.', '');
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    $last_call = get_post_meta($post->ID, 'flow_debug_last_call', true);
    $last_call = str_replace(array('<pre>', '</pre>'), array('', ''), $last_call);
    echo '<textarea style="width: 100%;" rows="3" id="lf-debug-log">' . esc_textarea($last_call) . '</textarea>';
    echo '<input type="button" class="button button-secondary" id="lf-refresh-debug-log" value="Refresh"/>';
    echo $field_generator->end_row();

    if ($flow_type == 'external' || $flow_type == 'ecommerce' || $flow_type == 'form') {
      echo $field_generator->start_row();
      echo $field_generator->generate('label', 'Display debug log in the flow:', 'debug', 'display', '', '', '', true, '', '');
      echo $field_generator->generate('dropdown', '', 'debug', 'display', array('0' => 'Disabled', '1' => 'Enabled'), '', true, false, 'When enabled detailed debug info will be shown as output on the flow URL. Redirects, cookies and all other HTTP header based actions will not work and will produce errors - this is normal and expected.<br>
      Debug data contains private information related to your APIs and flows in general so please use this option with caution and only activate it while debugging.', '');
      echo $field_generator->end_row();
    }
   } // content

   static function refresh_debug_log_ajax() {
     $post_id = (int) @$_GET['post_id'];

     if (empty($post_id)) {
       wp_send_json_error('Invalid post ID');
     }

     $last_call = get_post_meta($post_id, 'flow_debug_last_call', true);
     $last_call = str_replace(array('<pre>', '</pre>'), array('', ''), $last_call);
     wp_send_json_success($last_call);
   } // refresh_debug_log_ajax
 } // leadflow_flow_flow