<?php
/*
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

 class leadflow_optin_background extends leadflow {
   static function content() {
     $field_generator = new leadflow_field_generator();
     $optin_type = leadflow_optin_common::get_optin_type();

     // Background types for standalone
     $background_types = array('image' => 'Image', 'slider' => 'Slider', 'video' => 'Video');

     // Background Cover
     $background_cover = array('none' => 'Image width & height', 'cover' => 'Full page cover', 'contain' => 'Contain image within box');

     // Background Position
     $background_position = array('left-top' => 'Left Top', 'left-center' => 'Left Center', 'left-bottom' => 'Left Bottom', 'right-top' => 'Right Top', 'right-center' => 'Right Center', 'right-bottom' => 'Right Bottom', 'top' => 'Center Top', 'center' => 'Center', 'bottom' => 'Center Bottom');

     // Background Repeat
     $background_repeat = array('repeat' => 'Repeat X/Y', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y', 'no-repeat' => 'No Repeat');


     if ($optin_type == 'standalone' | $optin_type == 'embed') {
       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'Background Type:', 'background', 'background-type', '', '', '', true);
       echo $field_generator->generate('dropdown', '', 'background', 'type', $background_types, '', true, false, 'Slider background consists of as many slides as you upload that are animated using one of the selected animations; image background can be one big image or a tiled surface of smaller ones; video plays a selected YouTube video.<br>We have prepared a large gallery of predefined images that you can use after <a href="edit.php?post_type=optin-pages&page=leadflow-settings">importing them in Settings</a>.<br>Background is not visible when the OptIn is used in a popup.');
       echo $field_generator->end_row();

       echo $field_generator->start_row('bg-video');
       echo $field_generator->generate('label', 'YouTube Video ID:', 'background', 'video-id', '', '', true, true);
       echo $field_generator->generate('input', '', 'background', 'video-id', '', '', '', '', 'Please only enter the YouTube video ID (ie f-UGhWj1xww). Not the whole URL or the embed code.', '', array('class' => 'regular-text'));
       echo $field_generator->end_row();
       // -----------------------

        echo $field_generator->start_row('bg-slider');
       echo $field_generator->generate('label', 'Slider Images:', 'background', 'slider-images', '', '', true, true);
       echo $field_generator->generate('upload', 'Upload/select slide', 'background', 'slider-images', '', '', true, false, 'You can upload new images using the WordPress Media Manager, choose images from it, or simply copy/paste the URL to an image into the field.');
       echo $field_generator->end_row();
       echo $field_generator->start_row('bg-slider');
       echo $field_generator->generate('label', 'Slider Animation:', 'background', 'slider-animation', '', '', '', true);
       echo $field_generator->generate('dropdown', '', 'background', 'slider-animation', array('0' => 'None', '1' => 'Fade', '2' => 'Slide Top', '3' => 'Slide Right', '4' => 'Slide Bottom', '5' => 'Slide Left', '6' => 'Carousel Right', '7' => 'Carousel Left'), '', true, false, '', '', array('default' => '3'));
       echo $field_generator->end_row();
       echo $field_generator->start_row('bg-slider');
       echo $field_generator->generate('label', 'Slide Interval:', 'background', 'slider-interval', '', '', '', true);
       echo $field_generator->generate('dropdown', '', 'background', 'slider-interval', array('1000' => '1 second', '2000' => '2 seconds', '3000' => '3 seconds', '4000' => '4 seconds', '5000' => '5 seconds', '6000' => '6 seconds', '7000' => '7 seconds', '8000' => '8 seconds'), '', true, false, 'Amount of time each slide is shown/paused between animations.', '', array('default' => '4000'));
       echo $field_generator->end_row();
     } // if standalone

     echo $field_generator->start_row('bg-image');
     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Background Color:', 'background', 'bg-color', '', '', true);
     echo $field_generator->generate('colorpicker', '', 'background', 'bg-color', '', '', true, false, '', '', array());
     echo $field_generator->end_row();
     echo $field_generator->generate('label', 'Background Image:', 'background', 'bg-image', '', '', true, true);
     echo $field_generator->generate('upload', 'Upload/select background', 'background', 'bg-image', '', '', false, false, '', '', array());
     echo $field_generator->end_row();
     
	 echo $field_generator->start_row('bg-image');
     echo $field_generator->generate('label', 'Background Position:', 'background', 'bg-position', '', '', true, '', '', '', array());
     echo $field_generator->generate('dropdown', '', 'background', 'bg-position', $background_position, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Cover:', 'background', 'bg-cover', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'background', 'bg-cover', $background_cover, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Repeat:', 'background', 'bg-repeat', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'background', 'bg-repeat', $background_repeat, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->end_row();
   } // content
 } // leadflow_optin_background