<?php
/*
 * LeadsFlow
 * (c) Web factory Ltd, 2015
 */

 class leadflow_optin_first_box extends leadflow {
   static function content() {
     global $post;

     $field_generator = new leadflow_field_generator();
     $optin_type = leadflow_optin_common::get_optin_type();

     $border_radius = array();
     for($i=0;$i<=30;$i++) {
       $border_radius[$i] = $i . ' px';
     }

     // Background Cover
     $background_cover = array('none' => 'Image width & height', 'cover' => 'Full page cover', 'contain' => 'Contain image within box');

     // Background Position
     $background_position = array('left-top' => 'Left Top', 'left-center' => 'Left Center', 'left-bottom' => 'Left Bottom', 'right-top' => 'Right Top', 'right-center' => 'Right Center', 'right-bottom' => 'Right Bottom', 'center-top' => 'Center Top', 'center-center' => 'Center', 'center-bottom' => 'Center Bottom');

     // Background Repeat
     $background_repeat = array('repeat' => 'Repeat X/Y', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y', 'no-repeat' => 'No Repeat');


     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Disable First Content Box:', 'first-box', 'disable-first-box', '', '', '', true, '', '', array());
     echo $field_generator->generate('dropdown', '', 'first-box', 'disable-first-box', array('0' => 'No', '1' => 'Yes'), '', true, false, 'If disabled users will imediatelly see the second content box. Stats for an OptIn page will not bo correct if you use it for some time with and then some time without the first box. Clone the OptIn page and then enable/disable the first box in order to keep the stats relevant.', '');
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Box Background Color:', 'first-box', 'box-background-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'first-box', 'box-background-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#f2f2f2'));
     echo $field_generator->generate('label', 'Background Opacity:', 'first-box', 'bg-opacity', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('input', '', 'first-box', 'bg-opacity', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '1', 'class' => 'small-text'));
     echo $field_generator->generate('label', 'Width:', 'first-box', 'width', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('input', '', 'first-box', 'width', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '1', 'class' => 'small-text'));
     echo $field_generator->end_row();



     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Background Position:', 'first-box', 'background-position', '', '', true, '', '', '', array());
     echo $field_generator->generate('dropdown', '', 'first-box', 'background-position', $background_position, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Cover:', 'first-box', 'background-cover', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'first-box', 'background-cover', $background_cover, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Repeat:', 'first-box', 'background-repeat', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'first-box', 'background-repeat', $background_repeat, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Background Image:', 'first-box', 'background-image', '', '', true, true);
     echo $field_generator->generate('upload', 'Upload background', 'first-box', 'background-image', '', '', false, false, '', '', array('default' => ''));
     echo $field_generator->end_row();

     // ------------------


     echo '<div style="padding: 20px; border: 1px solid gray; float: left; width: 30%;">';
     echo '<b>Available widgets:</b>';
     echo '<ul class="optin-available-widgets" id="first-box-widgets" data-connected-to="first-box-layout">
     <li data-widget-type="image"><b>Image</b><br><a href="#" class="button-secondary add-to-layout">Add to OptIn</a></li>
     <li data-widget-type="list"><b>List</b><br><a href="#" class="button-secondary add-to-layout">Add to OptIn</a></li>
     <li data-widget-type="text"><b>Text</b><br><a href="#" class="button-secondary add-to-layout">Add to OptIn</a></li>
     <li data-widget-type="button"><b>Button</b><br><a href="#" class="button-secondary add-to-layout">Add to OptIn</a></li>
     <li data-widget-type="countdown"><b>Countdown</b><br><a href="#" class="button-secondary add-to-layout">Add to OptIn</a></li>
     <li data-widget-type="blank"><b>Blank widget</b><br><a href="#" class="button-secondary add-to-layout">Add to OptIn</a></li>
     </ul>';

     echo '</div>'; // left

     echo '<div style="padding: 20px; border: 1px solid gray; float: left; width: 60%;">';

     echo '<b>Optin layout, drag&amp;drop widgets to rearrange them:</b>';
     echo '<div class="row dad optin-layout" id="first-box-layout">';

     $widgets = get_post_meta($post->ID, 'optin_widget', true);
     if ($widgets) {
       $id = 0;
       foreach ($widgets as $widget) {
         echo self::generate_widget($widget);
         #echo self::generate_flow_component($component['_flow-component-type'], $component['_flow-component-id'], $component);
       }
      } else {
       //echo self::generate_flow_component('start', 0, array('class' => 'unsortable'));
       //echo self::generate_flow_component('end', 3, array('class' => 'unsortable'));
     }
     echo '</div>';

     echo '</div>';
     echo '<div class="clear"></div>';


     leadflow_field_generator::save_button();
   } // content
   

  static function generate_widget($params = array()) {
    $output = '';
    if (is_array($params) && !empty($params)) {
      extract($params);
      
      if (!isset($width) || $width == '') {
        $width = 'col-lg-12';
      }      
      
      $output .= '<div class="' . $width . '" data-optin-widget-id="' . $id . '" data-optin-widget-type="' . $type . '">';
    
      $output .= '<div class="header">
                  <div class="title">' . ucfirst($type) . '</div>
                  <div class="actions">
                  <a href="#" class="move_widget" title="Move"><i class="dashicons dashicons-editor-expand"></i></a>
                  <a href="#" class="edit_widget" title="Edit"><i class="dashicons dashicons-edit"></i></a>
                  <a href="#" class="width_widget" ><i class="dashicons dashicons-leftright"></i></a>
                  <a href="#" class="remove_widget" title="Delete"><i class="dashicons dashicons-trash"></i></a>
                  </div>
                  </div>';
                
      $output .= '<div class="widget-outer-container">'; 
      $output .= '<div class="widget-inner-container">'; 
    
      // Dialog Header
      $output .= '<div class="widget-ic-header">';
      $output .= ucfirst($type);
      $output .= '<a href="#" class="widget-inner-close"><i class="dashicons dashicons-no-alt"></i></a>';
      $output .= '</div>';
    
      // Widget Info
      $output .= '<input type="hidden" name="optin_widget[' . $id .'][id]" id="" value="' . $id . '" />';
      $output .= '<input type="hidden" name="optin_widget[' . $id .'][type]" id="" value="' . $type . '" />';
      $output .= '<input type="hidden" name="optin_widget[' . $id .'][width]" id="" value="' . $width . '" />';
      $output .= '<input type="text" name="optin_widget[' . $id .'][name]" id="" value="" />';
    
      $output .= 'Settings here';
      $output .= '</div>';
      $output .= '</div>';
    
      $output .= '</div>';
    }
    return $output;
  } // generate_widget


  static function generate_widget_ajax() {
    extract($_POST);
    
    $output = '';
    
    $output .= '<div class="col-lg-12" data-optin-widget-id="' . $id . '" data-optin-widget-type="' . $widget_type . '">';
    
    $output .= '<div class="header">
                <div class="title">' . ucfirst($widget_type) . '</div>
                <div class="actions">
                <a href="#" class="move_widget" title="Move"><i class="dashicons dashicons-editor-expand"></i></a>
                <a href="#" class="edit_widget" title="Edit"><i class="dashicons dashicons-edit"></i></a>
                <a href="#" class="width_widget"><i class="dashicons dashicons-leftright"></i></a>
                <a href="#" class="remove_widget" title="Delete"><i class="dashicons dashicons-trash"></i></a>
                </div>
                </div>';
                
    $output .= '<div class="widget-outer-container">'; 
    $output .= '<div class="widget-inner-container">'; 
    
    // Dialog Header
    $output .= '<div class="widget-ic-header">';
    $output .= ucfirst($widget_type);
    $output .= '<a href="#" class="widget-inner-close"><i class="dashicons dashicons-no-alt"></i></a>';
    $output .= '</div>';
    
    // Widget Info
    $output .= '<input type="hidden" name="optin_widget[' . $id .'][id]" id="" value="' . $id . '" />';
    $output .= '<input type="hidden" name="optin_widget[' . $id .'][type]" id="" value="' . $widget_type . '" />';
    $output .= '<input type="hidden" name="optin_widget[' . $id .'][width]" id="" value="col-lg-12" />';
    $output .= '<input type="text" name="optin_widget[' . $id .'][name]" id="" value="" />';
    
    $output .= 'Settings here';
    $output .= '</div>';
    $output .= '</div>';
    
    $output .= '</div>';

    wp_send_json_success($output);
  } // generate_widget_ajax
} // leadflow_first_box