<?php
/*
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_optin_pullout extends leadflow {
  static function content() {
    global $post;

    $optin_type = leadflow_optin_common::get_optin_type();
    $options = get_option(LF_OPTIONS, array());
    $meta = leadflow_optin_common::get_optin_meta();
    $field_generator = new leadflow_field_generator();

    $link = get_permalink($post->ID);
    $link = str_replace(home_url(), '', $link);

    $posts_tmp = get_posts(array('posts_per_page' => 500, 'post_status' => 'publish', 'orderby' => 'title', 'order' => 'ASC'));
    $posts = array();
    foreach ($posts_tmp as $post_tmp) {
      $posts[$post_tmp->ID] = $post_tmp->post_title;
    }

    $pages_tmp = get_pages(array('posts_per_page' => 500, 'post_status' => 'publish', 'orderby' => 'title', 'order' => 'ASC'));
    $pages = array();
    foreach ($pages_tmp as $page_tmp) {
      $pages[$page_tmp->ID] = $page_tmp->post_title;
    }

    $cats_tmp = get_terms('category', array('hide_empty' => false));
    $categories = array();
    foreach ($cats_tmp as $cat_tmp) {
      $categories[$cat_tmp->term_id] = $cat_tmp->name . ' (' . $cat_tmp->count . ')';
    }

    // Background Color
    echo '<h4>Pullout Design</h4>';
    echo '<hr/>';
    
    echo '<div class="optin-conditional-options">';
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Pullout Background Color:', 'pullout', 'tab-background-color', '', '', '', true, '', '');
    echo $field_generator->generate('colorpicker', '', 'pullout', 'tab-background-color', '', '', true, false, '');
    echo $field_generator->end_row();
    echo '</div>';
    
    echo '<div class="optin-conditional-options">';
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Pullout Icon Color:', 'pullout', 'tab-icon-color', '', '', '', true, '', '');
    echo $field_generator->generate('colorpicker', '', 'pullout', 'tab-icon-color', '', '', true, false, '');
    echo $field_generator->end_row();
    echo '</div>';
    
	
	echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Optin position:', 'pullout', 'position', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'position', array('left' => 'Left', 'right' => 'Right'), '', true, false, 'Select your preferred optin position.', '');
    echo $field_generator->end_row();
	
	
    echo '<hr/>';

    echo '<div id="optin-conditional-options">';
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'A/B Test:', 'pullout', 'load_ab_test', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'load_ab_test', array('0' => 'Open this OptIn Page, not its A/B Test', '1' => 'Open A/B Test that this OptIn Page belongs to (if applicable)'), '', true, false, 'If the page belongs to an A/B Test you can opt to load that test in the popup, instead of the page itself.');
    echo $field_generator->end_row();
    echo '<hr>';
    echo '</div>';


    $ab_test = get_post_meta($post->ID, '_ab-test', true);
    if (!empty($ab_test)) {
      echo '<div id="optin-php-conditional-options" style="display:none;">';
    } else {
      echo '<div id="optin-php-conditional-options">';
    }

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Filter Subscribed Users:', 'pullout', 'filter_subscribed', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'filter_subscribed', array('0' => 'Show to all users', '1' => 'Do not show to users that already subscribed to this OptIn'), '', true, false, 'If the user has already subscribed to the list attached to this OptIn there is no reason to show him the popup again.');
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Filter Logged in Users:', 'pullout', 'filter_loggedin', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'filter_loggedin', array('0' => 'Show to all users', '1' => 'Show only to logged in users', '2' => 'Show only to logged out users'), '', true, false, 'If you want to show a popup only to your logged in users enable this option.');
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Limit per User:', 'pullout', 'limit_per_user', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'limit_per_user', array('0' => 'Show unlimited times', '1' => 'Show max 1 time per user', '2' => 'Show max 2 times per user', '3' => 'Show max 3 times per user', '4' => 'Show max 4 times per user', '5' => 'Show max 5 times per user'), '', true, false, 'Maximum amount of times a user can see the popup.', '');
    echo $field_generator->end_row();

    echo '<hr>';
    echo '<p>By default, if none of the option below are set, the popup will be shown on all pages. If you enable any option then that condition has to be met in order for the popup to show. Ie enabling home page and search page options means the popup will only be shown on the home and search pages.</p>';

    $conditions = array('is_home' => 'is_home', 'is_front_page' => 'is_front_page', 'is_archive' => 'is_archive', 'is_archive' => 'is_archive', 'is_single' => 'is_single');

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show only when following conditions are met:', 'pullout', 'conditions', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'conditions', $conditions, '', true, false, 'Optin will be shown when is_home() or is_front_page() conditionals return true.', '', array('multiple' => true, 'data-placeholder' => 'Choose conditions'));
    echo $field_generator->end_row();


    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on Posts:', 'pullout', 'on_posts', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'on_posts', $posts, '', true, false, 'Optin will be shown only on selected posts.', '', array('multiple' => true, 'data-placeholder' => 'Choose posts'));
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on Pages:', 'pullout', 'on_pages', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'on_pages', $pages, '', true, false, 'Optin will be shown only on selected pages.', '', array('multiple' => true, 'data-placeholder' => 'Choose pages'));
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on/in Categories:', 'pullout', 'on_categories', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'on_categories', $categories, '', true, false, 'Optin will be shown only on/in selected categories.', '', array('multiple' => true, 'data-placeholder' => 'Choose categories'));
    echo $field_generator->end_row();

    echo '</div>';
    echo '<div id="optin-js-conditional-options">';
    echo '<p>If all conditions/filters above are met then the optin will be trigered by one of the events below. You have to enable at least one event for the optin to show.</p>';

    

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on Page Load:', 'pullout', 'on_pageload', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'on_pageload', array('1' => 'Show immediately after page loads', '2000' => 'Show after 2 seconds', '3000' => 'Show after 3 seconds', '5000' => 'Show after 5 seconds', '10000' => 'Show after 10 seconds', '20000' => 'Show after 20 seconds', '30000' => 'Show after 30 seconds', '45000' => 'Show after 45 seconds', '60000' => 'Show after a minute', '0' => 'Disabled'), '', true, false, 'Shows the optin after page loads, immediately or after a predefined time.', '');
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show after inactivity:', 'pullout', 'on_inactivity', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'on_inactivity', array('0' => 'Disabled', '2000' => 'Show after 2 seconds', '3000' => 'Show after 3 seconds', '5000' => 'Show after 5 seconds', '10000' => 'Show after 10 seconds', '20000' => 'Show after 20 seconds', '30000' => 'Show after 30 seconds', '45000' => 'Show after 45 seconds', '60000' => 'Show after a minute'), '', true, false, 'Shows the popup after the user has been inactive for a predefined time.', '');
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on Exit Intent:', 'pullout', 'on_exit_intent', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'pullout', 'on_exit_intent', array('0' => 'Disabled', '1' => 'Enabled'), '', true, false, 'Popup will be shown when user\'s mouse gesture suggest that he is leaving the page by moving the cursor to the upper part of the screen in order to close the tab/window. This does not block users from closing the tab/window.', '');
    echo $field_generator->end_row();

    echo '</div>';
    echo '<br>';
    echo '<div class="clear"></div>';

  } // content
} // leadflow_popup