<?php
/*
 * LeadsFlow
 * (c) Web factory Ltd, 2015
 */

 class leadflow_optin_second_box extends leadflow {
   static function content() {
     global $post;

     $border_radius = array();
     for($i=0;$i<=30;$i++) {
       $border_radius[$i] = $i . ' px';
     }

     // Background Cover
     $background_cover = array('none' => 'Image width & height', 'cover' => 'Full page cover', 'contain' => 'Contain image within box');

     // Background Position
     $background_position = array('left-top' => 'Left Top', 'left-center' => 'Left Center', 'left-bottom' => 'Left Bottom', 'right-top' => 'Right Top', 'right-center' => 'Right Center', 'right-bottom' => 'Right Bottom', 'center-top' => 'Center Top', 'center-center' => 'Center', 'center-bottom' => 'Center Bottom');

     // Background Repeat
     $background_repeat = array('repeat' => 'Repeat X/Y', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y', 'no-repeat' => 'No Repeat');

     $meta = get_post_meta($post->ID, 'wf_optin_meta', true);
     if (!$meta) {
       $meta = array();
     }

     if(!isset($meta['second-optin']['optin-text'])) {
       $content = '<h1> Box #2 Content</h1>
Edit this text and replace it with your copy.';
     } else {
       $content = $meta['second-optin']['optin-text'];
     }

     wp_editor($content, 'wf_optin_meta_second-optin_optin-text', array('dfw' => true, 'tabfocus_elements' => 'insert-media-button,save-post', 'editor_height' => 360, 'resize' => 1, 'textarea_name' => 'wf_optin_meta[second-optin][optin-text]', 'drag_drop_upload' => 1));

     $font_size = array();
     for ($i = 0; $i<=45; $i++) {
       $font_size[$i . 'px'] = $i . 'px';
     }

     $field_generator = new leadflow_field_generator();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Box Border Radius:', 'second-optin', 'box-border-radius', '', '', '', true, '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'box-border-radius', $border_radius, '', '', '', '', '', array('columns' => 'col-2', 'default' => '10px'));
     echo $field_generator->generate('label', 'Box Border Width:', 'second-optin', 'box-border-width', '', '', '', true, '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'box-border-width', $font_size, '', '', '', '', '', array('columns' => 'col-2', 'default' => '2px'));
     echo $field_generator->generate('label', 'Box Border Color:', 'second-optin', 'box-border-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'box-border-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#bcbcbc'));
     echo $field_generator->end_row();


     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Box Background Color:', 'second-optin', 'box-background-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'box-background-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#f2f2f2'));
     echo $field_generator->generate('label', 'Box Shadow Color:', 'second-optin', 'box-shadow-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'box-shadow-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#f2f2f2'));
     echo $field_generator->generate('label', 'Box Font Color:', 'second-optin', 'box-font-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'box-font-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#111111'));
     echo $field_generator->end_row();


     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Content Font:', 'second-optin', 'content-font', '', '', '', true, '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'content-font', get_option('wf-optin-google-fonts'), '', '', '', '', '', array('columns' => 'col-2', 'default' => 'Open+Sans'));
     echo $field_generator->generate('label', 'Content Font Size:', 'second-optin', 'content-font-size', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'content-font-size', $font_size, '', '', '', '', '', array('columns' => 'col-2', 'default' => '18px'));
     echo $field_generator->generate('label', 'Background Opacity:', 'second-optin', 'bg-opacity', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('input', '', 'second-optin', 'bg-opacity', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '1', 'class' => 'small-text'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Subscribe Button Text:', 'second-optin', 'button-text', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('input', '', 'second-optin', 'button-text', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => 'Subscribe and don\'t miss out!'));
     echo $field_generator->generate('label', 'Button Font:', 'second-optin', 'button-font', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'button-font', get_option('wf-optin-google-fonts'), '', '', '', '', '', array('columns' => 'col-2', 'default' => 'Bevan'));
     echo $field_generator->generate('label', 'Button Text Font Size:', 'second-optin', 'button-font-size', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'button-font-size', $font_size, '', '', '', '', '', array('columns' => 'col-2', 'default' => '22px'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Button Border Radius:', 'second-optin', 'button-border-radius', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'button-border-radius', $border_radius, '', '', '', '', '', array('columns' => 'col-2', 'default' => '5px'));
     echo $field_generator->generate('label', 'Button Background Color:', 'second-optin', 'button-background-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'button-background-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#FAC564'));
     echo $field_generator->generate('label', 'Button Text Color:', 'second-optin', 'button-text-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'button-text-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#ffffff'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Background Position:', 'second-optin', 'background-position', '', '', true, '', '', '', array());
     echo $field_generator->generate('dropdown', '', 'second-optin', 'background-position', $background_position, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Cover:', 'second-optin', 'background-cover', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'background-cover', $background_cover, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Repeat:', 'second-optin', 'background-repeat', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'background-repeat', $background_repeat, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Footer Text (below button):', 'second-optin', 'footer-text', '', '', true, '', '', '', array());
     echo $field_generator->generate('input', '', 'second-optin', 'footer-text', '', '', '', '', '', '', array('class' => 'regular-text', 'default' => 'Don\'t worry, we hate spam as much as you do!'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Background Image:', 'second-optin', 'background-image', '', '', true, true);
     echo $field_generator->generate('upload', 'Upload background', 'second-optin', 'background-image', '', '', false, false, '', '', array('default' => ''));
     echo $field_generator->end_row();


     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Input Fields Border Radius:', 'second-optin', 'input-border-radius', '', '', '', true, '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'input-border-radius', $border_radius, '', '', '', '', '', array('columns' => 'col-2', 'default' => '10px'));
     echo $field_generator->generate('label', 'Input Fields Background Color:', 'second-optin', 'input-background-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'input-background-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#ffffff'));
     echo $field_generator->generate('label', 'Input Fields Text Color:', 'second-optin', 'input-text-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'input-text-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#000000'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Input Fields Border Color:', 'second-optin', 'input-border-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'input-border-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#000000'));
     echo $field_generator->end_row();

     leadflow_field_generator::save_button();
   } // content
 } // leadflow_second_box