<?php
/*
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

 class leadflow_optin_template extends leadflow {
   
   static function content() {
     $field_generator = new leadflow_field_generator();
     $optin_type = leadflow_optin_common::get_optin_type();
     $optin_template = leadflow_optin_common::get_optin_template();
     
     // Get installed templates
     $installed_templates = get_option(LF_INSTALLED_TEMPLATES);
     
     echo '<input type="hidden" name="optin_template" id="optin_template" value="">';
     echo '<div class="optin_template_preview_box_wrapper"><div class="optin_template_preview_box"></div></div>';
	 
     echo '<div class="optin_template_box" data-optin_template="user-defined" data-optin_template-description="Blank template that you can use to create your own custom Optin" data-optin_template-name="User Defined" data-optin_template-url="" data-optin_template-thumb="' . LF_TEMPLATE_PATH . '/user-defined.png">';
     echo '<img src="' . LF_TEMPLATE_PATH . '/user-defined.png">';
     echo '<span>User Defined</span>';
     echo '</div>';
       
     if (!empty($installed_templates)) {
		 foreach ($installed_templates as $key => $template) {
		   
		   $available = '';
		   $force_visible = 'display:none;';
		   
		   // Is this template available for current type
		   if (!empty($template['types'])) {
			 foreach ($template['types'] as $k => $type) {
			   $available .= 'available_' . $type . ' ';
			   if ($type == $optin_type) {
				 $force_visible = 'display:inline-block;';
			   }
			 }
			 $available = trim($available);
		   }
		   
		   // Is this template selected
		   if (!empty($optin_template)) {
			 $selected = '';
			 if ($optin_template != 'user-defined') {
			   if ($optin_template == $key) {
				 $selected = 'selected';
			   }
			 }
		   }
		   
		   
		   echo '<div class="optin_template_box ' . $available . ' ' . $selected . '" data-optin_template="' . $key . '" data-optin_template-description="' . @$template['description'] . '" data-optin_template-name="' . $template['name'] . '" data-optin_template-url="' . @$template['url'] . '" data-optin_template-thumb="' . $template['thumb'] . '" style="' . $force_visible . '">';
		   if (!empty($template['thumb'])) {
			 echo '<img src="' . $template['thumb'] . '">';
		   }
		   
		   echo '<span>' . $template['name'] . '</span>';
		   echo '</div>';
		 }
     }
	 
	 echo '<div class="clear"></div>';
	 echo '<a class="button button-primary" href="admin.php?page=leadflow-settings#4" style="float: right;">Download More Templates</a>';
     echo '<div class="clear"></div>';

     
   } // content
   
 } // leadflow_optin_template