<?php
/*
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

 class leadflow_page_lock extends leadflow {
   static function content() {
     global $post;

     $defaults = array('lock' => 0, 'locked_content' => 'You are not authorized to view this content.', 'optins' => array(), 'flows' => array());
     $settings = get_post_meta($post->ID, '_lf_lock', true);
     $settings = array_merge($defaults, (array) $settings);

     $optins = array();
     $flows = array();

     $tmps = get_posts(array('post_type' => 'optin-pages', 'post_status' => 'publish', 'orderby' => 'title', 'order' => 'ASC'));
     foreach ($tmps as $tmp) {
       $type = leadflow_optin_common::get_optin_type($tmp->ID);
       if (!$type) {
         continue;
       }
       $title = get_the_title($tmp->ID);
       if (!$title) {
         $title = 'No title';
       }
       $optins[] = array('val' => $tmp->ID, 'label' => $title . ' (' . leadflow_optin_type::$types[$type] . ')');
     }

     $tmps = get_posts(array('post_type' => 'lead-flows', 'post_status' => 'publish', 'orderby' => 'title', 'order' => 'ASC', 'numberposts' => -1));
     foreach ($tmps as $tmp) {
       $type = leadflow_flow_common::get_flow_type($tmp->ID);
       if (!$type) {
         continue;
       }
       $title = get_the_title($tmp->ID);
       if (!$title) {
         $title = 'No title';
       }
       $flows[] = array('val' => $tmp->ID, 'label' => $title . ' (' . leadflow_flow_type::$types[$type] . ')');
     }

     echo '<div>';
     echo '<label for="lf_lock">Lock this ' . $post->post_type . ': </label>';
     echo '<select name="lf_lock[lock]" id="lf_lock">';
     leadflow_common::create_select_options(array('0' => 'No, content is available for everyone', '1' => 'Yes, lock the content'), $settings['lock'], true);
     echo '</select>';
     echo '<p class="description">When the lock is enabled this pages\'s content will only be visible to the users who passed trough Flows or opted in on OptIns selected below for the duration of their session. Others will see the defultc content. Set the redirect URL of your OptIn/Flow to this page to show it after users go trough it.</p>';
     echo '</div><br>';

     echo '<div id="lf_lock_enabled" style="display: none;">';
     echo '<div>';
     echo '<label for="lf_optins">OptIns that unlock this content: </label>';
     echo '<select data-placeholder="Select OptIns" multiple="multiple" class="select2" name="lf_lock[optins][]" id="lf_optins">';
     leadflow_common::create_select_options($optins, $settings['optins'], true);
     echo '</select>';
     echo '<p class="description">After user subscribes to any of the selected OptIns above he will be able to see the content.</p>';
     echo '</div><br>';

     echo '<div>';
     echo '<label for="lf_flows">Flows that unlock this content: </label>';
     echo '<select data-placeholder="Select Flows" multiple="multiple" class="select2" name="lf_lock[flows][]" id="lf_flows">';
     leadflow_common::create_select_options($flows, $settings['flows'], true);
     echo '</select>';
     echo '<p class="description">After user passes trough to any of the selected Flows above he will be able to see the content.</p>';
     echo '</div><br>';

     echo '<div>';
     echo '<label for="lf_locked_content">Locked content: </label><br>';
     wp_editor( esc_textarea($settings['locked_content']), 'lf_locked_content', array('textarea_name'=>'lf_lock[locked_content]', 'editor_class'=>'wysiwyg', 'editor_height'=> 200 ) );
     echo '<p class="description">This content is shown to users who did not sign up via OptIns or did not go trough Flows selected above; or their sessions timed out. HTML tags and shortcodes are allowed.</p>';
     echo '</div>';
     echo '</div>';
   } // content


   static function save_post($post_id, $post, $update) {
     if ($post->post_type != 'page' && $post->post_type != 'post') {
       return;
     }

     if (empty($_POST['lf_lock']) || !is_array($_POST['lf_lock'])) {
       return;
     }

     $data = $_POST['lf_lock'];

     $defaults = array('lock' => 0, 'locked_content' => '', 'optins' => array(), 'flows' => array());
     $data = array_merge($defaults, (array) $data);

     update_post_meta($post_id, '_lf_lock', $data);
   } // save_post


   static function the_content($content) {
     global $post;
     $locked = false;
     
     if ($post->post_type != 'page' && $post->post_type != 'post') {
       return $content;
     }
     
     $settings = get_post_meta($post->ID, '_lf_lock', true);     
     
     if (empty($settings['lock']) || $settings['lock'] != '1') {
       return $content;
     }
     
     $locked_content = do_shortcode(wpautop($settings['locked_content']));     
          
     if (!empty($settings['optins']) && is_array($settings['optins']) && sizeof($settings['optins']) > 0) {
       foreach ($settings['optins'] as $optin_id) {
         if (!empty($_SESSION['lf_unlocked_content'][$optin_id])) {
           return $content;
         }
       } // foreach optins
       
       return $locked_content;
     } else { // if optins
       $locked = true;
     }

     if (!empty($settings['flows']) && is_array($settings['flows']) && sizeof($settings['flows']) > 0) {
       foreach ($settings['flows'] as $flow_id) {
         if (!empty($_SESSION['lf_unlocked_content'][$flow_id])) {
           return $content;
         }
       } // foreach flows
       
       return $locked_content;
     } else { // if flows
       return $locked_content;
     }
     
     if ($locked) {
       return $locked_content;
     } else {
       return $content;  
     }
   } // the_content
   
   
   static function unlock_page($page_id, $page_type) {
     if (empty($page_id)) {
       return;
     }
     
     if ($page_type != 'optin' && $page_type != 'flow') {
       return;
     }
     
     $_SESSION['lf_unlocked_content'][$page_id] = $page_type;
     
     return $_SESSION['lf_unlocked_content'];
   } // unlock_content
 } // leadflow_flow_form