<?php
/*
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_subscribers_metabox extends leadflow {
  static $component_id = null;


  // Subscriber Editable Vars Go Here
  static function editable() {
    global $post;

    $field_generator = new leadflow_field_generator();

    $default_fields = array('firstname' => '', 'lastname' => '', 'address' => '', 'phone' => '', 'notes' => '');

    echo '<div>';

    $details = leadflow_subscribers_common::get_details($post->ID);

    if (is_array($details)) {
      $fields = array_intersect_key($details, $default_fields);
    } else {
      $fields = $default_fields;
    }

    #$fields = array_merge($default_fields, $details);

    if (!empty($fields)) {
      foreach ($fields as $key => $default_value) {

        if ($key == 'notes') {
          $type = 'textarea';
        } else {
          $type = 'input';
        }

        echo $field_generator->start_row();
        echo $field_generator->generate('label', $key . ':', $key, '', '', '', '', false, '', '');
        echo $field_generator->generate($type, $key, 'editable', $key, $default_value, '', '', '', '', false);
        echo $field_generator->end_row();
      }
    }

    // Additional Tags
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Add new tags:', 'meta', 'tags', '', '', '', false, '', '');
    echo '<select name="' . LF_META . '[tags]" class="select2" multiple="multiple">';
    $terms = get_terms('leadflow-subscriber-tags', array('hide_empty' => 0));
    echo '<option value=""></option>';
    if ($terms) {
      foreach ($terms as $term) {
        echo '<option value="' . $term->name . '">' . $term->name . '</option>';
      }
    }
    echo '</select>';
    echo $field_generator->end_row();

    echo '</div>';
    echo '<div class="clear"></div>';
  } // editable


  // Subscriber New Info
  static function graphic_info() {
    global $post;

    $data = leadflow_subscribers_common::get_details($post->ID);
    $avatar = get_avatar($data['email'], 256);
	
	echo '<div class="lfp-new-data">';

    echo '<div class="lfp-avatar">';
    if ($avatar) {
      echo $avatar;
    } else {
      echo '<img src="http://placehold.it/256x256"/>';
    }
    echo '<div class="lfp-stars">';
    echo '<label>User Rating:</label>';
    for ($i = 0; $i < 5; $i++) {
      if ($i < $data['stars'] && abs($i - $data['stars']) > 0.5) {
        echo '<span class="dashicons dashicons-star-filled"></span>';
      } elseif ($i > $data['stars'] || $data['stars'] == 0) {
        echo '<span class="dashicons dashicons-star-empty"></span>';
      } elseif ($data['stars'] != 0 && abs($i - $data['stars']) == 0.5) {
        echo '<span class="dashicons dashicons-star-half"></span>';
      } else {
        echo '<span class="dashicons dashicons-star-empty"></span>';
      }
    }
    echo '</div>';
    echo '</div>';

    echo '<div class="lfp-user-data">';
    echo '<table>';
    echo '<tbody>';

    echo '<tr>';
    echo '<td><h2>' . $data['email'] . '</h2></td>';
    echo '</tr>';

    echo '<tr>';
    echo '<td><label>Name:</label>' . $data['firstname'] . ' ' . $data['lastname'] . '</td>';
    echo '</tr>';

    echo '<tr>';
    if($data['signup_source']=='import') {
	   echo '<td><label>Status:</label> Imported on ' . date(get_option('date_format'), strtotime($data['created'])) . '</td>';    	
    } else {
       echo '<td><label>Status:</label><br />Subscribed at ' . date(get_option('date_format'), strtotime($data['created'])) . ' <br/> via ';
	   echo '<a href="'.get_edit_post_link( $data['source_id'] ).'">'.get_the_title($data['source_id']).'</a> ';
	   echo $data['signup_source'] . ' <br/> last updated ' . date(get_option('date_format'), strtotime($data['modified'])) . '<br />';
	   echo $data['ip'] . '</td>';
    }
    echo '</tr>';
    echo '</tr>';

    echo '<tr>';
    echo '<td><label>Lists:</label>';

    $tags = wp_get_post_terms($post->ID, 'leadflow-subscriber-system-tags');
    if ($tags) {
      echo '<ul class="lf-custom-tags">';
      foreach ($tags as $tag) {
        $style = '';
        $color = leadflow_common::get_subscriber_tags_meta($tag->term_id);

        // If term is a star - skip it
        if (strpos($tag->slug, 'stars-') !== false) {
          continue;
        }

        if ($color) {
          $style = 'style="';
          if (isset($color['tag_color'])) {
            $style .= 'background:' . $color['tag_color'] . ';';
          }

          if (isset($color['font_color'])) {
            $style .= 'color:' . $color['font_color'] . ';';
          }
          $style .= '"';
        }
        echo '<li><a href="' . @$url . @$subscriber_system_tags . @$tag->slug . '" ' . $style . '>' . $tag->name . '</a></li>';
      } // foreach $tags
      echo '</ul>';
    }

    echo '</td>';
    echo '</tr>';

    echo '</tbody>';
    echo '</table>';
    echo '</div>';
    
    
    $address = '';
    $address_html = '';
    
    if (!empty($data['city'])) {
      $address .= str_replace(' ', '+', $data['city']) . ',';
      $address_html .= $data['city'] . ',';
    }
    
    if (!empty($data['region'])) {
      $address .= str_replace(' ', '+', $data['region']) . ',';
      $address_html .= $data['region'] . ',';
    }
    
    if (!empty($data['country'])) {
      $address .= str_replace(' ', '+', $data['country']);
      $address_html .= $data['country'];
    }
    
    if (empty($address_html)) {
      $address_html = 'Unknown location.';	 
	  echo '<div class="align-right">';
		echo 'from ' . $address_html;
		echo '</div>'; 
    } else {    
		echo '<div class="lfp-gmap">';
		echo '<iframe width="600" height="450" frameborder="0" style="border:0" src="https://www.google.com/maps/embed/v1/search?key=AIzaSyCsY7jqJLTFBtRsGLcb-JQOhW6910qh1ts&q=' . $address . '" allowfullscreen></iframe>';
		echo '<br/>';
		echo '<div class="align-right">';
		echo 'from ' . $address_html;
		echo '</div>';
		echo '</div>';
	}
    
    echo '</div>';
    echo '<div class="clear"></div>';
  } // graphic_info


  static function custom_vars() {
    global $post;

    $field_generator = new leadflow_field_generator();

    $default_fields = array('ip' => '', 'region' => '', 'city' => '', 'country' => '', 'stars' => 0, 'signup_source' => '', 'source_id' => 0, 'lang' => '', 'created' => '', 'modified' => '');

    echo '<div>';

    $details = leadflow_subscribers_common::get_details($post->ID);
    $fields = $details['custom_vars'];

    if (!empty($fields)) {
      foreach ($fields as $key => $value) {

        // Custom Field
        echo $field_generator->start_row();
        echo $field_generator->generate('label', $key . ':', $key, '', '', '', '', false, '', '');
        echo '<input type="text" name="_readonly_' . $key . '" value="' . $value . '" readonly />';
        echo $field_generator->end_row();
      }
    } else {
      echo '<h4>There are no custom vars.</h4>';
    }

    echo '</div>';
    echo '<div class="clear"></div>';
  } // custom_vars


  static function events() {
    global $post;

    $field_generator = new leadflow_field_generator();

    $events = leadflow_stats::get_user_events($post->ID);

    echo '<div>';

    echo '<table class="widefat lf-events-metabox">';

    echo '<thead>';
    echo '<tr>';
    echo '<th>Event Description</th>';
    echo '<th style="text-align:center;">Event Type</th>';
    echo '<th>Event Date</th>';
    echo '</tr>';
    echo '</thead>';

    echo '<tbody>';

    foreach ($events as $k => $event) {
      echo '<tr>';
      echo '<td>' . $event['msg'] . '</td>';
      echo '<td style="text-align:center;"><img width="24" src="' . LF_PLUGIN_URL . '/images/event_types/' . $event['type'] . '.png" alt="' . $event['type'] . '" title="' . $event['type'] . '"></td>';
      echo '<td>' . date('d.m.Y H:i', $event['timestamp']) . '</td>';
      echo '</tr>';
    }

    echo '</tbody>';

    echo '</table>';

    echo '</div>';
    echo '<div class="clear"></div>';
  } // events


  static function fullcontact() {
    leadflow_external_api::set_provider('fullcontact');
    $fc_status = leadflow_external_api::get_options();
    if ($fc_status['status'] == true) {
      global $post;
      $person_url = leadflow_external_api::get_person_url($post->post_title);
      echo '<iframe frameborder="0" src="' . $person_url . '" id="fullcontact_details" border="0" height="320px" width="100%"></iframe>';
    } else {
      echo '<p>FullContact API is not active. Activate it in <a href="' . admin_url('admin.php?page=leadflow-settings#1') . '">Settings - API services</a>.</p>';
    }
  } // fullcontact


  // Subscriber Tags Box
  static function tags_box() {
    global $post;
    $terms = wp_get_post_terms($post->ID, 'leadflow-subscriber-tags');
    echo '<h4>Subscriber Tags:</h4>';
    if ($terms) {
      echo '<ul class="lf-custom-tags">';
      foreach ($terms as $term) {

        $style = '';
        $color = leadflow_common::get_subscriber_tags_meta($term->term_id);

        if ($color) {
          // CSS
          $style = 'style="';
          if (isset($color['tag_color'])) {
            $style .= 'background:' . $color['tag_color'] . ';';
          }

          if (isset($color['font_color'])) {
            $style .= 'color:' . $color['font_color'] . ';';
          }
          $style .= '"';
        }

        echo '<li><a href="#" ' . $style . '>' . $term->name . '</a></li>';

      }
      echo '</ul>';
    }

    echo '<h4>System Tags:</h4>';
    $terms = wp_get_post_terms($post->ID, 'leadflow-subscriber-system-tags');
    if ($terms) {
      echo '<ul class="lf-custom-tags">';
      foreach ($terms as $term) {

        $style = '';
        $color = leadflow_common::get_subscriber_tags_meta($term->term_id);

        if ($color) {
          // CSS
          $style = 'style="';
          if (isset($color['tag_color'])) {
            $style .= 'background:' . $color['tag_color'] . ';';
          }

          if (isset($color['font_color'])) {
            $style .= 'color:' . $color['font_color'] . ';';
          }
          $style .= '"';
        }

        echo '<li><a href="#" ' . $style . '>' . $term->name . '</a></li>';

      }
      echo '</ul>';
    }
  } //tags_box


} // leadflow_optin_subscibers