<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */
 
// Default Vars
$css_output = '';

if (!function_exists('get_header')) {
  die();
}



header('Access-Control-Allow-Origin: *');  
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

global $optin_ID, $doing_test, $currently_active_ab, $post;

if (!empty($post)) {
  $optin_ID = $post->ID;
} elseif (!empty($doing_test)) {
  $optin_ID = $_SESSION['leadsflow']['ab-test'][$currently_active_ab];
} 


// Fetch current optin meta
$meta = get_post_meta($optin_ID, LF_META, true);
$meta['second-optin']['disable-second-optin'] = (int) @$meta['second-optin']['disable-second-optin'];

// Setup optin skin
$skin = '';
if (isset($meta['general']['skin']) && 
    $meta['general']['skin'] != 'custom') {
  $skin = $meta['general']['skin'];
}

// Optin Width
if (isset($meta['general']['width'])) {
  $optin_width = $meta['general']['width'];
  
  if (strpos($optin_width, 'px')) {
    $meta['general']['width'] = rtrim($optin_width, 'px');'px';
	$meta['general']['width'] = (int) $optin_width . 'px';
  } else {
    $meta['general']['width'] = rtrim($optin_width, '%');'%';
    $meta['general']['width'] = (int) $optin_width . '%';
  }
  
} else {
	$meta['general']['width'] = '500px';
}

// Count Statistics
leadflow_stats::optin_add_view($optin_ID, 'box1');

echo '<!DOCTYPE html>';
?>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <title><?php the_title(); ?></title>
  <link rel="profile" href="http://gmpg.org/xfn/11">
  <?php
  	// Add wp_head to attach enqueues
    wp_head();
  
    if (isset($meta['background']['type']) && $meta['background']['type'] == 'video') {
    ?>
    <script type="text/javascript" src="<?php echo LF_PLUGIN_URL.'/templates/jquery.tubular.1.0.js'; ?>" ></script>
      
    <?php
    }
    if (isset($meta['background']['type']) && $meta['background']['type'] == 'slider') {
    ?>
	  <script type="text/javascript" src="<?php echo LF_PLUGIN_URL.'/templates/assets/supersized/js/supersized.3.2.7.min.js'; ?>" ></script>
      <link rel="stylesheet" href="<?php echo LF_PLUGIN_URL.'/templates/assets/supersized/css/supersized.css'; ?>">
      
      <?php
	}
	
  /* first box */
  
  echo leadflow_optin_frontend_common::generate_css($optin_ID, true);

  // Google Fonts Active?
  if (!empty($meta['first-optin'])) {
    
    $settings = $meta['first-optin'];

    if (isset($settings['content-font']) && $settings['content-font'] != '') {
      echo '<link href="//fonts.googleapis.com/css?family=' . $settings['content-font'] . ':400,300,300italic,400italic,600,600italic,700,700italic,800,800italic" rel="stylesheet" type="text/css">' . "\r\n";
      echo '<style type="text/css">';
      echo 'div.lf-optin-box {' . "\r\n";
      echo 'font-family:"' . str_replace('+', ' ', $settings['content-font']) . '", sans-serif;' . "\r\n";
      echo 'font-size:' . $settings['content-font-size'] . ';' . "\r\n";
      echo '}' . "\r\n";
      echo '</style>';
    } else {
      echo '<link href="//fonts.googleapis.com/css?family=Roboto:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic" rel="stylesheet" type="text/css">' . "\r\n";
      echo '<style type="text/css">';
      echo 'div.lf-optin-box {' . "\r\n";
      echo 'font-family:"' . str_replace('+', ' ', 'Roboto') . '", sans-serif;' . "\r\n";
      echo 'font-size:Roboto;' . "\r\n";
      echo '}' . "\r\n";
      echo '</style>';
    }  // if ($settings['content-font'] != '')

  }

  
  if (isset($meta['general']['head-code']) && $meta['general']['head-code'] != '') {
    echo $meta['general']['head-code'];
  }
  
  $after_subscribe_url = '';
  if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
    $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
  } elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
    $after_subscribe_url = $meta['form']['redirect-custom-url'];
  }
  
  
// Get Optin - for post title
$optin = get_post($optin_ID);
$optin_generic_ID = 'lf-optin-' . $optin_ID;
?>
</head>
<body class="<?php echo $skin; ?>">
<?php 
if (isset($meta['background']['type']) && $meta['background']['type'] == 'video') {
?>
<div id="video-background"></div>
<?php 
}
?>
<div class="lf-optin-main-container"  id="<?php echo $optin_generic_ID; ?>" data-after-subscriber-action="<?php echo @$meta['form']['after-subscribe-action']; ?>" data-after-subscriber-message="<?php echo @$meta['form']['after-subscribe-alert-message']; ?>" data-after-subscriber-url="<?php echo $after_subscribe_url; ?>" data-post-title="<?php echo @$optin->post_title; ?>" data-optin-id="<?php echo $optin_ID; ?>">
<form method="post" action="#" class="ajax-subscribe" enctype="multipart/form-data">
<div class="lf-optin-container <?php echo $skin; ?>" style="width:<?php echo $meta['general']['width']; ?>">

  <div class="lf-optin-box box-border-radius box-background-color first-optin">
  <div class="lf-optin-box-inner">

    <?php
    // First Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_first_optin', true);

    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $row_css = '';
        if ($settings['background_color'] != '') {
          $row_css = 'background-color:' . $settings['background_color'] . ';';
        }
        
        if (!empty($settings['background_image'])) {
          $row_css = 'background-image:url(' . $settings['background_image'] . ');background-size:cover;';
        }
        
        if (!empty($settings['full_width'])) {
          $row_css .= 'width:100% !important;max-width:100% !important;';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $row_css . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }

    ?>
  </div>
  </div>
  <?php
  if (empty($meta['second-optin']['disable-second-optin'])) {
  ?>
  <div class="lf-optin-box box-border-radius box-background-color second-optin" style="display:none;">
  <div class="lf-optin-box-inner">

    <?php
    // Second Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_second_optin', true);
    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $background_color = '';
        if ($settings['background_color'] != '') {
          $background_color = 'background-color:' . $settings['background_color'] . ';';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $background_color . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }
		?>

  </div>
  </div>
  <?php } ?>
  
</div>
</form>
</div>
<?php

  leadflow_optin_enqueues::clean_footer();
  leadflow_optin_enqueues::clean_scripts_footer();     
  wp_footer();
?>
<script type="text/javascript">
var subscribed = false;
  jQuery(document).ready(function($){

    <?php
    if (isset($meta['background']['type']) && $meta['background']['type'] == 'video') {
    ?>
    if (!window.parent.document.getElementById('lf-optin-iframe')) {
		jQuery('.lf-optin-main-container').tubular({ videoId: '<?php echo $meta['background']['video-id']; ?>', mute: true, repeat: true });
    }

    <?php
    }
    if (isset($meta['background']['type']) && $meta['background']['type'] == 'slider') {
    ?>
    <!-- Supersized Background Slider Setup -->
    if (!window.parent.document.getElementById('lf-optin-iframe')) {
    $('body').supersized({
		  // Functionality
		  slideshow: 1,			// Slideshow on/off
			autoplay:	1,			// Slideshow starts playing automatically
			slide_interval: <?php echo (int) $meta['background']['slider-interval']; ?>,		// Length between transitions
			transition: <?php echo (int) $meta['background']['slider-animation']; ?>, 			// 0-None, 1-Fade, 2-Slide Top, 3-Slide Right, 4-Slide Bottom, 5-Slide Left, 6-Carousel Right, 7-Carousel Left
			transition_speed:	1000,		// Speed of transition
			new_window:	1,			// Image links open in new window/tab
			pause_hover: 0,			// Pause slideshow on hover
			keyboard_nav: 1,			// Keyboard navigation on/off
			performance: 1,			// 0-Normal, 1-Hybrid speed/quality, 2-Optimizes image quality, 3-Optimizes transition speed // (Only works for Firefox/IE, not Webkit)
			image_protect: 1,			// Disables image dragging and right click with Javascript

			// Size & Position
			min_width: 0,			// Min width allowed (in pixels)
			min_height: 0,			// Min height allowed (in pixels)
			vertical_center: 1,			// Vertically center background
			horizontal_center: 1,			// Horizontally center background
			fit_always:	0,			// Image will never exceed browser width or height (Ignores min. dimensions)
			fit_portrait: 1,			// Portrait images will not exceed browser height
	  	fit_landscape: 0,			// Landscape images will not exceed browser width

			// Components
			slide_links:	'blank',	// Individual links for each slide (Options: false, 'num', 'name', 'blank')
			thumb_links: 1,			// Individual thumb links for each slide
			thumbnail_navigation: 0,			// Thumbnail navigation
			slides:  	[
      <?php
      $output = '';
      foreach ($meta['background']['slider-images'] as $key => $value) {
        $output .= '{image : "' . $value . '"},';
      }
      $output = rtrim($output, ',');
      echo $output;
      ?>],

			// Theme Options
			progress_bar:	1,			// Timer for each slide
			mouse_scrub:	0
    });
    } else {
      $('#supersized-loader').hide();
    }
    <?php } ?>

    <?php
    // Prevent From Leaving without Subscribing
    echo leadflow_optin_common::prevent_from_leaving();
    ?>
  }); // onload
</script>
</body>
</html>