<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_bulk extends leadflow {
  
  
  static function content() {
    $flow = $_GET['lf-flow'];
    $filters = $_GET['filter-form'];
    $selected_users = $_GET['filter-selected'];
    
    if ($filters != '') {
      parse_str($filters, $params);
    
      // Fetch all subscribers
      $params['posts_per_page'] = -1;
    
      $subscribers = get_posts($params);
      $total_subscribers = count($subscribers);
    } else {
      $selected_users_array = explode(',', $selected_users);
      $total_subscribers = count($selected_users_array);
    }
    
    // Flow Status
    echo '<div id="lf-flow-push-status" style="display:none;margin-top:20px;">';
    
    // Current status info
    echo '<div class="lf-current-status">';
    echo '<span id="lf-pushed-rows">Pushed:<span></span></span>';
    echo '<span id="lf-errors-rows">Errors:<span></span></span>';
    echo '</div>';
    
    // Current Progress Info
    echo '<div class="lf-progress animate">';
    echo '<div class="lf-progress-bar"></div>';
    echo '<div class="lf-progress-text"></div>';
    echo '</div>';
    
	echo '<div class="lf-push-finished" style="display:none;">Flow Push Finished</div>';
		
    echo '</div>';
    
    echo '<form method="POST" action="#" name="lf-flow-push-ajax">';
    
    // Hidden Inputs
    echo '<input type="hidden" name="lf-subscriber-records" value="' . $total_subscribers . '" />';
    echo '<input type="hidden" name="lf-subscriber-query" value="' . $filters . '" />';
    echo '<input type="hidden" name="lf-subscriber-selected" value="' . $selected_users . '" />';
    echo '<input type="hidden" name="lf-subscriber-flow" value="' . $flow . '" />';

    echo '<p>You have selected ' . $total_subscribers . ' subscribers that will be pushed through flow.</p>';
    
    echo '<input type="submit" id="lf-push-data-btn" class="button button-primary" name="lf-push-flow" value="Push" />';
    
    echo '</form>';
	
	
	echo '<div id="lf-push-debugger" class="lf-push-debugger"></div>';

  } // content
  

  static function print_push_subscribers_dialog() {
    $screen = get_current_screen();
    
    if ($screen->id == 'edit-leadflow-subscribers') {
      echo '<div id="lf-subscribers-flows" style="display:none;">';
      echo '<form method="GET" action="' . admin_url('admin.php') . '" id="lf-subscribers-flow-form">';
      
      // Hidden fields
      echo '<input type="hidden" name="page" value="leadflow-bulk" />';
      echo '<input type="hidden" name="filter-form" value="" />';
      echo '<input type="hidden" name="filter-selected" value="" />';
      
      echo '<label for="lf-push-type">Select push type:</label>';
      echo '<br/>';
      echo '<select name="lf-push-type">';
      echo '<option value="-" selected="selected">-</option>';
      echo '<option value="push-all">Push All Subscribers</option>';
      echo '<option value="push-selected">Push Selected Subscribers</option>';
      echo '</select>';
      echo '<br/>';echo '<br/>';
      
      // User count
      echo '<div>';
      echo '<strong>Subscribers selected:</strong>';
      echo '<br/>';
      echo '<span class="subscribers-selected"></span>';
      echo '</div>';
      echo '<br/>';
      
      // Flows
      $flows = get_posts(array('post_type' => 'lead-flows', 'posts_per_page' => -1));
      echo '<label for="lf-flow">Select Flow:</label>';
      echo '<br/>';
      echo '<select name="lf-flow">';
      if ($flows) {
        echo '<option value="-">Select flow</option>';
        foreach ($flows as $flow) {
          echo '<option value="' . $flow->ID . '">' . $flow->post_title . '</option>';
        }
      } else {
        echo '<option value="-">You currently have no flows created.</option>';
      }
      echo '</select>';
      echo '</form>';
      echo '</div>';
    }
  } // print_push_subscribers_dialog
  

  static function print_export_subscribers_dialog() {
    $screen = get_current_screen();
    
    if ($screen->id == 'edit-leadflow-subscribers') {
      echo '<div id="lf-subscribers-export" style="display:none;">';
      echo '<form method="GET" action="' . admin_url('admin.php') . '" id="lf-subscribers-export-form">';
      
      // Hidden fields
      echo '<input type="hidden" name="page" value="leadflow-export" />';
      echo '<input type="hidden" name="filter-form" value="" />';
      echo '<input type="hidden" name="filter-selected" value="" />';
      
      echo '<label for="lf-export-type">Select export type:</label>';
      echo '<br/>';
      echo '<select name="lf-export-type">';
      echo '<option value="-" selected="selected">-</option>';
      echo '<option value="export-all">Export All Subscribers</option>';
      echo '<option value="export-selected">Export Selected Subscribers</option>';
      echo '</select>';
      echo '<br/>';echo '<br/>';
      
      // User count
      echo '<div>';
      echo '<strong>Subscribers selected:</strong>';
      echo '<br/>';
      echo '<span class="subscribers-selected"></span>';
      echo '</div>';
      echo '<br/>';

      echo '</form>';
      echo '</div>';
    }
  } // print_export_subscribers_dialog
  
  
  static function push_flow() {	
    // Count offset
    $pushed = 0;
    $offset = $_POST['offset'];
    $insert_per_call = $_POST['insert_per_call'];
    $selected_users = $_POST['selected_users'];
    $flow_id = $_POST['flow_id'];
    $errors = '';
    $error_count = 0;
    $error = false;
    
    // Parse WP Query
    if ($_POST['query'] != '') {
      // Query existing
      parse_str($_POST['query'], $params);

      // Fetch all subscribers
      $params['posts_per_page'] = $insert_per_call;
      $params['offset'] = $offset*$insert_per_call;
    
      $subscribers = get_posts($params);
      $total_subscribers = count($subscribers);
      
      if ($subscribers) {		
        foreach ($subscribers as $sub) {
		  ob_start();	
		  leadflow_flow_common::$doing_flow_push=true;
		  leadflow_flow_common::process_internal_flow($flow_id, $sub->ID);	
		  if(leadflow_flow_common::$debug['bulk_messages']){
			$errors.=leadflow_flow_common::$debug['bulk_messages']."<br />";
		  }
		  if(leadflow_flow_common::$debug['bulk_errors']){
			$error_count+=leadflow_flow_common::$debug['bulk_errors'];
		  }
		  $php_echo = ob_get_contents();
    	  ob_end_clean();	  
          $pushed++;
        }
      }
    } else {
	  // Get only selected users
      $selected_users_array = explode(',', $selected_users);
      $batch_users_array = array_slice($selected_users_array, $offset, $insert_per_call);  
	  $total_subscribers = count($batch_users_array);
      
      if (is_array($batch_users_array)) {
		foreach ($batch_users_array as $sub) {
			 $subscriber = get_post($sub);
			 ob_start();
			 leadflow_flow_common::$doing_flow_push=true;
			 $push_result = leadflow_flow_common::process_internal_flow($flow_id, $subscriber->ID);
			 if(leadflow_flow_common::$debug['bulk_messages']){
				$errors.=leadflow_flow_common::$debug['bulk_messages']."<br />";
			 }
			 if(leadflow_flow_common::$debug['bulk_errors']){
				$error_count+=leadflow_flow_common::$debug['bulk_errors'];
			 }
			 $php_echo = ob_get_contents();
			 ob_end_clean();
			 $pushed++;
		}
      }
      
    }
    	
    // Has everything passed ok?
    if ($total_subscribers) {
      
      if (!$error) {
        wp_send_json_success(array('found' => $total_subscribers, 'pushed' => $pushed, 'skipped' => 0, 'errors' => $error_count, 'error_msg' => $errors ));
      } else {
        wp_send_json_error('Parsing subscriber error');
      }
      
    } else {
      wp_send_json_error('No subscribers found');
    }
    
    die();
  } // push_flow  

} // leadflow_bulk