<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_dashboard extends leadflow {
  static function content() {
	global $wpdb,$leadflow_lc;
    echo '<div class="wrap">';
	
	$count_subscribers= wp_count_posts('leadflow-subscribers');
	if($count_subscribers->publish<10){
		echo '<img src="' . LF_PLUGIN_URL . '/images/dashboard.jpg" style="width: 100%;">';
		return;
	}
	


	
	
	// Box Flows
	echo '<div id="top-dashboard-box-1" class="lf-col-container top-dashboard-box lf-col-2">';
		echo '<div class="top-dashboard-box-count">';
		$count_flows= wp_count_posts('lead-flows');
		echo number_format($count_flows->publish,0,'.',',');;
		echo '</div>';
		
		echo '<div class="top-dashboard-box-title">';
		echo 'Flows';
		echo '</div>';
		
		echo '<div class="top-dashboard-box-icon">';
		echo '</div>';
		
		echo '<a href="edit.php?post_type=lead-flows" class="top-dashboard-box-info">';
		echo 'More info <i data-fip-value="icon-right-circled" class="icon-right-circled"></i>';
		echo '</a>';
	echo '</div>';
	
	// Box Optins
	echo '<div id="top-dashboard-box-2" class="lf-col-container top-dashboard-box lf-col-2">';
		echo '<div class="top-dashboard-box-count">';
		$count_optins= wp_count_posts('optin-pages');
		echo number_format($count_optins->publish,0,'.',',');;
		echo '</div>';
		
		echo '<div class="top-dashboard-box-title">';
		echo 'Optins';
		echo '</div>';
		
		echo '<div class="top-dashboard-box-icon">';
		echo '</div>';
		
		echo '<a href="edit.php?post_type=optin-pages" class="top-dashboard-box-info">';
		echo 'More info <i data-fip-value="icon-right-circled" class="icon-right-circled"></i>';
		echo '</a>';
	echo '</div>';
	
	// Box Subscribers
	echo '<div id="top-dashboard-box-3" class="lf-col-container top-dashboard-box lf-col-2">';
		echo '<div class="top-dashboard-box-count">';		
		echo number_format($count_subscribers->publish,0,'.',',');
		echo '</div>';
		
		echo '<div class="top-dashboard-box-title">';
		echo 'Subscribers';
		echo '</div>';
		
		echo '<div class="top-dashboard-box-icon">';
		echo '</div>';
		
		echo '<a href="edit.php?post_type=leadflow-subscribers" class="top-dashboard-box-info">';
		echo 'More info <i data-fip-value="icon-right-circled" class="icon-right-circled"></i>';
		echo '</a>';
	echo '</div>';
	
	// Box Views
	echo '<div id="top-dashboard-box-4" class="lf-col-container top-dashboard-box lf-col-2">';
		echo '<div class="top-dashboard-box-count">';
		echo number_format($wpdb->get_var('select SUM(views) FROM '.$wpdb->prefix.'lf_stats'),0,'.',',');
		echo '</div>';
		
		echo '<div class="top-dashboard-box-title">';
		echo 'Views';
		echo '</div>';
		
		echo '<div class="top-dashboard-box-icon">';
		echo '</div>';
		
		echo '<a href="admin.php?page=leadflow-stats" class="top-dashboard-box-info">';
		echo 'More info <i data-fip-value="icon-right-circled" class="icon-right-circled"></i>';
		echo '</a>';
	echo '</div>';
	
	// Box Sales
	echo '<div id="top-dashboard-box-5" class="lf-col-container top-dashboard-box lf-col-2">';
		echo '<div class="top-dashboard-box-count">';
		$get_total_transactions_value=$wpdb->get_var('SELECT SUM(meta_value) FROM '.$wpdb->prefix.'postmeta WHERE meta_key="ttv"');
		$get_total_users=$wpdb->get_var('SELECT COUNT(*) FROM '.$wpdb->prefix.'postmeta WHERE meta_key="ttc" AND meta_value>0');
		
		if($get_total_users) echo '$'.number_format(round($get_total_transactions_value/$get_total_users),2,'.',',');
		else echo '$0.00';
		echo '</div>';
		
		echo '<div class="top-dashboard-box-title">';
		echo 'Lifetime Customer Value';
		echo '</div>';
		
		echo '<div class="top-dashboard-box-icon">';
		echo '</div>';
		
		echo '<a href="edit.php?post_type=leadflow-subscribers" class="top-dashboard-box-info">';
		echo 'More info <i data-fip-value="icon-right-circled" class="icon-right-circled"></i>';
		echo '</a>';
	echo '</div>';
	
	
	
	echo '<div class="clearfix"></div>';

    // Container Start
    echo '<div class="lf-col-container lf-col-8">';
    // Container Title Start
    echo '<div class="lf-title">';
    echo '<h3>World Map Events</h3>';
    // Actions
    echo '<div class="lf-actions">';
    echo '</div>';
    // Container Title End
    echo '</div>';
    // Container Content
    echo '<div class="lf-content">';
    echo '<div id="world_map" style="width: 100%; height: 500px;"></div>';
    echo '</div>';
    echo '</div>';
    // Container End
	
	
	
	// Container Start
    echo '<div class="lf-col-container lf-col-4" style="margin-right:0px;">';
    $events = leadflow_stats::events_get(array('flow_ecommerce','flow','optin'), 8);
	
	$cc=0;
	$colors=array(0=>'#E60B0B',1=>'#A4BF0E',2=>'#0E8EBF');
	
	if ($events) {
      foreach ($events as $event) {
		$subscriber = leadflow_subscribers_common::get_details($event['uuid']);
		$gravatar = '//www.gravatar.com/avatar/' . md5(strtolower(trim($subscriber['email']))) . '?d=identicon&s=48';
						
		echo '<div class="dashboard-subscriber-row" style="border-left: 6px solid '.$colors[$cc%3].';">';
			echo '<div class="dashboard-subscriber-avatar"><a href="'.get_edit_post_link($event['uuid']).'"><img src="'.$gravatar.'" /></a></div>';
			
			echo '<div class="dashboard-subscriber-info">';
				echo '<a href="'.get_edit_post_link($event['uuid']).'">';
					if (empty($subscriber['firstname']) && empty($subscriber['lastname'])) {
					  echo '<i>Name not set</i> ('.$subscriber['email'].')';
					} else {
					  echo '<b>' . $subscriber['firstname'] . ' ' . $subscriber['lastname'] . '</b>';
					}
				echo '</a>';
				
				echo '<div class="dashboard-subscriber-action">';
				if ($event['type'] == 'flow_ecommerce') {
				  echo 'New transaction via ' . get_the_title($event['post_id']) . ' flow valued at $' . $event['price'];
				  
				} elseif ($event['type'] == 'flow') {
				  if ($event['new']) {
					echo 'New subscriber, added via ' . get_the_title($event['post_id']) . ' flow';
				  } else {
					echo 'Passed through ' . get_the_title($event['post_id']) . ' flow';
				  }
				} elseif ($event['type'] == 'optin') {
				  if ($event['new']) {
					echo 'New subscriber, added via ' . get_the_title($event['post_id']) . ' optin';
				  } else {
					echo 'Opted in through ' . get_the_title($event['post_id']) . ' optin';
				  }
				}
				echo '</div>';
					
		   		
			echo '</div>';
			
			echo '<div class="dashboard-subscriber-time">';				
				echo human_time_diff($event['timestamp'],  current_time('timestamp')). ' ago';
				echo '</div>';
			
		echo '</div>';
		
		$cc++;		
      } // foreach
    } // if ($subscribers)
	
	
	
    echo '</div>';
    // Container End
	
	

    echo '<div class="clearfix"></div>';

    echo '<div class="lf-col-container lf-col-8">';
    echo '<div class="lf-title">';
    echo '<h3>Events Log</h3>';
    // Actions
    echo '<div class="lf-actions">';
    //echo '<a href="#"><i class="dashicons dashicons-update"></i></a>';
    echo '</div>';
    echo '</div>';
    echo '<div class="lf-content" style="padding: 15px;">';
    echo '<ul id="latest_events"></ul>';
    echo '</div>';
    echo '</div>';

    echo '<div class="lf-col-container lf-col-4" style="margin-right:0px;">';
    echo '<div class="lf-title">';
    echo '<h3>Subscribers per Country</h3>';
    // Actions
    echo '<div class="lf-actions">';
    //echo '<a href="#"><i class="dashicons dashicons-update"></i></a>';
    echo '</div>';
    echo '</div>';
    echo '<div class="lf-content">';
    echo '<div id="countries_pie" style="width: 100%; height: 400px;"></div>';
    echo '</div>';
    echo '</div>';

    echo '<div class="clearfix"></div>';

    echo '<div class="lf-col-container lf-col-6">';
    echo '<div class="lf-title">';
    echo '<h3>Optin Views and Conversions in the past 14 days</h3>';
    // Actions
    echo '<div class="lf-actions">';
    echo '&nbsp;';
    echo '</div>';
    echo '</div>';
    echo '<div class="lf-content">';
    echo '<div id="optins_chart" style="width: 100%; height: 200px;"></div>';
    echo '</div>';
    echo '</div>';

    echo '<div class="lf-col-container lf-col-6">';
    echo '<div class="lf-title">';
    echo '<h3>Flows Views and Conversions in the past 14 days</h3>';
    // Actions
    echo '<div class="lf-actions">';
    echo '&nbsp;';
    echo '</div>';
    echo '</div>';
    echo '<div class="lf-content">';
    echo '<div id="flows_chart" style="width: 100%; height: 200px;"></div>';
    echo '</div>';
    echo '</div>';

    echo '<div class="clearfix"></div>';
	

    echo '<div class="lf-col-container lf-col-12" style="margin-right:0px;">';
    echo '<div class="lf-title">';
    echo '<h3>Subscribers growth over time</h3>';
    // Actions
    echo '<div class="lf-actions">';
    echo '&nbsp;';
    echo '</div>';
    echo '</div>';
    echo '<div class="lf-content">';
    echo '<div id="subgrowth_chart" style="width: 100%; height: 200px;"></div>';
    echo '</div>';
    echo '</div>';
	
	echo '</div>'; // wrapper
  } // content

  

  static function get_map_markers($last_timestamp = 0) {
    $max_markers = 50;
    $markers = array();

    $events = leadflow_stats::events_get(array(), $max_markers * 2);
    foreach ($events as $event) {
      if ($last_timestamp && $last_timestamp >= $event['timestamp']) {
        break;
      }
      if (sizeof($markers) > $max_markers) {
        break;
      }
      if (empty($event['country'])) {
        continue;
      }

      $address = '';
      if (!empty($event['city'])) {
        $address .= $event['city'] . ', ';
      }
      if (!empty($event['region'])) {
        $address .= $event['region'] . ', ';
      }
      $address .= $event['country'];

      $coordinates = leadflow_common::get_coordinates($address, false);
      if (!$coordinates) {
        continue;
      }
	  
	  if(isset($event['price']) && $event['price']>0){
		  $icon='bank';  
	  } else {
		  $icon='star';  
	  }
	  
      $markers[] = array('lat' => $coordinates['lat'], 'lng' => $coordinates['lng'], 'address' => $address, 'timestamp_diff' => human_time_diff($event['timestamp'], current_time('timestamp')), 'timestamp' => $event['timestamp'], 'icon' => $icon);
    } // foreach events

    return $markers;
  } // get_map_markers


  static function setup_js_vars() {
    $markers = self::get_map_markers();
    $events = leadflow_stats::events_get_formatted_dashboard(13, 0);

    $tmp = leadflow_stats::get_subscribers_stats(2, 5);
	
    $countries = array('Country name', 'Percentage');
    foreach ($tmp['countries'] as $country => $cnt) {
      $countries[$country] = $cnt['cnt'];
    }
	
	
	$optins_stats = leadflow_stats::get_optins_chart(14); 
	$flows_stats = leadflow_stats::get_flows_chart(14); 
	$subscriber_growth = leadflow_stats::get_subscriber_growth(14); 
	
	
	wp_localize_script('jquery', 'lf_plugin_url', LF_PLUGIN_URL);
    wp_localize_script('jquery', 'lf_subscriber_growth', $subscriber_growth);
    wp_localize_script('jquery', 'lf_flows_stats', $flows_stats);
    wp_localize_script('jquery', 'lf_optins_stats', $optins_stats);
    wp_localize_script('jquery', 'lf_map_markers', $markers);
    wp_localize_script('jquery', 'lf_events', $events);
    wp_localize_script('jquery', 'lf_countries_pie', $tmp['countries']);
    wp_localize_script('jquery', 'lf_dashboard_last_event', (string) current_time('timestamp'));
  } // enqueue_files


  static function heartbeat_received($response, $data) {
    if(!empty($data['lf_dashboard_last_event'])) {
      $markers = self::get_map_markers($data['lf_dashboard_last_event']);
      $events = leadflow_stats::events_get_formatted_dashboard(10, $data['lf_dashboard_last_event']);

      $response['lf_map_markers'] = $markers;
      $response['lf_events'] = $events;
      $response['lf_dashboard_last_event'] = (string) current_time('timestamp');
    }

    return $response;
  } // heartbeat_received

  
} // leadflow_dashboard