<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_stats_view extends leadflow {

  // stats page markup
  static function content() {
    global $wpdb, $stats_view, $stats_type, $date_from, $date_to, $active_test;
    
	
		 
    $stats_view = '';
    $date_from  = date('Y-m-d');
    $date_to    = date('Y-m-d', (30*DAY_IN_SECONDS)+current_time('timestamp'));

    if (!empty($_GET['stats-view'])) {
      $stats_view = $_GET['stats-view'];
      $stats_view = explode('|', $stats_view);
      $stats_type = $stats_view[0];
      $stats_view = $stats_view[1];
    }
    
	
	
    if (!empty($_GET['stats-view'])) {
	 $stats_view = explode('|', $_GET['stats-view']);
    }
     

    echo '<div class="wrap optin-stats">';
    echo '<h2>LeadsFlow Statistics</h2>';

    
      echo '<div id="stats-selector">';
      echo '<p>Please select an OptIn Page, an A/B Test or Flow to view their statistics.</p>';
      echo '<form method="get" action="' . admin_url('admin.php') . '">';
      echo '<input type="hidden" name="page" value="leadflow-stats"/>';
      echo '<label for="stats-view"><b>Select stats to view:</b></label> ';
      echo '<select id="stats-view" name="stats-view">';
      echo '<option value="">-</option>';

      echo '<optgroup label="Optins">';
      // Optins
      $optins = leadflow_optin_common::get_all_optins();
      if ($optins) {
        foreach ($optins as $optin) {
          echo '<option value="optin|' . $optin->ID . '" '.($optin->ID==$stats_view[1]?'selected="selected"':'').'>' . $optin->post_title . '</option>';
        }
      }
      echo '</optgroup>';

      echo '<optgroup label="Flows">';
      // Flows
      $flows = get_posts(array('post_type' => 'lead-flows', 'numberposts' => -1, 'post_status' => 'publish'));
      if ($flows) {
        foreach ($flows as $flow) {
          echo '<option value="flow|' . $flow->ID . '" '.($flow->ID==$stats_view[1]?'selected="selected"':'').'>' . $flow->post_title . '</option>';
        }
      }
      echo '</optgroup>';

      echo '<optgroup label="A/B Tests">';
      // A/B Tests
      $abtests = leadflow_ab_test_common::get_all();
      if ($abtests) {
        foreach ($abtests as $abtest) {
          echo '<option value="ab|' . $abtest->ID . '" '.($abtest->ID==$stats_view[1]?'selected="selected"':'').'>' . $abtest->post_title . '</option>';
        }
      }
      echo '</optgroup>';

      echo '</select> ';
	  
	  echo '<label for="stats-view-range"><strong>Select the date range:</strong></label> <input id="stats-view-range" name="stats-view-range" val="" />';
	  
      echo ' <button type="submit" href="#" class="button button-primary">Next</button>';
      echo '</form>';
      echo '</div>';
	  
	  
   
           
	  echo '<div id="stats_chart" style="height:500px;"></div>';
      

    


    echo '</div>';
  } // stats_page


} // lf_optin_options_stats