jQuery( document ).ready( function( $ ) {
	if ( $( '.textwidget > .marketing-calculator' ) ) {
		$( '.textwidget > .marketing-calculator div' ).each( function() {
			$( this ).attr( 'title', $( this ).html() );
		});
	}

	$( '.marketing-calculator div' ).each( function() {
		$( this ).click( function() {
			$( this ).parent().next().find( 'input' ).focus();
		});
	});

	$( 'input:text' ).attr( 'raw', 0 ).change( function() {
		if ( $( this ).hasClass( 'money' ) )
			$( this ).attr( 'raw', toNumber( $( this ).val() ) ).val( money( $( this ).attr('raw') ) );
		else if ( $( this ).hasClass( 'percentage' ) )
			$( this ).attr( 'raw', toNumber( $( this ).val() ) / 100 ).val( percentage( $( this ).val() / 100 ) );
		else
			$( this ).attr( 'raw', toNumber( $( this ).val() ) );
	});

	$( '.marketing-calculator form#projection' ).submit( function() {
		var avgTotalMonthGrossSales =
			$( '#avg-daily-gross-sales' ).attr('raw') *
			$( '#days-month-open' ).attr('raw');
		$( '#avg-total-month-gross-sales' )
			.attr( 'raw', avgTotalMonthGrossSales )
			.val( money( avgTotalMonthGrossSales ) );

		var avgTickets =
			$( '#avg-total-month-gross-sales' ).attr('raw') /
			$( '#avg-total-month-trans' ).attr('raw');
		$( '#avg-tickets' )
			.attr( 'raw', avgTickets)
			.val( money( avgTickets ) );

		var vipRewardsSubscribers =
			$( '#avg-month-cust' ).attr('raw') *
			$( '#perc-cust-join-club' ).attr('raw') * 3;
		$( '#vip-rewards-subscribers' )
			.attr( 'raw', vipRewardsSubscribers )
			.val( vipRewardsSubscribers );

		var custRedemption =
			$( '#vip-rewards-subscribers' ).attr('raw') *
			$( '#vip-offer-redemption-perc' ).attr('raw');
		$( '#cust-redemption' )
			.attr( 'raw', custRedemption )
			.val( Math.round( custRedemption ) );

		var revenueJustOneOffer =
			$( '#avg-tickets' ).attr('raw') *
			$( '#vip-rewards-subscribers' ).attr('raw') *
			$( '#vip-offer-redemption-perc' ).attr('raw');
		$( '#revenue-just-one-offer' )
			.attr( 'raw', revenueJustOneOffer )
			.val( money( revenueJustOneOffer ) );

		var additionalMonthlyRevenue =
			$( '#vip-rewards-subscribers' ).attr('raw') *
			$( '#vip-offer-redemption-perc' ).attr('raw') *
			$( '#avg-tickets' ).attr('raw') * 4 *
			( 1 - $( '#club-offer-discount-rate' ).attr('raw') );
		$( '#additional-monthly-revenue' )
			.attr( 'raw', additionalMonthlyRevenue )
			.val( money( Math.round( additionalMonthlyRevenue ) ) );

		var additionalRevenue =
			$( '#additional-monthly-revenue' ).attr('raw') / 4;
		$( '#additional-revenue' )
			.attr( 'raw', additionalRevenue )
			.val( money( Math.round( additionalRevenue ) ) );

		var additionalYearlyRevenue =
			$( '#additional-monthly-revenue' ).attr('raw') * 12;
		$( '#additional-yearly-revenue' )
			.attr( 'raw', additionalYearlyRevenue )
			.val( money( Math.round( additionalYearlyRevenue ) ) );

		var additionalFiveYearRevenue =
			$( '#additional-yearly-revenue' ).attr('raw') * 5;
		$( '#additional-five-year-revenue' )
			.attr( 'raw', additionalFiveYearRevenue )
			.val( money( Math.round( additionalFiveYearRevenue ) ) );

		return false;
	});

	$( '.marketing-calculator form#redemption' ).submit( function() {
		var dealDiscount =
			1 - $( '#deal-price' ).attr('raw') / $( '#normal-price' ).attr('raw');
		$( '#deal-discount' )
			.attr( 'raw', dealDiscount )
			.val( percentage( dealDiscount ) );

		var revenueRedeemedDeal = $( '#deal-price' ).attr('raw');
		$( '#revenue-redeemed-deal' )
			.attr( 'raw', revenueRedeemedDeal )
			.val( money( revenueRedeemedDeal ) );

		var redemptionRate =
			$( '#people-redemption' ).attr('raw') / $( '#people-receiving-deal' ).attr('raw');
		$( '#redemption-rate' )
			.attr( 'raw', redemptionRate )
			.val( percentage( redemptionRate ) );

		var totalRedemptionRevenue =
			$( '#people-redemption' ).attr('raw') *
			$( '#revenue-redeemed-deal' ).attr('raw');
		$( '#total-redemption-revenue' )
			.attr( 'raw', totalRedemptionRevenue )
			.val( money( totalRedemptionRevenue ) );

		return false;
	});
});

// format number as percentage
function percentage( n ) {
	var perc_sign = '%';

	var number = ( n * 100 ).toString().replace(/[^0-9\.]/g, '');
	if ( number.length > 0 ) {
		return parseFloat( number ).toFixed( 2 ) + perc_sign;
	}
	return '';
}

// format number as currency
function money( n ) {
	var money_sign = '$';

	var number = n.toString().replace(/[^0-9\.]/g, '');

	if ( number.length > 0 ) {
		return money_sign + round( number );
	}
	return '';
}

// parse number
function toNumber( n ) {
	var number = n.toString().replace(/[^0-9\.]/g, '');

	if ( number.length > 0 )
		return parseFloat( number );

	return 0;
}

// round numbers, default is 2 decimals
function round( n, dec ) {
	var number = n.toString().replace(/[^0-9\.]/g, '');
	if ( ! dec )
		dec = 2;

	if ( number.length > 0 ) {
		var factor = Math.pow( 10, dec );
		number = ( Math.floor( n * factor + ( ( n * factor * 10 ) % 10 >= 5 ? 1 : 0 ) ) / factor ).toFixed( dec );

		var n_arr = number.split('.');
		var thousands = n_arr[0].split('').reverse().join('').match(/.{1,3}/g).join(',');
		var decimals = ( n_arr[1] ) ? '.' + n_arr[1] : '';
		var answer =  thousands.split('').reverse().join('') + decimals;

		return answer;
	}
	return '';
}

function marketing_calculator_check_email(email)
{
	var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	if (!filter.test(email))
	{
		return false;
	}
	else
	{
		return true;
	}
}

function roi_send_email()
{
	var plugin_url = document.getElementById('plugin_url').value;
	var a_d_g_sales = document.getElementById('avg-daily-gross-sales').value;
	var open_days_pm = document.getElementById('days-month-open').value;
	var a_t_m_g_sales = document.getElementById('avg-total-month-gross-sales').value;
	var avg_total_month_trans = document.getElementById('avg-total-month-trans').value;
	var avg_tickets = document.getElementById('avg-tickets').value;
	var avg_month_cust = document.getElementById('avg-month-cust').value;
	var perc_cust_join_club = document.getElementById('perc-cust-join-club').value;
	var vip_rewards_subscribers = document.getElementById('vip-rewards-subscribers').value;
	var vip_offer_redemption_perc = document.getElementById('vip-offer-redemption-perc').value;
	var cust_redemption = document.getElementById('cust-redemption').value;
	var club_offer_discount_rate = document.getElementById('club-offer-discount-rate').value;
	var additional_revenue = document.getElementById('additional-revenue').value;
	var revenue_just_one_offer = document.getElementById('revenue-just-one-offer').value;
	var additional_monthly_revenue = document.getElementById('additional-monthly-revenue').value;
	var additional_yearly_revenue = document.getElementById('additional-yearly-revenue').value;
	var additional_five_year_revenue = document.getElementById('additional-five-year-revenue').value;
	
	var email = document.getElementById('email').value;
	if(email == '' || marketing_calculator_check_email(email) == false)
	{
		alert('Pleaes Enter An Valid Email Address.');
		return false;
	}
	
	var url = plugin_url+"/send_email.php?type=projection&a_d_g_sales="+a_d_g_sales+'&open_days_pm='+open_days_pm+'&a_t_m_g_sales='+a_t_m_g_sales+'&avg_total_month_trans='+avg_total_month_trans+'&avg_tickets='+avg_tickets+'&avg_month_cust='+avg_month_cust+'&perc_cust_join_club='+perc_cust_join_club+'&vip_rewards_subscribers='+vip_rewards_subscribers+'&vip_offer_redemption_perc='+vip_offer_redemption_perc+'&cust_redemption='+cust_redemption+'&club_offer_discount_rate='+club_offer_discount_rate+'&additional_revenue='+additional_revenue+'&revenue_just_one_offer='+revenue_just_one_offer+'&additional_monthly_revenue='+additional_monthly_revenue+'&additional_yearly_revenue='+additional_yearly_revenue+'&additional_five_year_revenue='+additional_five_year_revenue+'&email='+email;
	
	jQuery(document).ready(function(){
		jQuery('#status_email').html('<img src="'+plugin_url+'/images/loading.gif" style="text-align:center;">');
		jQuery.post(url, function(data)
		{
			if(data == 'true')
			{
				jQuery('#status_email').html('<img src="'+plugin_url+'/images/true.png" style="text-align:center;">');
			}
			else
			{
				jQuery('#status_email').html('<img src="'+plugin_url+'/images/false.png" style="text-align:center;">');
			}
			setTimeout("jQuery('#status_email').html('<input type=\"button\" onclick=\"roi_send_email()\" name=\"send_email\" id=\"send_email\" value=\"EMail Me Results\" />')", 2000);
		});
	})
}

function mc_handle_auto_reponder(val)
{
	if(val == '4')
	{
		document.getElementById('ar_code_label').style.display = 'none';
		document.getElementById('ar_code_textarea').style.display = 'none';
		document.getElementById('cc_info_div').style.display = 'block';
	}
	else
	{
		document.getElementById('ar_code_label').style.display = 'block'
		document.getElementById('ar_code_textarea').style.display = 'block';
		document.getElementById('cc_info_div').style.display = 'none';
	}
}

function mc_get_cc_list_ids(FilePath,list_id)
{
	var img_url = document.getElementById('img_url').value;
	var user = document.getElementById('cc_username').value;
	var pass = document.getElementById('cc_password').value;
	var api_key = document.getElementById('cc_api_key').value;
	document.getElementById('loading_lists').innerHTML = '<img src="'+img_url+'loading.gif" />';
	document.getElementById('cc_save_button').style.display = 'none';
	jQuery.post(FilePath+'?action=get_cc_lists_ids&user='+user+'&pass='+pass+'&api_key='+api_key+'&list_id='+list_id, function(data)
	{
		jQuery("#cc_list").html(data);
		document.getElementById('loading_lists').innerHTML = '';
		document.getElementById('cc_save_button').style.display = 'block';
	});
}

function mc_expand_tab(toggle_id,expand_id)
{
	var img_url = document.getElementById('img_url').value;
	var toggle_img = document.getElementById(toggle_id).src;
	jQuery(document).ready(function(){
		if(toggle_img == img_url+'sign-plus.png')
		{
			jQuery('#'+expand_id).slideDown('slow');
			document.getElementById(toggle_id).src = img_url+'sign-minus.png';
		}
		else if(toggle_img == img_url+'sign-minus.png')
		{
			jQuery('#'+expand_id).slideUp('slow');
			document.getElementById(toggle_id).src = img_url+'sign-plus.png';
		}
	})
}

function mc_sort_records(type,orderby,url)
{
	window.location = url+'&sortType='+orderby+'&orderBy='+type;
}