<?php
	/*
	Plugin Name: Marketing Calculator
	Description: Shortcode for adding a marketing projection or redemption calculator.
	Author: xurdna
	Version: 0.1
	Author URI: http://andrux.net
	*/

	class Marketing_Calculator
	{
		private $plugin_path;
		private $plugin_url;

		public function __construct() {
			$this->plugin_path = dirname( __FILE__ );
			$this->plugin_url = WP_PLUGIN_URL . '/' . basename( dirname( __FILE__ ) );
			$this->load_css();
			$this->load_js();			
			// Creating Table
			register_activation_hook(__FILE__,array($this,'mc_db_table'));
			
			// Drop Table When Deleting Plugin
			//register_uninstall_hook(__FILE__,'mc_drop_table');

			// Display Admin Notices
			add_action('admin_notices', 'mc_admin_notice');
			// Intializing Sessions In WordPress
			if(function_exists('mc_init_sessions'))
			{
				@add_action('init', 'mc_init_sessions');
			}

			add_filter( 'widget_text', 'do_shortcode' );
		}
		
		public function mc_db_table()
		{
			global $wpdb;
			$Table_name = $wpdb->prefix . 'mc_settings';
			if( !$wpdb->get_var( "SHOW TABLES LIKE $Table_name" ) ) {
				$sql = "CREATE TABLE $Table_name
				(
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`AR_Company` tinyint(4) NOT NULL,
					`Auto_Responder_Code` longtext NOT NULL,
					`CC_User` varchar(255) NOT NULL,
					`CC_Pass` varchar(255) NOT NULL,
					`CC_API_Key` varchar(512) NOT NULL,
					`CC_List_ID` varchar(255) NOT NULL,
					`CreatedDate` datetime,
					 PRIMARY KEY (`id`)
				);";	
				include_once(ABSPATH . 'wp-admin/includes/upgrade.php');
				dbDelta($sql);
			}
			
			$Table_name = $wpdb->prefix . 'mc_email_report';
			if( !$wpdb->get_var( "SHOW TABLES LIKE $Table_name" ) ) {
				$sql = "CREATE TABLE $Table_name
				(
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`Email` varchar(512) NOT NULL,
					`Report` longtext NOT NULL,
					`CreatedDate` timestamp,
					 PRIMARY KEY (`id`)
				);";	
				include_once(ABSPATH . 'wp-admin/includes/upgrade.php');
				dbDelta($sql);
			}
		}
		
		public function marketing_calculator_admin_menu()
		{
			add_menu_page('Marketing Calculator', 'Marketing Calculator', 'administrator','marketing_calucultor_main',array($this, 'marketing_calucultor_settings_contents'));
			add_submenu_page('marketing_calucultor_main','Settings','Settings','administrator','marketing_calucultor_main',array($this,'marketing_calucultor_settings_contents'));
			add_submenu_page('marketing_calucultor_main','Email Report','Email Report','administrator','marketing_calucultor_report',array($this,'marketing_calucultor_report_contents'));
		}
				
		public function load_css() {
			wp_enqueue_style( 'marketing-calculator-css', $this->plugin_url . '/css/style.css' );
		}

		public function load_js() {
			wp_enqueue_script( 'marketing-calculator-js', $this->plugin_url . '/js/core.js', array( 'jquery' ) );
		}

		public function marketing_calucultor_report_contents()
		{
			require_once('require_email_report.php');
		}
		
		public function marketing_calucultor_settings_contents()
		{
			global $wpdb;
			$table_settings = $wpdb->prefix.'mc_settings';
			require_once('cc_class.php');
			$get_ar = $wpdb->get_results("SELECT * FROM $table_settings");
			?>
            <form name="settings" action="<?=$this->plugin_url?>/save_settings.php" method="post">
             <input type="hidden" name="img_url" id="img_url" value="<?=$this->plugin_url?>/images/" />
             <table align="center" width="auto">
                <tr>
                 <td width="100%;" align="center"><h2>Marketing Calculator</h2></td>
                </tr>
                <tr>
                 <td>
                  <select name="auto_responder_company" onchange="mc_handle_auto_reponder(this.value)" id="auto_responder_company" style="width:340px;">
                   <option value="">None</option>
                   <option <?php if($get_ar[0]->AR_Company == '1'){?> selected="selected" <?php } ?> value="1">Aweber</option>
                   <option <?php if($get_ar[0]->AR_Company == '2'){?> selected="selected" <?php } ?> value="2">MailChimp</option>
                   <option <?php if($get_ar[0]->AR_Company == '3'){?> selected="selected" <?php } ?> value="3">iContact(Manual Form)</option>
                   <option <?php if($get_ar[0]->AR_Company == '4'){?> selected="selected" <?php } ?> value="4">Constant Contact</option>
                  </select>
                 </td>
                </tr>
                <tr>
                  <?php
				  if($get_ar[0]->AR_Company == 4)
				  {
					  $cc_display = 'display:block;';
					  $ar_form = 'display:none;';
				  }
				  else
				  {
					  $cc_display = 'display:none;';
					  $ar_form = 'display:block;';
				  }
				  ?>
                 <td><div style="<?=$ar_form?>" id="ar_code_label">Put Your Code Here</div></td>
                </tr>
                <tr>
                 <td><div style="<?=$ar_form?>" id="ar_code_textarea"><textarea name="auto_responder" id="auto_responder" style="width:340px; height:75px; font-weight:normal;"><?=mc_DBout($get_ar[0]->Auto_Responder_Code)?></textarea></div></td>
                </tr>
                <tr>
                 <td colspan="2">
                  <div id="cc_info_div" style=" <?=$cc_display?>">
                   <table>
                    <tr>
                     <td>Username</td>
                    </tr>
                    <tr>
                     <td><input type="text" name="cc_username" value="<?=$get_ar[0]->CC_User?>" id="cc_username" style="width:338px;" /></td>
                    </tr>
                    <tr>
                     <td>Password</td>
                    </tr>
                    <tr>
                     <td><input type="password" name="cc_password" value="<?=$get_ar[0]->CC_Pass?>" id="cc_password" style="width:338px;" /></td>
                    </tr>
                    <tr>
                     <td>API Key</td>
                    </tr>
                    <tr>
                     <td><input type="text" name="cc_api_key" id="cc_api_key" value="<?=$get_ar[0]->CC_API_Key?>" style="width:338px;" /></td>
                    </tr>
                    <tr>
                     <td>
                     <div style="float:left;" id="cc_save_button"><input type="button" onclick="mc_get_cc_list_ids('<?=$this->plugin_url?>/ajax_requests.php','')" class="button-primary" name="cc_info_submit" value="Get Lists" /></div>
                     <div style="float:left;" id="loading_lists"></div>
                     </td>
                    </tr>
                    <tr>
                     <td>Select List</td>
                    </tr>
                    <tr>
                     <td>
                      <?php
					  if($get_ar[0]->AR_Company == 4)
					  {
						  ?>
                          <script type="text/javascript">
						  window.onunload = mc_get_cc_list_ids('<?=$this->plugin_url?>/ajax_requests.php','<?=$get_ar[0]->CC_List_ID?>');
						  </script>
                          <?php
					  }
					  ?>
                      <select name="cc_list" id="cc_list" style="width:340px;">
                       <option value="">Select List</option>
                      </select>
                     </td>
                    </tr>
                   </table>
                  </div>
                 </td>
                </tr>
                <tr>
                 <td>
                  <input type="submit" class="button-primary" name="save_auto_responder" value="Save" /></div>
                 <div style="float:left;" id="loading_lists"></div>
                 </td>
               </tr>
             </table>
            </form>
            <?php
		}

		/**
		 * Outputs HTML for the marketing calculator.
		 *
		 * @return string HTML for marketing calculator
		 */
		public function calculator_shortcode( $atts ) {
			$atts = shortcode_atts(
					array(
						'title' => null,
						'type' => 'projection'
						), $atts );

			$this->load_css();
			$this->load_js();

			ob_start();
		?>
		<div class="marketing-calculator">
			<?php if ( $atts['title'] != null ): ?>
				<h2><?php echo $atts['title']; ?></h2>
			<?php endif; ?>
			<?php include_once ( $atts['type'] == 'projection' ) ? 'projection.php' : 'redemption.php'; ?>
		</div>
		<?php
			return ob_get_clean();
		}
	}

	if ( ! isset( $marketing_calculator ) ) {
		$marketing_calculator = new Marketing_Calculator();

		add_shortcode( 'marketing-calculator', array( $marketing_calculator, 'calculator_shortcode' ) );
		add_action('admin_menu', array($marketing_calculator,'marketing_calculator_admin_menu'));
	}

	function mc_DBin($string)
	{
		$a = html_entity_decode($string);
		return trim(htmlspecialchars($a,ENT_QUOTES));
	}
	function mc_DBout($string)
	{
		$string = stripslashes(trim($string));
		return html_entity_decode($string);
	}

	function mc_admin_notice(){
		global $pagenow;
		if(isset($_SESSION['mc_admin_notice']) && !empty($_SESSION['mc_admin_notice']))
		{
			if($pagenow == 'admin.php')
			{
				echo '<div class="updated" style="color:#21759B;">
				   <p>'.$_SESSION['mc_admin_notice'].'</p>
				</div>';
			}
			unset($_SESSION['mc_admin_notice']);
		}
	}
	
	function mc_redirect_page($URL)
	{
		?>
		<script type="text/javascript">
			window.location = "<?=$URL?>";
		</script>
		<?php
		die();
	}
	
	function mc_init_sessions() {
		if (!session_id()) {
			session_start();
		}
	}

	function mc_auto_responder($url)
	{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, mc_DBout($url));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 6.1; rv:6.0) Gecko/20110814 Firefox/6.0');
		$resp = curl_exec($ch);
		
		return $resp;
	}
?>