<?php

/**

 * Plugin Name: WP Schema

 * Plugin URI:

 * Description: The plugin that generates a schema to the header.

 * Version: 1.5

 * Author: Zach Anderson

 * Author URI:

 * Text Domain: 

 * Copyright:

 */



class ISAAC_WOI

{

    protected $_plugin_dir;

    protected $_plugin_url;

	public $options;

    public function __construct()

    {

        //@session_start();

        $this->_plugin_dir = dirname(__FILE__);

        $this->_plugin_url = get_site_url(null, 'wp-content/plugins/' . basename($this->_plugin_dir));



        

		register_activation_hook( __FILE__, array($this,'create_plugin_database_table') );

		add_action( 'init', array($this,'activate_au') );

		add_action('init', [ $this, 'do_output_buffer']);

		add_action( 'plugins_loaded', array($this,'load'));	

		add_action( 'admin_menu', array($this,'plugin_menu') );    

		add_action( 'wp_head', array($this,'header_script') );

		add_action( 'admin_enqueue_scripts', array($this,'load_admin_libs') );

		add_shortcode( 'feedback_form', array($this,'load_feadback_form') );

		add_action( 'wp_ajax_save_comment', array($this,'save_comment') );
		
		add_action( 'wp_ajax_nopriv_save_comment', array($this,'save_comment') );

		add_action( 'wp_ajax_save_data', array($this,'save_data') );
		
		add_action( 'wp_ajax_nopriv_save_data', array($this,'save_data') );

		add_filter( 'set-screen-option', [ __CLASS__, 'set_screen' ], 10, 3 );

		$feedback_popup_visit=get_option('feedback_popup_visit');

		if(get_option('schema_exclude_yoast_schema_markup')=='1'){

			add_filter('wpseo_json_ld_output', array($this,'bybe_remove_yoast_json'), 10, 1);

		}

		if(!empty($feedback_popup_visit)){

			add_action( 'init', array($this,'check_schema_coockie') );

		}

		if(get_option('feedback_autopopup_flag')=='1'){

						add_action( 'wp_footer', array($this,'load_popup_feadback_form') );

		}

		if(get_option('feedback_autopopup_mob_flag')=='1'&&get_option('feedback_autopopup_flag')!='1'){

					add_action( 'wp_footer', array($this,'load_popup_mob_feadback_form') );

		}

		

		$tblname = 'feedback_review_log';

		$this->add_column_if_not_exist($tblname , 'phone');	

		$this->add_column_if_not_exist($tblname , 'email');

		

	}

	

	function add_column_if_not_exist($tblname, $column, $column_attr = "VARCHAR( 255 ) NULL" )

	{

		global $wpdb;

		

		$wp_track_table = $wpdb->prefix . "$tblname";

		$check_column=$wpdb->get_col( "DESC {$wp_track_table}" );	 

		if(!in_array($column,$check_column)) 

		{

			$sql = "ALTER TABLE " . $wp_track_table ." ADD $column $column_attr";

            $wpdb->query($sql);			

		}   

}

	

	

	

	

	function do_output_buffer() {

        ob_start();

	}

	

	function bybe_remove_yoast_json($data){

	$data = array();

	return $data;

	}

    public  function load()

    {

        if( is_admin() && isset($_GET['page']) && ($_GET['page'] == 'wp_schema.php' || $_GET['page'] == 'feedback_schema') )

        {

            add_action('admin_print_scripts', array($this,'my_admin_scripts'));

            add_action('admin_print_styles',  array($this,'my_admin_styles'));

        }else{
			wp_register_style( 'wp_schema_style', $this->_plugin_url.'/css/wp_schema_style.css' );
			wp_enqueue_style( 'wp_schema_style' );   
			wp_enqueue_script( 'schema_cookie', $this->_plugin_url . '/js/jquery.cookie.js', array('jquery') );
			wp_enqueue_script( 'schema_script', $this->_plugin_url . '/js/wp_schema_script.js', array('jquery') );
			wp_localize_script('mylib', 'WPURLS', array( 'siteurl' => get_option('siteurl'),'adminurl' => get_option('admin_url') ));
		}

		

    }



    public  function my_admin_scripts() 

    {

        wp_register_style( 'sc_select_css', $this->_plugin_url.'/css/select2.min.css' );

        wp_enqueue_style( 'sc_select_css' );      

        wp_enqueue_script('jquery');    

        wp_enqueue_script('media-upload');   

        wp_enqueue_script('thickbox');  

        wp_register_script('my-upload', $this->_plugin_url.'/js/script.js', array('jquery','media-upload','thickbox'));  

        wp_enqueue_script('my-upload');

        wp_enqueue_script( 'js_select', $this->_plugin_url . '/js/select2.full.min.js', array('jquery') );

        wp_enqueue_script( 'schema_select', $this->_plugin_url . '/js/schema_select.js', array('jquery','js_select') );

		

		

		

		// Css rules for Color Picker

		wp_enqueue_style( 'wp-color-picker' );

		 wp_enqueue_script('wp-color-picker');

		

    }

    

    public  function my_admin_styles()  

    { 

        wp_enqueue_style('thickbox'); 

    }



    public function plugin_menu()

    {	

        add_menu_page('WP Schema','WP Schema','manage_options','wp_schema.php',array($this,'plugin_options'),'dashicons-editor-ul',81);

		add_submenu_page('wp_schema.php','Feedback Center','Feedback Center','manage_options','feedback_schema',array($this,'feedback_options'));

		//add_menu_page( 'wp_schema.php','Feedback Activity Log', 'Feedback Activity Log', 'manage_options', 'feedback_list', 'my_render_list_page' );

		$hook = add_submenu_page(

			'wp_schema.php',

			'Feedback Logs',

			'Feedback Logs',

			'manage_options',

			'activity_logs',

			[ $this, 'plugin_settings_page' ]

		);



		add_action( "load-$hook", [ $this, 'screen_option' ] );

    }

	public function getUrlContent($url){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_HEADER, 0);

		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,  FALSE);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		curl_setopt($ch, CURLOPT_URL, $url);

		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

		curl_setopt($ch, CURLOPT_MAXREDIRS, 10);

		$data = curl_exec($ch);

		curl_close($ch);

		return $data;

	}

	

	public function feedback_options() 



	 {

		if ( !current_user_can( 'manage_options' ) )  

        {

            wp_die( __( 'You do not have sufficient permissions to access this page.' ) );

        }

		if( isset( $_POST['submit_feedback'] ) )

        {

			

            if(isset($_POST['feedback_button_size']))

            {

                $feedback_button_size = $_POST['feedback_button_size'];

                update_option('feedback_button_size',$feedback_button_size);

            }

			

			if(isset($_POST['feedback_button_color']))

            {

                $feedback_button_color = $_POST['feedback_button_color'];

                update_option('feedback_button_color',$feedback_button_color);

            }

			

			if(isset($_POST['feedback_button_text']))

            {

                $feedback_button_text = $_POST['feedback_button_text'];

                update_option('feedback_button_text',$feedback_button_text);

            }

			

            if(isset($_POST['feedback_heading_yes_no']))

            {

                $feedback_heading_yes_no = $_POST['feedback_heading_yes_no'];

                update_option('feedback_heading_yes_no',$feedback_heading_yes_no);

            }



            if(isset($_POST['feedback_heading_website_comment']))

            {

                update_option('feedback_heading_website_comment',$_POST['feedback_heading_website_comment']);

            }

			

			if(isset($_POST['feedback_heading_no_comment']))

            {

                update_option('feedback_heading_no_comment',$_POST['feedback_heading_no_comment']);

            }

			

            if(isset($_POST['feedback_notification_email']))

            {

                update_option('feedback_notification_email',$_POST['feedback_notification_email']);

            }

			//if(isset($_POST['feedback_unlimited_popup']))

            {

                update_option('feedback_unlimited_popup',$_POST['feedback_unlimited_popup']);

            }

            //if(isset($_POST['feedback_notification_emails']))

            {

                update_option('feedback_notification_emails',$_POST['feedback_notification_emails']);

            }



            if(isset($_POST['feedback_review_website']))

            {

                update_option('feedback_review_website',$_POST['feedback_review_website']);

            }

			

			if(isset($_POST['feedback_review_url']))

            {

                update_option('feedback_review_url',$_POST['feedback_review_url']);

            }

			

			//if(isset($_POST['feedback_review_websites']))

            {

                update_option('feedback_review_websites',$_POST['feedback_review_websites']);

            }



			if(isset($_POST['feedback_email_subject_yes']))

            {

                update_option('feedback_email_subject_yes',$_POST['feedback_email_subject_yes']);

            }

			if(isset($_POST['feedback_email_message_yes']))

            {

                update_option('feedback_email_message_yes',$_POST['feedback_email_message_yes']);

            }

			

			if(isset($_POST['feedback_email_subject_no']))

            {

                update_option('feedback_email_subject_no',$_POST['feedback_email_subject_no']);

            }

			if(isset($_POST['feedback_email_message_no']))

            {

                update_option('feedback_email_message_no',$_POST['feedback_email_message_no']);

            }

			

			if(isset($_POST['feedback_email_subject_comment']))

            {

                update_option('feedback_email_subject_comment',$_POST['feedback_email_subject_comment']);

            }

			if(isset($_POST['feedback_email_message_comment']))

            {

                update_option('feedback_email_message_comment',$_POST['feedback_email_message_comment']);

            }

			//if(isset($_POST['feedback_autopopup_flag']))

            {

                update_option('feedback_autopopup_flag',$_POST['feedback_autopopup_flag']);

            }

			//if(isset($_POST['feedback_autopopup_mob_flag']))

            {

                update_option('feedback_autopopup_mob_flag',$_POST['feedback_autopopup_mob_flag']);

            }

			if(isset($_POST['feedback_popup_duration']))

            {

                update_option('feedback_popup_duration',$_POST['feedback_popup_duration']);

            }

			if(isset($_POST['feedback_popup_visit']))

            {

                update_option('feedback_popup_visit',$_POST['feedback_popup_visit']);

            }

			

			

			

			//if(isset($_POST['feedback_first_name_flag']))

            {

                update_option('feedback_first_name_flag',$_POST['feedback_first_name_flag']);

            }

			//if(isset($_POST['feedback_last_name_flag']))

            {

                update_option('feedback_last_name_flag',$_POST['feedback_last_name_flag']);

            }

			//if(isset($_POST['feedback_phone_flag']))

            {

                update_option('feedback_phone_flag',$_POST['feedback_phone_flag']);

            }

			//if(isset($_POST['feedback_Email_option_flag']))

            {

                update_option('feedback_Email_option_flag',$_POST['feedback_Email_option_flag']);

            }

			if( isset($_POST['feedback_upload_image_id'] ))

            {

                update_option('feedback_upload_image_id',$_POST['feedback_upload_image_id']);

            }

			

			

		

			

		}

		// for getting data

        include( 'library/options_feedback.php' );

		include( 'library/feedback_options.php' );

		

	}	

	



	// display admin section

    public function plugin_options() 

    {

		

        if ( !current_user_can( 'manage_options' ) )  

        {

            wp_die( __( 'You do not have sufficient permissions to access this page.' ) );

        }

        if( isset( $_POST['submit_schema'] ) )

        {



            if(isset($_POST['bus_name']))

            {

                $bus_name = $_POST['bus_name'];

                update_option('schema_bus_name',$bus_name);

            }

			

			if(isset($_POST['web_name']))

            {

                $web_name = $_POST['web_name'];

                update_option('schema_web_name',$web_name);

            }

			

			//if(isset($_POST['exclude_yoast_schema_markup']))

            {

                $exclude_yoast_schema_markup = $_POST['exclude_yoast_schema_markup'];

                update_option('schema_exclude_yoast_schema_markup',$exclude_yoast_schema_markup);

            }

			

			if(isset($_POST['alternate_name']))

            {

                $alternate_name = $_POST['alternate_name'];

                update_option('schema_alternate_name',$alternate_name);

            }

			

			//if(isset($_POST['feedback_button_flag']))

            {

                $feedback_button_flag = $_POST['feedback_button_flag'];

                update_option('schema_feedback_button_flag',$feedback_button_flag);

            }

			

			if(isset($_POST['price_range']))

            {

                $price_range = $_POST['price_range'];

                update_option('schema_price_range',$price_range);

            }

			

            if(isset($_POST['web_addr']))

            {

                $web_addr = $_POST['web_addr'];

                update_option('schema_web_addr',$web_addr);

            }



            if(isset($_POST['city']))

            {

                update_option('schema_locality',$_POST['city']);

            }



            if(isset($_POST['state']))

            {

                update_option('schema_area_level',$_POST['state']);

            }



            if(isset($_POST['zip']))

            {

                update_option('schema_postal',$_POST['zip']);

            }



            if(isset($_POST['country']))

            {

                update_option('schema_country',$_POST['country']);

            }



            if(isset($_POST['addr']))

            {

                $addr = $_POST['addr'];

                update_option('schema_addr',$addr);

				update_option('schema_str_address',$addr);

                $addr = $_POST['addr'].' '.$_POST['zip'].','.$_POST['city'].','.$_POST['state'].','.$_POST['country'];

                $prepAddr = str_replace(' ','+',$addr);

                $geocode = $this->getUrlContent('https://maps.google.com/maps/api/geocode/json?address='.$prepAddr.'&sensor=false');

                $output = json_decode($geocode);

                $latitude = $output->results[0]->geometry->location->lat; //Latitude

                $longitude = $output->results[0]->geometry->location->lng; //Longitude

                update_option('schema_lat',$latitude);

                update_option('schema_long',$longitude);

            }



            if(isset($_POST['phone']))

            {

                $phone = $_POST['phone'];

                update_option('schema_phone',$phone);

            }

            

            if( isset($_POST['upload_image_id'] ))

            {

                update_option('schema_image_id',$_POST['upload_image_id']);

            }



            if( isset($_POST['facebook'] ))

            {

                update_option('schema_facebook',$_POST['facebook']);

            }



            if( isset($_POST['google'] ))

            {

                update_option('schema_google',$_POST['google']);

            }



            if( isset($_POST['youtube'] ))

            {

                update_option('schema_youtube',$_POST['youtube']);

            }



            if( isset($_POST['linkedin'] ))

            {

                update_option('schema_linkedin',$_POST['linkedin']);

            }

			

			//if( isset($_POST['sociallinks'] ))

            {

                update_option('sociallinks',$_POST['sociallinks']);

            }



            if( isset($_POST['votreaviscompte'] ))

            {

                update_option('schema_votreaviscompte',$_POST['votreaviscompte']);

            }



            if( isset($_POST['email'] ))

            {

                update_option('schema_email',$_POST['email']);

            }



            if( isset($_POST['phprating'] ))

            {

                update_option('schema_phprating',$_POST['phprating']);

            }



            if( isset($_POST['monday_op_hours'] ))

            {

                update_option('monday_op_hours',$_POST['monday_op_hours']);

            }



            if( isset($_POST['monday_cl_hours'] ))

            {

                update_option('monday_cl_hours',$_POST['monday_cl_hours']);

            }



            if( isset($_POST['tuesday_op_hours'] ))

            {

                update_option('tuesday_op_hours',$_POST['tuesday_op_hours']);

            }



            if( isset($_POST['tuesday_cl_hours'] ))

            {

                update_option('tuesday_cl_hours',$_POST['tuesday_cl_hours']);

            }



            if( isset($_POST['wednessday_op_hours'] ))

            {

                update_option('wednessday_op_hours',$_POST['wednessday_op_hours']);

            }



            if( isset($_POST['wednessday_cl_hours'] ))

            {

                update_option('wednessday_cl_hours',$_POST['wednessday_cl_hours']);

            }



            if( isset($_POST['thursday_op_hours'] ))

            {

                update_option('thursday_op_hours',$_POST['thursday_op_hours']);

            }



            if( isset($_POST['thursday_cl_hours'] ))

            {

                update_option('thursday_cl_hours',$_POST['thursday_cl_hours']);

            }



            if( isset($_POST['friday_op_hours'] ))

            {

                update_option('friday_op_hours',$_POST['friday_op_hours']);

            }



            if( isset($_POST['friday_cl_hours'] ))

            {

                update_option('friday_cl_hours',$_POST['friday_cl_hours']);

            }



            if( isset($_POST['saturday_op_hours'] ))

            {

                update_option('saturday_op_hours',$_POST['saturday_op_hours']);

            }



            if( isset($_POST['saturday_cl_hours'] ))

            {

                update_option('saturday_cl_hours',$_POST['saturday_cl_hours']);

            }



            if( isset($_POST['sunday_op_hours'] ))

            {

                update_option('sunday_op_hours',$_POST['sunday_op_hours']);

            }



			if( isset($_POST['sunday_cl_action'] ))

            {

                update_option('sunday_cl_action',$_POST['sunday_cl_action']);

            }

			

			 if( isset($_POST['monday_cl_action'] ))

            {

                update_option('monday_cl_action',$_POST['monday_cl_action']);

            }

			

			 if( isset($_POST['tuesday_cl_action'] ))

            {

                update_option('tuesday_cl_action',$_POST['tuesday_cl_action']);

            }

			

			 if( isset($_POST['wednessday_cl_action'] ))

            {

                update_option('wednessday_cl_action',$_POST['wednessday_cl_action']);

            }

			

			 if( isset($_POST['thursday_cl_action'] ))

            {

                update_option('thursday_cl_action',$_POST['thursday_cl_action']);

            }

			

			 if( isset($_POST['friday_cl_action'] ))

            {

                update_option('friday_cl_action',$_POST['friday_cl_action']);

            }

			

			 if( isset($_POST['saturday_cl_action'] ))

            {

                update_option('saturday_cl_action',$_POST['saturday_cl_action']);

            }

			

            if( isset($_POST['type'] ))

            {

                update_option('schema_type',$_POST['type']);

            }



            if( isset($_POST['reviews'] ))

            {

                update_option('schema_reviews',$_POST['reviews']);

            }

        }

		// for getting data

        include( 'library/options.php' );

		include('library/plugin_options.php');

	}

	// display front-end section

    public static function header_script()

    {

		// for getting data

        include( 'library/options.php' );

		if(!empty($feedback_button_flag)){

			include('library/header_script.php');

        }

    }

	//display admin section preview

	public static function header_script_admin()

    {

		// for getting data

        include( 'library/options.php' );

		include('library/header_script_admin.php');

    }

	public function load_admin_libs() {

    wp_enqueue_media();

    wp_enqueue_script( 'wp-media-uploader', get_site_url(null, 'wp-content/plugins/' . basename(dirname(__FILE__))) . '/js/wp_media_uploader.js', array( 'jquery' ), 1.0 );

	}

	

	public function load_feadback_form() {

	// for getting data

			ob_start();

			include( 'library/options_feedback.php' );

			include( 'library/load_feadback_form.php' );

			$output = ob_get_clean();

			return $output;

	}

	public function check_schema_coockie() {

		if(isset($_COOKIE['SchemaCookie'])&&!empty($_COOKIE['SchemaCookie'])){

			$values=$_COOKIE['SchemaCookie']+1;

		}else{

		$values=1;

		}

		 setcookie("SchemaCookie", $values, strtotime( '+1 year' ),'/');

	}

	public function load_popup_feadback_form() {

	// for getting data

			

			if (get_option('feedback_autopopup_mob_flag')=='1' && wp_is_mobile() ) {

				include( 'library/options_feedback.php' );

				include( 'library/load_popup_mob_feadback_form.php' );

			}else{

				include( 'library/options_feedback.php' );

				include( 'library/load_popup_feadback_form.php' );

			}

	}

	public function load_popup_mob_feadback_form() {

	// for getting data

			if ( wp_is_mobile() ) {

				include( 'library/options_feedback.php' );

				include( 'library/load_popup_mob_feadback_form.php' );

			}

	}

	public function activate_au()

	{

		require_once ( 'library/wp_autoupdate.php' );

		$plugin_current_version = '1.5';

		$plugin_remote_path = 'http://165.227.86.239/update.php';

		$plugin_slug = plugin_basename( __FILE__ );

		$license_user = 'user';

		$license_key = 'abcd';

		new WP_AutoUpdate ( $plugin_current_version, $plugin_remote_path, $plugin_slug, $license_user, $license_key);

		

		

	}

	

	function create_plugin_database_table()

	{

		global $table_prefix, $wpdb;



		$tblname = 'feedback_review_log';

		$wp_track_table = $table_prefix . "$tblname";



		#Check to see if the table exists already, if not, then create it



		if($wpdb->get_var( "show tables like '$wp_track_table'" ) != $wp_track_table) 

		{

			$sql = "CREATE TABLE `". $wp_track_table . "` ( ";

			$sql .= "  `id`  int(11)  NOT NULL AUTO_INCREMENT, ";

			$sql .= "  `review`  varchar(200)   NOT NULL, ";

			$sql .= "  `date`  TIMESTAMP  NOT NULL DEFAULT CURRENT_TIMESTAMP, ";

			$sql .= "  `ip_address`  varchar(200)   NOT NULL, ";

			$sql .= "  `first_name`  varchar(200) , ";

			$sql .= "  `last_name`  varchar(200) , ";

			$sql .= "  `city`  varchar(200) , ";

			$sql .= "  `comment`  TEXT, "; 

			$sql .= "  `status` ENUM('0', '1')  NOT NULL DEFAULT '0', "; 

			$sql .= "  `phone`  varchar(200) , ";

			$sql .= "  `email`  varchar(200) , ";			

			$sql .= "  PRIMARY KEY `id` (`id`) "; 

			$sql .= ") ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ; "; 

			

			require_once( ABSPATH . '/wp-admin/includes/upgrade.php' );

			dbDelta($sql);

		}

		

		

		

	}



	function save_comment()

	{

		global $wpdb,$table_prefix; // this is how you get access to the database

		$tblname = 'feedback_review_log';

		$wp_track_table = $table_prefix . "$tblname";

		$str = $_POST['comment'];

		if(!empty($str)){

		parse_str($str, $data);

		

		$feedback_notification_email = get_option('feedback_notification_email');

		$feedback_notification_emails = get_option('feedback_notification_emails');

		$feedback_email_subject_comment = get_option('feedback_email_subject_comment');

		$feedback_email_message_comment = get_option('feedback_email_message_comment');

		if(count($feedback_notification_emails)>0 && is_array($feedback_notification_emails))

		{

			if(!empty($feedback_notification_email))

			{

				$feedback_notification_email.=",";

			}

			foreach($feedback_notification_emails as $mail)

			{

				$feedback_notification_email.=$mail.",";

			}

			$feedback_notification_email=substr($feedback_notification_email,0,-1);

		}

		if(!empty($feedback_notification_email))

		{

			$ip = $_SERVER['REMOTE_ADDR']; // your ip address here

			$query = @unserialize($this->getUrlContent('http://ip-api.com/php/'.$ip));

			$city = "";

			$city_name = "";

			if($query && $query['status'] == 'success')

			{

				$city = "which is located in ".$query['city']." city";

				$city_name = $query['city'];	

			}

			if(!empty($feedback_email_subject_comment)){

				$subject=$feedback_email_subject_comment;

			}else{

				$subject="Negative Feedback Received";

			}

			if(!empty($feedback_email_message_comment)){

				$feedback_email_message_comment=str_replace("[ip_address]",$ip,$feedback_email_message_comment);

				$feedback_email_message_comment=str_replace("[city]",$city_name,$feedback_email_message_comment);

				$feedback_email_message_comment=str_replace("[first_name]",$data['fname'],$feedback_email_message_comment);

				$feedback_email_message_comment=str_replace("[last_name]",$data['lname'],$feedback_email_message_comment);

				$feedback_email_message_comment=str_replace("[comment]",$data['comment'],$feedback_email_message_comment);

				$feedback_email_message_comment=str_replace("[phone]",$data['phone'],$feedback_email_message_comment);

				$feedback_email_message_comment=str_replace("[email]",$data['email'],$feedback_email_message_comment);

				$message=$feedback_email_message_comment;

			}else{

					

			 $message="Hi,

					

			Someone was left negative feedback for you on your website from IP address ".$_SERVER['REMOTE_ADDR']." $city. They have submitted 

			the follow comments about their experience.";



			if(!empty ($data['fname'])){		

			$message .="<br/> First Name: ".$data['fname']."<br/>";

			}



			if(!empty ($data['lname'])){	



			$message .="Last Name: ".$data['lname']."<br/>";

			}

			if(!empty ($data['comment'])){	



			$message .="Comment: ".$data['comment']."<br/>";





			}if(!empty ($data['phone'])){	



			$message .="Phone: ".$data['phone']."<br/>";



			}if(!empty ($data['email'])){	



			$message .="Email: ".$data['email']."<br/>";

			}	

				

			$message .="Thanks";







		}

		$headers[] = "From: Admin <".get_bloginfo('admin_email').">";

		$headers[] = "Content-type: text/html; charset=UTF-8" ;

		wp_mail($feedback_notification_email,$subject,nl2br($message),$headers,array());

		}

		 $wpdb->insert( $wp_track_table, array(

					 'review' => 'no',

					 'ip_address' => $_SERVER['REMOTE_ADDR'],

					 'first_name' => $data['fname'], 

					 'last_name' => $data['lname'],

					 'comment' => $data['comment'],

					 'city' => $city_name,

					 'phone' => $data['phone'],

					 'email' => $data['email']

					 

				),

				array( '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s' ) 

			);

		echo json_encode(array('status'=>'1'));

		die;

		}

		echo json_encode(array('status'=>'0'));

		die;

		

		wp_die(); // this is required to terminate immediately and return a proper response

	}

	function save_data() {

		global $wpdb,$table_prefix; // this is how you get access to the database

		$tblname = 'feedback_review_log';

		$wp_track_table = $table_prefix . "$tblname";

		$str = $_POST['comment'];

		if(!empty($str)){

		$feedback_notification_email = get_option('feedback_notification_email');

		$feedback_notification_emails = get_option('feedback_notification_emails');

		if(count($feedback_notification_emails)>0 && is_array($feedback_notification_emails)){

			if(!empty($feedback_notification_email)){

				$feedback_notification_email.=",";

			}

			foreach($feedback_notification_emails as $mail){

				$feedback_notification_email.=$mail.",";

			}

			$feedback_notification_email=substr($feedback_notification_email,0,-1);

		}

		if(!empty($feedback_notification_email)){

		$fdback="";

		if($str=="yes"){

		$fdback="positive";

		$feedback_email_subject = get_option('feedback_email_subject_yes');

		$feedback_email_message = get_option('feedback_email_message_yes');

		}

		if($str=="no"){

		$fdback="negative";

		$feedback_email_subject = get_option('feedback_email_subject_no');

		$feedback_email_message = get_option('feedback_email_message_no');

		}

		 $ip = $_SERVER['REMOTE_ADDR']; // your ip address here

		$query = @unserialize($this->getUrlContent('http://ip-api.com/php/'.$ip));

		$city = "";

		$city_name = "";

		if($query && $query['status'] == 'success')

		{

			$city = "which is located in ".$query['city']." city";

			$city_name = $query['city'];

		}

		if(!empty($feedback_email_subject)){

			$subject=$feedback_email_subject;

		}else{

			$subject=ucwords($fdback)." Feedback Received";

		}

		if(!empty($feedback_email_message)){

			$feedback_email_message=str_replace("[ip_address]",$ip,$feedback_email_message);

			$feedback_email_message=str_replace("[city]",$city_name,$feedback_email_message);

			$message=$feedback_email_message;

		}else{

		$message="

Hi,

		

Someone has left $fdback feedback on your website from IP address ".$_SERVER['REMOTE_ADDR']." $city.

		

Thanks";

		}

		$headers[] = "From: Admin <".get_bloginfo('admin_email').">";

		$headers[] = "Content-type: text/html; charset=UTF-8" ;

		wp_mail($feedback_notification_email,$subject,nl2br($message),$headers,array());

		}



		 $wpdb->insert( $wp_track_table, array(

					 'review' => $str,

					 'ip_address' => $_SERVER['REMOTE_ADDR'],

					 'first_name' => '', 

					 'last_name' => '',

					 'comment' => '',

					 'city' => $city_name,

					  'phone' => '',

					 'email' => ''

				),

				array( '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s' ) 

			);

		echo json_encode(array('status'=>'1'));

		die;

		}

		echo json_encode(array('status'=>'0'));

		die;

		

		wp_die(); // this is required to terminate immediately and return a proper response

	}

	

	// class instance

	static $instance;



	// activity_log WP_List_Table object

	public $activity_logs_obj;



	public static function set_screen( $status, $option, $value ) {

		return $value;

	}



	/**

	 * Plugin settings page

	 */

	public function plugin_settings_page() {

		?>

		<style>

		#poststuff #post-body.columns-2{

		 margin-right: 0px;

		 }

		</style>

		<div class="wrap">

			<h2>Feedback Logs</h2>



			<div id="poststuff">

				<div id="post-body" class="metabox-holder columns-2">

					<div id="post-body-content">

						<div class="meta-box-sortables ui-sortable">

						<?php

								$this->activity_logs_obj->views();

						?>

						

							<form method="post">

								<?php

								$this->activity_logs_obj->prepare_items();

								$this->activity_logs_obj->display(); ?>

							</form>

						</div>

					</div>

				</div>

				<br class="clear">

			</div>

		</div>

	<?php

	}



	/**

	 * Screen options

	 */

	public function screen_option() {



		$option = 'per_page';

		$args   = [

			'label'   => 'Feedback Log',

			'default' => 10,

			'option'  => 'activity_logs_per_page'

		];



		add_screen_option( $option, $args );



		$this->activity_logs_obj = new Activity_log_List();

	}





	/** Singleton instance */

	public static function get_instance() {

		if ( ! isset( self::$instance ) ) {

			self::$instance = new self();

		}



		return self::$instance;

	}

}

$woi = new ISAAC_WOI();

// upload image



if ( ! class_exists( 'WP_List_Table' ) ) {

	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );

}



class Activity_log_List extends WP_List_Table {



	/** Class constructor */

	public function __construct() {



		parent::__construct( [

			'singular' => __( 'Feedback log', 'sp' ), //singular name of the listed records

			'plural'   => __( 'Feedback logs', 'sp' ), //plural name of the listed records

			'ajax'     => false //does this table support ajax?

		] );



	}



	

	protected function get_views() { 

		  $views = array();

		   $current = ( !empty($_REQUEST['customvar']) ? $_REQUEST['customvar'] : 'all');



		   //All link

		   $class = ($current == 'all' ? ' class="current"' :'');

		   $all_url = remove_query_arg('customvar');

		   $views['all'] = "<a href='{$all_url }' {$class} >All</a>";



		   //Trash link

		   $trash_url = add_query_arg('customvar','trash');

		   $class = ($current == 'trash' ? ' class="current"' :'');

		   $views['trash'] = "<a href='{$trash_url}' {$class} >Trash</a>";



		   return $views;

	}



	/**

	 * Retrieve activity_logs data from the database

	 *

	 * @param int $per_page

	 * @param int $page_number

	 *

	 * @return mixed

	 */

	public static function get_activity_logs( $per_page = 10, $page_number = 1 ) {



		global $wpdb;

		$tblname = 'feedback_review_log';

		$wp_track_table = $wpdb->prefix . "$tblname";

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			$trash ='1';

		}else{

			$trash ='0';

		}

		$sql = "SELECT * FROM $wp_track_table where status='$trash' ";



		if ( ! empty( $_REQUEST['orderby'] ) ) {

			$sql .= ' ORDER BY ' . esc_sql( $_REQUEST['orderby'] );

			$sql .= ! empty( $_REQUEST['order'] ) ? ' ' . esc_sql( $_REQUEST['order'] ) : ' ASC';

		}else{

			$sql .= ' ORDER BY date Desc';

		}



		$sql .= " LIMIT $per_page";

		$sql .= ' OFFSET ' . ( $page_number - 1 ) * $per_page;





		$result = $wpdb->get_results( $sql, 'ARRAY_A' );

		//$sql1 = "SELECT * FROM $wp_track_table ";

		//$result1 = $wpdb->get_results( $sql1, 'ARRAY_A' );

		//print_r($result1);

		return $result;

	}





	/**

	 * Delete a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function delete_activity_log( $id ) {

		global $wpdb;

		$tblname = 'feedback_review_log';

		$wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		if($data){

			$wpdb->delete(

				"$wp_track_table",

				[ 'id' => $id ],

				[ '%d' ]

			);

		}

	}

	

	/**

	 * Trash a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function trash_activity_log( $id ) {

		global $wpdb;

		$tblname = 'feedback_review_log';

		$wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		if($data){

			$wpdb->update(

				"$wp_track_table",

				[ 'status' => '1' ],

				[ 'id' => $id ]

			);

		}

	}

	

	/**

	 * Restore a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function restore_activity_log( $id ) {

		global $wpdb;

		$tblname = 'feedback_review_log';

		$wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		if($data){

			$wpdb->update(

				"$wp_track_table",

				[ 'status' => '0' ],

				[ 'id' => $id ]

			);

		}

	}

	

	/**

	 * Delete a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function view_activity_log( $id ) {

		global $wpdb;

		$tblname = 'feedback_review_log';

		 $wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		 

		

		

		 

		

		if($data){

		?>

		<h1>Detail View</h1>

		<table  class="form-table">

			<tbody>

				<tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="review">Review</label>

                            </th>

                            <td class="forminp">

								<?php echo ucwords($data[0]->review);?>

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="ip_address">IP Address</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->ip_address;?>

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="first_name">First Name</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->first_name;?>

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="last_name">Last Name</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->last_name;?>

							</td>

                 </tr>

				 

				    <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="phone">Phone</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->phone;?>

							</td>

                 </tr>

				 

				  <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="Email">Email</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->email;?>

							</td>

                 </tr>

				

				 

				 

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="comment">Comment</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->comment;?>

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="city">City</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->city;?>

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="date">Date</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->date;?>

							</td>

                 </tr>

					</tbody>

  		</table>

		<?php

		}else{

			echo "No Records Found";

		}

		die;

	}

	

	/**

	 * Returns the count of records in the database.

	 *

	 * @return null|string

	 */

	public static function record_count() {

		global $wpdb;

		$tblname = 'feedback_review_log';

		$wp_track_table = $wpdb->prefix . "$tblname";

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			$trash ='1';

		}else{

			$trash ='0';

		}

		$sql = "SELECT COUNT(id) FROM $wp_track_table where status='$trash'";



		return $wpdb->get_var( $sql );

	}





	/** Text displayed when no activity_log data is available */

	public function no_items() {

		_e( 'No Feedback Logs Available.', 'sp' );

	}





	/**

	 * Render a column when no column specific method exist.

	 *

	 * @param array $item

	 * @param string $column_name

	 *

	 * @return mixed

	 */

	public function column_default( $item, $column_name ) {

		switch ( $column_name ) {

			case 'id':

			case 'first_name':

			case 'last_name':

			case 'date':

			case 'ip_address':

			case 'city':

				return $item[ $column_name ];

			case 'review':

				return ucwords($item[ $column_name ]);	

			case 'comment':

				if($item[ $column_name ]){

					$detail_comment=substr($item[ $column_name ],0,20);

					$detail_comment.=((strlen($item[ $column_name ])>20)?"...":'');

					return $detail_comment;

				}else{

					return '';

				}	

			default:

				return print_r( $item, true ); //Show the whole array for troubleshooting purposes

		}

	}



	/**

	 * Render the bulk edit checkbox

	 *

	 * @param array $item

	 *

	 * @return string

	 */

	function column_cb( $item ) {

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			return sprintf(

			'<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['id']

			);

		}else{

			return sprintf(

				'<input type="checkbox" name="bulk-trash[]" value="%s" />', $item['id']

			);

		}

	}





	/**

	 * Method for name column

	 *

	 * @param array $item an array of DB data

	 *

	 * @return string

	 */

	function column_ip_address( $item ) {

	

		$title = '<strong>' . $item['ip_address'] . '</strong>';

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			$delete_nonce = wp_create_nonce( 'sp_delete_activity_log' );

			$actions = [

			'restore'      => sprintf('<a href="?page=%s&action=%s&activity_log=%s">Restore</a>',esc_attr($_REQUEST['page']),'restore',absint($item['id'])),

			'delete' => sprintf( '<a href="?page=%s&action=%s&activity_log=%s&_wpnonce=%s">Delete Permamently</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce )

		];

		}else{

			$trash_nonce = wp_create_nonce( 'sp_trash_activity_log' );

			$actions = [

			'view'      => sprintf('<a href="?page=%s&action=%s&activity_log=%s">View</a>',esc_attr($_REQUEST['page']),'view',absint($item['id'])),

			'trash' => sprintf( '<a href="?page=%s&action=%s&activity_log=%s&_wpnonce=%s">Trash</a>', esc_attr( $_REQUEST['page'] ), 'trash', absint( $item['id'] ), $trash_nonce )

		];

		}

		



		return $title . $this->row_actions( $actions );

	}





	/**

	 *  Associative array of columns

	 *

	 * @return array

	 */

	function get_columns() {

		$columns = [

			'cb'      => '<input type="checkbox" />',

			//'id'    => __( 'ID', 'sp' ),

			'ip_address' => __( 'IP Address', 'sp' ),

			'city'    => __( 'City', 'sp' ),

			'review'    => __( 'Review', 'sp' ),

			'first_name' => __( 'First Name', 'sp' ),

			'last_name' => __( 'Last Name', 'sp' ),

			'comment'    => __( 'Comment', 'sp' ),

			'date' => __( 'Date', 'sp' ),

		];

		return $columns;

	}





	/**

	 * Columns to make sortable.

	 *

	 * @return array

	 */

	public function get_sortable_columns() {

		$sortable_columns = array(

			'id' => array( 'id', true ),

			'city' => array( 'city', false ),

			'date' => array( 'date', false ),

			'review' => array( 'review', false )

		);



		return $sortable_columns;

	}



	/**

	 * Returns an associative array containing the bulk action

	 *

	 * @return array

	 */

	public function get_bulk_actions() {

	if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

		$actions = [

			'bulk-delete' => 'Move to Delete'

		];

	}else{

		$actions = [

			'bulk-trash' => 'Move to Trash'

		];

	}

		return $actions;

	}





	/**

	 * Handles data query and filter, sorting, and pagination.

	 */

	public function prepare_items() {



		$this->_column_headers = $this->get_column_info();



		/** Process bulk action */

		$this->process_bulk_action();



		$per_page     = $this->get_items_per_page( 'activity_logs_per_page', 10 );

		$current_page = $this->get_pagenum();

		$total_items  = self::record_count();



		$this->set_pagination_args( [

			'total_items' => $total_items, //WE have to calculate the total number of items

			'per_page'    => $per_page //WE have to determine how many items to show on a page

		] );



		$this->items = self::get_activity_logs( $per_page, $current_page );

	}



	public function process_bulk_action() {

		

		if ( 'view' === $this->current_action() ) {

			if ( isset($_GET['activity_log']) && !empty($_GET['activity_log']) && $_GET['action']=='view' ) {

				self::view_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

		               // wp_redirect( esc_url_raw(add_query_arg()) );

				exit;

			}

		}	

		//Detect when a bulk action is being triggered...

		if ( 'trash' === $this->current_action() ) {



			// In our file that handles the request, verify the nonce.

			$nonce = esc_attr( $_REQUEST['_wpnonce'] );

			

			if ( ! wp_verify_nonce( $nonce, 'sp_trash_activity_log' ) ) {

				die( 'Go get a life script kiddies' );

			}

			else {

				self::trash_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

				exit;

			}



		}

		//Detect when a bulk action is being triggered...

		if ( 'restore' === $this->current_action() ) {



			

				self::restore_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

				exit;

			



		}

		

		// If the trash bulk action is triggered

		if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-trash' )

		     || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-trash' )

		) {



			$trash_ids = esc_sql( $_POST['bulk-trash'] );



			// loop over the array of record IDs and trash them

			foreach ( $trash_ids as $id ) {

				self::trash_activity_log( $id );



			}



			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		        // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

			exit;

		}

		

		//Detect when a bulk action is being triggered...

		if ( 'delete' === $this->current_action() ) {



			// In our file that handles the request, verify the nonce.

			$nonce = esc_attr( $_REQUEST['_wpnonce'] );

			

			if ( ! wp_verify_nonce( $nonce, 'sp_delete_activity_log' ) ) {

				die( 'Go get a life script kiddies' );

			}

			else {

				self::delete_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

				exit;

			}



		}

		// If the delete bulk action is triggered

		if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' )

		     || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' )

		) {



			$delete_ids = esc_sql( $_POST['bulk-delete'] );



			// loop over the array of record IDs and delete them

			foreach ( $delete_ids as $id ) {

				self::delete_activity_log( $id );



			}



			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		        // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

			exit;

		}

		

	}



}

