<?php
	//print_r($wpct);
	if(isset($_GET['Period'])){
		switch($_GET['Period']){
			case "today":
				$start_time = date('Y-m-d');
				$title_period = "Today";
				break;
			case "yesterday":
				$start_time = date('Y-m-d', strtotime('yesterday'));
				$title_period = "Yesterday";
				break;
			case "current_month":
				$start_time = date('Y-m-01');
				$title_period = "Current Month";
				break;
			case "last_month":
				$start_time = date('Y-m-01', strtotime('last month'));
				$title_period = "Last Month";
				break;
		}
		
	} elseif(isset($_GET['startDate'])){
		$start_time = date('Y-m-d', strtotime($_GET['startDate']));
		$title_period = $_GET['startDate'] . " - " . $_GET['endDate'];
	} else {
		$start_time = date('Y-m-01');
		$title_period = "Current Month";
	}
	
		
	for($i = 0; $i < count($wpct['wpct']["twilio_number"]); $i++){
		$friendly_name = wpct::get_friendly_name($wpct['wpct']['twilio_sid'][$i], $wpct['wpct']['twilio_token'][$i], $wpct['wpct']['twilio_number'][$i]);
		
		$url = sprintf('https://%s:%s@api.twilio.com/2010-04-01/Accounts/%s/Calls?Status=completed&pagesize=1000&To=%s', $wpct['wpct']['twilio_sid'][$i], $wpct['wpct']['twilio_token'][$i], $wpct['wpct']['twilio_sid'][$i], $wpct['wpct']['twilio_number'][$i]);
		if($start_time)
			$url .= "&StartTime>=".$start_time;
		//echo $url."<br />";
		$data = wpct::curl_operation($url);
		$calls = json_decode(json_encode((array) simplexml_load_string($data)),1);
		//print_r($calls);
		
		$call_count = 0;
		$lead_count = 0;
		if($calls['Calls']['@attributes']['total'] > 1){
			foreach($calls['Calls']['Call'] as $call){
				if($_GET['endDate'] != ''){
					if(strtotime($call['StartTime']) < strtotime($_GET['endDate'])){
						$call_count++;
						if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
							$lead_count++;
					}
				} else {
					$call_count++;
					if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
						$lead_count++;
				}
			}
		} elseif($calls['Calls']['@attributes']['total'] == 1) {
			$call = $calls['Calls']['Call'];
			if($_GET['endDate'] != ''){
				if(strtotime($call['StartTime']) < strtotime($_GET['endDate'])){
					$call_count++;
					if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
						$lead_count++;
				}
			} else {
				$call_count++;
				if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
					$lead_count++;
			}
		}
		//TODO: get the friendly name
		$rows[] = sprintf('["%s", %d, %d]', $friendly_name, $call_count, $lead_count);
	}
		
	$js_columns = "['Number', 'Calls', 'Leads']";
	//$rows = array_reverse($rows);
	$js_rows = implode(",", $rows);
?>

<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script type="text/javascript">
	//google.load('visualization', '1.0', {'packages':['corechart']});
	google.load('visualization', '1', {packages: ['charteditor']}); 
	google.setOnLoadCallback(drawChart);
	var wrapper;
	var data = [ <?php echo $js_columns; ?>,
				 <?php echo $js_rows; ?>]
	var chartType = 'ColumnChart';
	
	function drawChart() {
		wrapper = new google.visualization.ChartWrapper({
          chartType: chartType,
          dataTable: data,
          options: {title: 'WpCallTracker Calls/Leads (<?php echo $title_period; ?>)',
		  			vAxis: {title: "Calls/Leads"},
            		hAxis: {title: "Phone Number"}},
          containerId: 'chart_div'
        });
        wrapper.draw();
		
		//google.visualization.events.addListener(wrapper, 'select', selectHandler);
	}
	
	function selectHandler(){
		//var selection = wrapper.getChart().getSelection();
		//wrapper.getDataTable().getValue(selection.row,0);
		//console.log(selection);
	}
	
	function openEditor() {
	  // Handler for the "Open Editor" button.
	  var editor = new google.visualization.ChartEditor();
	  google.visualization.events.addListener(editor, 'ok',
		function() {
		  wrapper = editor.getChartWrapper();
		  wrapper.draw(document.getElementById('chart_div'));
	  });
	  editor.openDialog(wrapper);
	}
	jQuery(function(){
		jQuery("select#Category").val('<?php echo $category ?>');
		jQuery("select#period").val('<?php echo $period ?>');
		jQuery(".datepicker").datepicker({
            showOtherMonths: true,
            selectOtherMonths: true,
			showButtonPanel: true
        });
		
		jQuery("#go").click(function(e){
			e.preventDefault();
			var url = "?page=wpct_options&startDate="+jQuery("#startDate").val()+"&endDate="+jQuery("#endDate").val();
			window.location = url;
		});
	});
</script>

    <?php
	$height = $options_page ? '500px' : '250px';
	?>
    <div style="text-align:right;">
    	<a href="?page=wpct_options&Period=today">Today</a> | 
        <a href="?page=wpct_options&Period=yesterday">Yesterday</a> | 
        <a href="?page=wpct_options&Period=current_month">This Month</a> | 
        <a href="?page=wpct_options&Period=last_month" style="margin-right:40px;">Last Month</a>
        
        Start <input type="text" name="startDate" id="startDate" class="datepicker" value="<?php echo $_GET['startDate']; ?>" />
        End <input type="text" name="endDate" id="endDate" class="datepicker" value="<?php echo $_GET['endDate']; ?>" />
        <button id="go">Go</button>
    </div>
    <div id="chart_div" style="height:<?php echo $height; ?>;"></div>
    <?php
		if(!$options_page)
			echo '<div style="text-align:right;"><a href="tools.php?page=tusage_options">More...</a></div>';
	?>
