<?php
/*
Plugin Name: WP InstaLegalPages
Plugin URI: http://instalegalpages.com/
Description: A helpful and time saver premium plugin to <strong>auto-add legal pages</strong> on your sites.
Version: 1.0.4
Author: Leo (BCBiz)
Author URI: http://wpthemeplugin.com/
*/

if( !class_exists('WPUpdatesPluginUpdater_246') ) {
    class WPUpdatesPluginUpdater_246 {
    
    	var $api_url;
    	var $plugin_id = 246;
    	var $plugin_path;
    	var $plugin_slug;
    	var $license_key;
    
    	function __construct( $api_url, $plugin_path, $license_key = null ) {
    		$this->api_url = $api_url;
    		$this->plugin_path = $plugin_path;
    		$this->license_key = $license_key;
    		if(strstr($plugin_path, '/')) list ($t1, $t2) = explode('/', $plugin_path); 
    		else $t2 = $plugin_path;
    		$this->plugin_slug = str_replace('.php', '', $t2);
    
    		add_filter( 'pre_set_site_transient_update_plugins', array(&$this, 'check_for_update') );
    		add_filter( 'plugins_api', array(&$this, 'plugin_api_call'), 10, 3 );
    		
    		// This is for testing only!
    		//set_site_transient( 'update_plugins', null );
    
    		// Show which variables are being requested when query plugin API
    		//add_filter( 'plugins_api_result', array(&$this, 'debug_result'), 10, 3 );
    	}
    
    	function check_for_update( $transient ) {
    		if(empty($transient->checked)) return $transient;
    		
    		$request_args = array(
    		    'id' => $this->plugin_id,
    		    'slug' => $this->plugin_slug,
    			'version' => $transient->checked[$this->plugin_path]
    		);
    		if ($this->license_key) $request_args['license'] = $this->license_key;
    		
    		$request_string = $this->prepare_request( 'update_check', $request_args );
    		$raw_response = wp_remote_post( $this->api_url, $request_string );
    		
    		$response = null;
    		if( !is_wp_error($raw_response) && ($raw_response['response']['code'] == 200) )
    			$response = unserialize($raw_response['body']);
    		
    		if( is_object($response) && !empty($response) ) // Feed the update data into WP updater
    			$transient->response[$this->plugin_path] = $response;
    
    		return $transient;
    	}
    
    	function plugin_api_call( $def, $action, $args ) {
    		if( !isset($args->slug) || $args->slug != $this->plugin_slug ) return $def;
    		
    		$plugin_info = get_site_transient('update_plugins');
    		$request_args = array(
    		    'id' => $this->plugin_id,
    		    'slug' => $this->plugin_slug,
    			'version' => (isset($plugin_info->checked)) ? $plugin_info->checked[$this->plugin_path] : 0 // Current version
    		);
    		
    		$request_string = $this->prepare_request( $action, $request_args );
    		$raw_response = wp_remote_post( $this->api_url, $request_string );
    		
    		if( is_wp_error($raw_response) ){
    			$res = new WP_Error('plugins_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>'), $raw_response->get_error_message());
    		} else {
    			$res = unserialize($raw_response['body']);
    			if ($res === false)
    				$res = new WP_Error('plugins_api_failed', __('An unknown error occurred'), $raw_response['body']);
    		}
    		
    		return $res;
    	}
    
    	function prepare_request( $action, $args ) {
    		global $wp_version;
    		
    		return array(
    			'body' => array(
    				'action' => $action, 
    				'request' => serialize($args),
    				'api-key' => md5(home_url())
    			),
    			'user-agent' => 'WordPress/'. $wp_version .'; '. home_url()
    		);	
    	}
    	
    	function debug_result( $res, $action, $args ) {
    		echo '<pre>'.print_r($res,true).'</pre>';
    		return $res;
    	}
    
    }
}
register_activation_hook( __FILE__, 'instalegalcreate_earningdisclaimer_page');
register_activation_hook( __FILE__, 'instalegalcreate_privacypolicy_page');
register_activation_hook( __FILE__, 'instalegalcreate_dmca_page');
register_activation_hook( __FILE__, 'instalegalcreate_amzassociate_page');
register_activation_hook( __FILE__, 'instalegalcreate_affdisclosure_page');
register_activation_hook( __FILE__, 'instalegalcreate_contact_page');
register_activation_hook( __FILE__, 'instalegalcreate_antispam_page');
register_activation_hook( __FILE__, 'instalegalcreate_medical_page');
register_activation_hook( __FILE__, 'instalegalcreate_tos_page');
new WPUpdatesPluginUpdater_246( 'http://wp-updates.com/api/2/plugin', plugin_basename(__FILE__));
class LeoBCBizInstaLegal {

    private $plugin_path;
    private $plugin_url;
    private $l10n;
    private $instalegalwpsf;

    function __construct()
    {	
        $this->plugin_path = plugin_dir_path( __FILE__ );
        $this->plugin_url = plugin_dir_url( __FILE__ );
        $this->l10n = 'wp-settings-framework';
        add_action( 'admin_menu', array(&$this, 'admin_menu'), 99 );

        // Include and create a new InstaLegalSettingsFramework
        require_once( $this->plugin_path .'wp-settings-framework.php' );
        $this->instalegalwpsf = new InstaLegalSettingsFramework( $this->plugin_path .'settings/settings-instalegalgeneral.php' );
        require_once( 'settings/css/stylecustom.php' );
        // Add an optional settings validation filter (recommended)
        add_filter( $this->instalegalwpsf->get_option_group() .'_settings_validate', array(&$this, 'validate_settings') );
    }
    
    function admin_menu()
    {
        $page_hook = add_menu_page( __( 'InstaLegalPages Plugin Setting', $this->l10n ), __( 'InstaLegalPages', $this->l10n ), 'update_core', 'instalegalpg', array(&$this, 'settings_page'), '', '20.7' );
    }
    
    function settings_page()
{
?>
<style>
.instalegal-wrap {font-size: 13px;line-height: 1.3em;padding-top: 15px;width: 750px;}
.instalegal-wrap h2 {font-size: 24px;border-bottom: 1px solid #CCC;margin-bottom: 10px;
padding-bottom: 14px;}
.instalegal-wrap h3 {font-size: 20px;font-weight: normal;margin: 25px 0 0;padding: 0;}
.instalegal-wrap p {margin: 10px 0;padding: 0;}
.instalegal-wrap input,.instalegal-wrap textarea {line-height: 1.3em;padding: 8px;border: 1px solid #C5C5C5;}
.instalegal-wrap select option {line-height: 1.3em;padding: 8px;}
</style>
<div class="instalegal-wrap">

<?php
$instalegalnews = wp_remote_get( 'http://1clickwpsetup.com/bcbiz-latestnews.html' );
if ( 200 == $instalegalnews['response']['code'] ) {
	$instalegalnewsbody = $instalegalnews['body'];
	echo $instalegalnewsbody;
}
?>

<div id="icon-options-general" class="icon32"></div>
<h2>InstaLegalPages Plugin Setting</h2>
<div style="font-family:Arial;font-size:11px;">
By Leo (BCBiz) from <a href="http://wpthemeplugin.com">WpThemePlugin.com</a>
</div>
<?php
$this->instalegalwpsf->settings();
?>
</div>
<?php
// Get settings
//$settings = wpsf_get_settings( $this->plugin_path .'settings/settings-instalegalgeneral.php' );
//echo '<pre>'.print_r($settings,true).'</pre>';
}
function validate_settings( $input )
{
     return $input;
}

}
new LeoBCBizInstaLegal();
function leobcbiz_instalegalamzdisclosure() {
        include(plugin_dir_path(__FILE__) .'/settings/leobcbiz/amzsttdisc-content.php');
}
$instalegalamzsttd_status = wpsf_get_setting( wpsf_get_option_group( plugin_dir_path( __FILE__ ) .'settings/settings-instalegalgeneral.php' ), 'instaamzgeneral', 'instaamzdsttstatus' );
if ($instalegalamzsttd_status == "1") {
add_action('wp_footer', 'leobcbiz_instalegalamzdisclosure');
}

function leobcbiz_instalegalautofooter() {
        include(plugin_dir_path(__FILE__) .'/settings/leobcbiz/amzautopages.php');
}
$instalegalautofooter_status = wpsf_get_setting( wpsf_get_option_group( plugin_dir_path( __FILE__ ) .'settings/settings-instalegalgeneral.php' ), 'instalegalpgeneral', 'autodisplaypage' );
if ($instalegalautofooter_status == "1") {
add_action('wp_footer', 'leobcbiz_instalegalautofooter');
}
?>