<?php

class Avada_Data {

	/**
	 * Returns an array of all the social icons included in the core fusion font.
	 */
	public static function fusion_social_icons( $custom = true, $colors = false ) {

		$networks = array(
			'facebook'   => array( 'label' => 'Facebook',   'color' => '#3b5998' ),
			'flickr'     => array( 'label' => 'Flickr',     'color' => '#0063dc' ),
			'rss'        => array( 'label' => 'RSS',        'color' => '#f26522' ),
			'twitter'    => array( 'label' => 'Twitter',    'color' => '#55acee' ),
			'vimeo'      => array( 'label' => 'Vimeo',      'color' => '#1ab7ea' ),
			'youtube'    => array( 'label' => 'Youtube',    'color' => '#cd201f' ),
			'instagram'  => array( 'label' => 'Instagram',  'color' => '#3f729b' ),
			'pinterest'  => array( 'label' => 'Pinterest',  'color' => '#bd081c' ),
			'tumblr'     => array( 'label' => 'Tumblr',     'color' => '#35465c' ),
			'gplus'      => array( 'label' => 'Google+',    'color' => '#dc4e41' ),
			'dribbble'   => array( 'label' => 'Dribbble',   'color' => '#ea4c89' ),
			'digg'       => array( 'label' => 'Digg',       'color' => '#000000' ),
			'linkedin'   => array( 'label' => 'LinkedIn',   'color' => '#0077b5' ),
			'blogger'    => array( 'label' => 'Blogger',    'color' => '#f57d00' ),
			'skype'      => array( 'label' => 'Skype',      'color' => '#00aff0' ),
			'forrst'     => array( 'label' => 'Forrst',     'color' => '#5b9a68' ),
			'myspace'    => array( 'label' => 'Myspace',    'color' => '#000000' ),
			'deviantart' => array( 'label' => 'Deviantart', 'color' => '#4dc47d' ),
			'yahoo'      => array( 'label' => 'Yahoo',      'color' => '#410093' ),
			'reddit'     => array( 'label' => 'Reddit',     'color' => '#ff4500' ),
			'paypal'     => array( 'label' => 'Paypal',     'color' => '#003087' ),
			'dropbox'    => array( 'label' => 'Dropbox',    'color' => '#007ee5' ),
			'soundcloud' => array( 'label' => 'Soundcloud', 'color' => '#ff8800' ),
			'vk'         => array( 'label' => 'VK',         'color' => '#45668e' ),
			'xing'       => array( 'label' => 'Xing',       'color' => '#026466' ),
			'email'      => array( 'label' => esc_html__( 'Email Address', 'Avada' ), 'color' => '#000000' ),
		);

		// Add a "custom" entry.
		if ( $custom ) {
			$networks['custom'] = array( 'label' => esc_attr__( 'Custom', 'Avada' ), 'color' => '' );
		}

		if ( ! $colors ) {
			$simple_networks = array();
			foreach ( $networks as $network_id => $network_args ) {
				$simple_networks[ $network_id ] = $network_args['label'];
			}
			$networks = $simple_networks;
		}

		return $networks;

	}

	/**
	 * Returns an array of old names for font-awesome icons
	 * and their new destinations on font-awesome.
	 */
	public static function old_icons() {

		$icons = array(
			'arrow'                  => 'angle-right',
			'asterik'                => 'asterisk',
			'cross'                  => 'times',
			'ban-circle'             => 'ban',
			'bar-chart'              => 'bar-chart-o',
			'beaker'                 => 'flask',
			'bell'                   => 'bell-o',
			'bell-alt'               => 'bell',
			'bitbucket-sign'         => 'bitbucket-square',
			'bookmark-empty'         => 'bookmark-o',
			'building'               => 'building-o',
			'calendar-empty'         => 'calendar-o',
			'check-empty'            => 'square-o',
			'check-minus'            => 'minus-square-o',
			'check-sign'             => 'check-square',
			'check'                  => 'check-square-o',
			'chevron-sign-down'      => 'chevron-circle-down',
			'chevron-sign-left'      => 'chevron-circle-left',
			'chevron-sign-right'     => 'chevron-circle-right',
			'chevron-sign-up'        => 'chevron-circle-up',
			'circle-arrow-down'      => 'arrow-circle-down',
			'circle-arrow-left'      => 'arrow-circle-left',
			'circle-arrow-right'     => 'arrow-circle-right',
			'circle-arrow-up'        => 'arrow-circle-up',
			'circle-blank'           => 'circle-o',
			'cny'                    => 'rub',
			'collapse-alt'           => 'minus-square-o',
			'collapse-top'           => 'caret-square-o-up',
			'collapse'               => 'caret-square-o-down',
			'comment-alt'            => 'comment-o',
			'comments-alt'           => 'comments-o',
			'copy'                   => 'files-o',
			'cut'                    => 'scissors',
			'dashboard'              => 'tachometer',
			'double-angle-down'      => 'angle-double-down',
			'double-angle-left'      => 'angle-double-left',
			'double-angle-right'     => 'angle-double-right',
			'double-angle-up'        => 'angle-double-up',
			'download'               => 'arrow-circle-o-down',
			'download-alt'           => 'download',
			'edit-sign'              => 'pencil-square',
			'edit'                   => 'pencil-square-o',
			'ellipsis-horizontal'    => 'ellipsis-h',
			'ellipsis-vertical'      => 'ellipsis-v',
			'envelope-alt'           => 'envelope-o',
			'exclamation-sign'       => 'exclamation-circle',
			'expand-alt'             => 'plus-square-o',
			'expand'                 => 'caret-square-o-right',
			'external-link-sign'     => 'external-link-square',
			'eye-close'              => 'eye-slash',
			'eye-open'               => 'eye',
			'facebook-sign'          => 'facebook-square',
			'facetime-video'         => 'video-camera',
			'file-alt'               => 'file-o',
			'file-text-alt'          => 'file-text-o',
			'flag-alt'               => 'flag-o',
			'folder-close-alt'       => 'folder-o',
			'folder-close'           => 'folder',
			'folder-open-alt'        => 'folder-open-o',
			'food'                   => 'cutlery',
			'frown'                  => 'frown-o',
			'fullscreen'             => 'arrows-alt',
			'github-sign'            => 'github-square',
			'google-plus-sign'       => 'google-plus-square',
			'group'                  => 'users',
			'h-sign'                 => 'h-square',
			'hand-down'              => 'hand-o-down',
			'hand-left'              => 'hand-o-left',
			'hand-right'             => 'hand-o-right',
			'hand-up'                => 'hand-o-up',
			'hdd'                    => 'hdd-o',
			'heart-empty'            => 'heart-o',
			'hospital'               => 'hospital-o',
			'indent-left'            => 'outdent',
			'indent-right'           => 'indent',
			'info-sign'              => 'info-circle',
			'keyboard'               => 'keyboard-o',
			'legal'                  => 'gavel',
			'lemon'                  => 'lemon-o',
			'lightbulb'              => 'lightbulb-o',
			'linkedin-sign'          => 'linkedin-square',
			'meh'                    => 'meh-o',
			'microphone-off'         => 'microphone-slash',
			'minus-sign-alt'         => 'minus-square',
			'minus-sign'             => 'minus-circle',
			'mobile-phone'           => 'mobile',
			'moon'                   => 'moon-o',
			'move'                   => 'arrows',
			'off'                    => 'power-off',
			'ok-circle'              => 'check-circle-o',
			'ok-sign'                => 'check-circle',
			'ok'                     => 'check',
			'paper-clip'             => 'paperclip',
			'paste'                  => 'clipboard',
			'phone-sign'             => 'phone-square',
			'picture'                => 'picture-o',
			'pinterest-sign'         => 'pinterest-square',
			'play-circle'            => 'play-circle-o',
			'play-sign'              => 'play-circle',
			'plus-sign-alt'          => 'plus-square',
			'plus-sign'              => 'plus-circle',
			'pushpin'                => 'thumb-tack',
			'question-sign'          => 'question-circle',
			'remove-circle'          => 'times-circle-o',
			'remove-sign'            => 'times-circle',
			'remove'                 => 'times',
			'reorder'                => 'bars',
			'resize-full'            => 'expand',
			'resize-horizontal'      => 'arrows-h',
			'resize-small'           => 'compress',
			'resize-vertical'        => 'arrows-v',
			'rss-sign'               => 'rss-square',
			'save'                   => 'floppy-o',
			'screenshot'             => 'crosshairs',
			'share-alt'              => 'share',
			'share-sign'             => 'share-square',
			'share'                  => 'share-square-o',
			'sign-blank'             => 'square',
			'signin'                 => 'sign-in',
			'signout'                => 'sign-out',
			'smile'                  => 'smile-o',
			'sort-by-alphabet-alt'   => 'sort-alpha-desc',
			'sort-by-alphabet'       => 'sort-alpha-asc',
			'sort-by-attributes-alt' => 'sort-amount-desc',
			'sort-by-attributes'     => 'sort-amount-asc',
			'sort-by-order-alt'      => 'sort-numeric-desc',
			'sort-by-order'          => 'sort-numeric-asc',
			'sort-down'              => 'sort-asc',
			'sort-up'                => 'sort-desc',
			'stackexchange'          => 'stack-overflow',
			'star-empty'             => 'star-o',
			'star-half-empty'        => 'star-half-o',
			'sun'                    => 'sun-o',
			'thumbs-down-alt'        => 'thumbs-o-down',
			'thumbs-up-alt'          => 'thumbs-o-up',
			'time'                   => 'clock-o',
			'trash'                  => 'trash-o',
			'tumblr-sign'            => 'tumblr-square',
			'twitter-sign'           => 'twitter-square',
			'unlink'                 => 'chain-broken',
			'upload'                 => 'arrow-circle-o-up',
			'upload-alt'             => 'upload',
			'warning-sign'           => 'exclamation-triangle',
			'xing-sign'              => 'xing-square',
			'youtube-sign'           => 'youtube-square',
			'zoom-in'                => 'search-plus',
			'zoom-out'               => 'search-minus',
		);

		return $icons;

	}

	/**
	 * all font-awesome icons
	 * the array is copied from https://github.com/Smartik89/SMK-Font-Awesome-PHP-JSON
	 *
	 * @return array
	 */
	public static function fa_icons() {
		$fa_array = array(
			'facebook-square' => 'Facebook square',
			'flickr' => 'Flickr',
			'rss-square' => 'Rss square',
			'twitter-square' => 'Twitter square',
			'vimeo-square' => 'Vimeo square',
			'youtube-square' => 'Youtube square',
			'instagram' => 'Instagram',
			'pinterest-square' => 'Pinterest square',
			'tumblr-square' => 'Tumblr square',
			'google-plus-square' => 'Google plus square',
			'dribbble' => 'Dribbble',
			'digg' => 'Digg',
			'linkedin-square' => 'Linkedin square',
			'skype' => 'Skype',
			'deviantart' => 'Deviantart',
			'yahoo' => 'Yahoo',
			'reddit-square' => 'Reddit square',
			'paypal' => 'Paypal',
			'dropbox' => 'Dropbox',
			'soundcloud' => 'Soundcloud',
			'vk' => 'Vk',
			'envelope-square' => 'Envelope square',
			'none' => '———————————————————————',


			'500px' => '500px',
			'adjust' => 'Adjust',
			'adn' => 'Adn',
			'align-center' => 'Align center',
			'align-justify' => 'Align justify',
			'align-left' => 'Align left',
			'align-right' => 'Align right',
			'amazon' => 'Amazon',
			'ambulance' => 'Ambulance',
			'anchor' => 'Anchor',
			'android' => 'Android',
			'angellist' => 'Angellist',
			'angle-double-down' => 'Angle double down',
			'angle-double-left' => 'Angle double left',
			'angle-double-right' => 'Angle double right',
			'angle-double-up' => 'Angle double up',
			'angle-down' => 'Angle down',
			'angle-left' => 'Angle left',
			'angle-right' => 'Angle right',
			'angle-up' => 'Angle up',
			'apple' => 'Apple',
			'archive' => 'Archive',
			'area-chart' => 'Area chart',
			'arrow-circle-down' => 'Arrow circle down',
			'arrow-circle-left' => 'Arrow circle left',
			'arrow-circle-o-down' => 'Arrow circle o down',
			'arrow-circle-o-left' => 'Arrow circle o left',
			'arrow-circle-o-right' => 'Arrow circle o right',
			'arrow-circle-o-up' => 'Arrow circle o up',
			'arrow-circle-right' => 'Arrow circle right',
			'arrow-circle-up' => 'Arrow circle up',
			'arrow-down' => 'Arrow down',
			'arrow-left' => 'Arrow left',
			'arrow-right' => 'Arrow right',
			'arrow-up' => 'Arrow up',
			'arrows' => 'Arrows',
			'arrows-alt' => 'Arrows alt',
			'arrows-h' => 'Arrows h',
			'arrows-v' => 'Arrows v',
			'asterisk' => 'Asterisk',
			'at' => 'At',
			'backward' => 'Backward',
			'balance-scale' => 'Balance scale',
			'ban' => 'Ban',
			'bar-chart' => 'Bar chart',
			'barcode' => 'Barcode',
			'bars' => 'Bars',
			'battery-empty' => 'Battery empty',
			'battery-full' => 'Battery full',
			'battery-half' => 'Battery half',
			'battery-quarter' => 'Battery quarter',
			'battery-three-quarters' => 'Battery three quarters',
			'bed' => 'Bed',
			'beer' => 'Beer',
			'behance' => 'Behance',
			'behance-square' => 'Behance square',
			'bell' => 'Bell',
			'bell-o' => 'Bell o',
			'bell-slash' => 'Bell slash',
			'bell-slash-o' => 'Bell slash o',
			'bicycle' => 'Bicycle',
			'binoculars' => 'Binoculars',
			'birthday-cake' => 'Birthday cake',
			'bitbucket' => 'Bitbucket',
			'bitbucket-square' => 'Bitbucket square',
			'black-tie' => 'Black tie',
			'bold' => 'Bold',
			'bolt' => 'Bolt',
			'bomb' => 'Bomb',
			'book' => 'Book',
			'bookmark' => 'Bookmark',
			'bookmark-o' => 'Bookmark o',
			'briefcase' => 'Briefcase',
			'btc' => 'Btc',
			'bug' => 'Bug',
			'building' => 'Building',
			'building-o' => 'Building o',
			'bullhorn' => 'Bullhorn',
			'bullseye' => 'Bullseye',
			'bus' => 'Bus',
			'buysellads' => 'Buysellads',
			'calculator' => 'Calculator',
			'calendar' => 'Calendar',
			'calendar-check-o' => 'Calendar check o',
			'calendar-minus-o' => 'Calendar minus o',
			'calendar-o' => 'Calendar o',
			'calendar-plus-o' => 'Calendar plus o',
			'calendar-times-o' => 'Calendar times o',
			'camera' => 'Camera',
			'camera-retro' => 'Camera retro',
			'car' => 'Car',
			'caret-down' => 'Caret down',
			'caret-left' => 'Caret left',
			'caret-right' => 'Caret right',
			'caret-square-o-down' => 'Caret square o down',
			'caret-square-o-left' => 'Caret square o left',
			'caret-square-o-right' => 'Caret square o right',
			'caret-square-o-up' => 'Caret square o up',
			'caret-up' => 'Caret up',
			'cart-arrow-down' => 'Cart arrow down',
			'cart-plus' => 'Cart plus',
			'cc' => 'Cc',
			'cc-amex' => 'Cc amex',
			'cc-diners-club' => 'Cc diners club',
			'cc-discover' => 'Cc discover',
			'cc-jcb' => 'Cc jcb',
			'cc-mastercard' => 'Cc mastercard',
			'cc-paypal' => 'Cc paypal',
			'cc-stripe' => 'Cc stripe',
			'cc-visa' => 'Cc visa',
			'certificate' => 'Certificate',
			'chain-broken' => 'Chain broken',
			'check' => 'Check',
			'check-circle' => 'Check circle',
			'check-circle-o' => 'Check circle o',
			'check-square' => 'Check square',
			'check-square-o' => 'Check square o',
			'chevron-circle-down' => 'Chevron circle down',
			'chevron-circle-left' => 'Chevron circle left',
			'chevron-circle-right' => 'Chevron circle right',
			'chevron-circle-up' => 'Chevron circle up',
			'chevron-down' => 'Chevron down',
			'chevron-left' => 'Chevron left',
			'chevron-right' => 'Chevron right',
			'chevron-up' => 'Chevron up',
			'child' => 'Child',
			'chrome' => 'Chrome',
			'circle' => 'Circle',
			'circle-o' => 'Circle o',
			'circle-o-notch' => 'Circle o notch',
			'circle-thin' => 'Circle thin',
			'clipboard' => 'Clipboard',
			'clock-o' => 'Clock o',
			'clone' => 'Clone',
			'cloud' => 'Cloud',
			'cloud-download' => 'Cloud download',
			'cloud-upload' => 'Cloud upload',
			'code' => 'Code',
			'code-fork' => 'Code fork',
			'codepen' => 'Codepen',
			'coffee' => 'Coffee',
			'cog' => 'Cog',
			'cogs' => 'Cogs',
			'columns' => 'Columns',
			'comment' => 'Comment',
			'comment-o' => 'Comment o',
			'commenting' => 'Commenting',
			'commenting-o' => 'Commenting o',
			'comments' => 'Comments',
			'comments-o' => 'Comments o',
			'compass' => 'Compass',
			'compress' => 'Compress',
			'connectdevelop' => 'Connectdevelop',
			'contao' => 'Contao',
			'copyright' => 'Copyright',
			'creative-commons' => 'Creative commons',
			'credit-card' => 'Credit card',
			'crop' => 'Crop',
			'crosshairs' => 'Crosshairs',
			'css3' => 'Css3',
			'cube' => 'Cube',
			'cubes' => 'Cubes',
			'cutlery' => 'Cutlery',
			'dashcube' => 'Dashcube',
			'database' => 'Database',
			'delicious' => 'Delicious',
			'desktop' => 'Desktop',
			// 'deviantart' => 'Deviantart',
			'diamond' => 'Diamond',
			// 'digg' => 'Digg',
			'dot-circle-o' => 'Dot circle o',
			'download' => 'Download',
			// 'dribbble' => 'Dribbble',
			// 'dropbox' => 'Dropbox',
			'drupal' => 'Drupal',
			'eject' => 'Eject',
			'ellipsis-h' => 'Ellipsis h',
			'ellipsis-v' => 'Ellipsis v',
			'empire' => 'Empire',
			'envelope' => 'Envelope',
			'envelope-o' => 'Envelope o',
			// 'envelope-square' => 'Envelope square',
			'eraser' => 'Eraser',
			'eur' => 'Eur',
			'exchange' => 'Exchange',
			'exclamation' => 'Exclamation',
			'exclamation-circle' => 'Exclamation circle',
			'exclamation-triangle' => 'Exclamation triangle',
			'expand' => 'Expand',
			'expeditedssl' => 'Expeditedssl',
			'external-link' => 'External link',
			'external-link-square' => 'External link square',
			'eye' => 'Eye',
			'eye-slash' => 'Eye slash',
			'eyedropper' => 'Eyedropper',
			'facebook' => 'Facebook',
			'facebook-official' => 'Facebook official',
			'facebook-square' => 'Facebook square',
			'fast-backward' => 'Fast backward',
			'fast-forward' => 'Fast forward',
			'fax' => 'Fax',
			'female' => 'Female',
			'fighter-jet' => 'Fighter jet',
			'file' => 'File',
			'file-archive-o' => 'File archive o',
			'file-audio-o' => 'File audio o',
			'file-code-o' => 'File code o',
			'file-excel-o' => 'File excel o',
			'file-image-o' => 'File image o',
			'file-o' => 'File o',
			'file-pdf-o' => 'File pdf o',
			'file-powerpoint-o' => 'File powerpoint o',
			'file-text' => 'File text',
			'file-text-o' => 'File text o',
			'file-video-o' => 'File video o',
			'file-word-o' => 'File word o',
			'files-o' => 'Files o',
			'film' => 'Film',
			'filter' => 'Filter',
			'fire' => 'Fire',
			'fire-extinguisher' => 'Fire extinguisher',
			'firefox' => 'Firefox',
			'flag' => 'Flag',
			'flag-checkered' => 'Flag checkered',
			'flag-o' => 'Flag o',
			'flask' => 'Flask',
			// 'flickr' => 'Flickr',
			'floppy-o' => 'Floppy o',
			'folder' => 'Folder',
			'folder-o' => 'Folder o',
			'folder-open' => 'Folder open',
			'folder-open-o' => 'Folder open o',
			'font' => 'Font',
			'fonticons' => 'Fonticons',
			'forumbee' => 'Forumbee',
			'forward' => 'Forward',
			'foursquare' => 'Foursquare',
			'frown-o' => 'Frown o',
			'futbol-o' => 'Futbol o',
			'gamepad' => 'Gamepad',
			'gavel' => 'Gavel',
			'gbp' => 'Gbp',
			'genderless' => 'Genderless',
			'get-pocket' => 'Get pocket',
			'gg' => 'Gg',
			'gg-circle' => 'Gg circle',
			'gift' => 'Gift',
			'git' => 'Git',
			'git-square' => 'Git square',
			'github' => 'Github',
			'github-alt' => 'Github alt',
			'github-square' => 'Github square',
			'glass' => 'Glass',
			'globe' => 'Globe',
			'google' => 'Google',
			'google-plus' => 'Google plus',
			// 'google-plus-square' => 'Google plus square',
			'google-wallet' => 'Google wallet',
			'graduation-cap' => 'Graduation cap',
			'gratipay' => 'Gratipay',
			'h-square' => 'H square',
			'hacker-news' => 'Hacker news',
			'hand-lizard-o' => 'Hand lizard o',
			'hand-o-down' => 'Hand o down',
			'hand-o-left' => 'Hand o left',
			'hand-o-right' => 'Hand o right',
			'hand-o-up' => 'Hand o up',
			'hand-paper-o' => 'Hand paper o',
			'hand-peace-o' => 'Hand peace o',
			'hand-pointer-o' => 'Hand pointer o',
			'hand-rock-o' => 'Hand rock o',
			'hand-scissors-o' => 'Hand scissors o',
			'hand-spock-o' => 'Hand spock o',
			'hdd-o' => 'Hdd o',
			'header' => 'Header',
			'headphones' => 'Headphones',
			'heart' => 'Heart',
			'heart-o' => 'Heart o',
			'heartbeat' => 'Heartbeat',
			'history' => 'History',
			'home' => 'Home',
			'hospital-o' => 'Hospital o',
			'hourglass' => 'Hourglass',
			'hourglass-end' => 'Hourglass end',
			'hourglass-half' => 'Hourglass half',
			'hourglass-o' => 'Hourglass o',
			'hourglass-start' => 'Hourglass start',
			'houzz' => 'Houzz',
			'html5' => 'Html5',
			'i-cursor' => 'I cursor',
			'ils' => 'Ils',
			'inbox' => 'Inbox',
			'indent' => 'Indent',
			'industry' => 'Industry',
			'info' => 'Info',
			'info-circle' => 'Info circle',
			'inr' => 'Inr',
			// 'instagram' => 'Instagram',
			'internet-explorer' => 'Internet explorer',
			'ioxhost' => 'Ioxhost',
			'italic' => 'Italic',
			'joomla' => 'Joomla',
			'jpy' => 'Jpy',
			'jsfiddle' => 'Jsfiddle',
			'key' => 'Key',
			'keyboard-o' => 'Keyboard o',
			'krw' => 'Krw',
			'language' => 'Language',
			'laptop' => 'Laptop',
			'lastfm' => 'Lastfm',
			'lastfm-square' => 'Lastfm square',
			'leaf' => 'Leaf',
			'leanpub' => 'Leanpub',
			'lemon-o' => 'Lemon o',
			'level-down' => 'Level down',
			'level-up' => 'Level up',
			'life-ring' => 'Life ring',
			'lightbulb-o' => 'Lightbulb o',
			'line-chart' => 'Line chart',
			'link' => 'Link',
			'linkedin' => 'Linkedin',
			// 'linkedin-square' => 'Linkedin square',
			'linux' => 'Linux',
			'list' => 'List',
			'list-alt' => 'List alt',
			'list-ol' => 'List ol',
			'list-ul' => 'List ul',
			'location-arrow' => 'Location arrow',
			'lock' => 'Lock',
			'long-arrow-down' => 'Long arrow down',
			'long-arrow-left' => 'Long arrow left',
			'long-arrow-right' => 'Long arrow right',
			'long-arrow-up' => 'Long arrow up',
			'magic' => 'Magic',
			'magnet' => 'Magnet',
			'male' => 'Male',
			'map' => 'Map',
			'map-marker' => 'Map marker',
			'map-o' => 'Map o',
			'map-pin' => 'Map pin',
			'map-signs' => 'Map signs',
			'mars' => 'Mars',
			'mars-double' => 'Mars double',
			'mars-stroke' => 'Mars stroke',
			'mars-stroke-h' => 'Mars stroke h',
			'mars-stroke-v' => 'Mars stroke v',
			'maxcdn' => 'Maxcdn',
			'meanpath' => 'Meanpath',
			'medium' => 'Medium',
			'medkit' => 'Medkit',
			'meh-o' => 'Meh o',
			'mercury' => 'Mercury',
			'microphone' => 'Microphone',
			'microphone-slash' => 'Microphone slash',
			'minus' => 'Minus',
			'minus-circle' => 'Minus circle',
			'minus-square' => 'Minus square',
			'minus-square-o' => 'Minus square o',
			'mobile' => 'Mobile',
			'money' => 'Money',
			'moon-o' => 'Moon o',
			'motorcycle' => 'Motorcycle',
			'mouse-pointer' => 'Mouse pointer',
			'music' => 'Music',
			'neuter' => 'Neuter',
			'newspaper-o' => 'Newspaper o',
			'object-group' => 'Object group',
			'object-ungroup' => 'Object ungroup',
			'odnoklassniki' => 'Odnoklassniki',
			'odnoklassniki-square' => 'Odnoklassniki square',
			'opencart' => 'Opencart',
			'openid' => 'Openid',
			'opera' => 'Opera',
			'optin-monster' => 'Optin monster',
			'outdent' => 'Outdent',
			'pagelines' => 'Pagelines',
			'paint-brush' => 'Paint brush',
			'paper-plane' => 'Paper plane',
			'paper-plane-o' => 'Paper plane o',
			'paperclip' => 'Paperclip',
			'paragraph' => 'Paragraph',
			'pause' => 'Pause',
			'paw' => 'Paw',
			// 'paypal' => 'Paypal',
			'pencil' => 'Pencil',
			'pencil-square' => 'Pencil square',
			'pencil-square-o' => 'Pencil square o',
			'phone' => 'Phone',
			'phone-square' => 'Phone square',
			'picture-o' => 'Picture o',
			'pie-chart' => 'Pie chart',
			'pied-piper' => 'Pied piper',
			'pied-piper-alt' => 'Pied piper alt',
			'pinterest' => 'Pinterest',
			'pinterest-p' => 'Pinterest p',
			// 'pinterest-square' => 'Pinterest square',
			'plane' => 'Plane',
			'play' => 'Play',
			'play-circle' => 'Play circle',
			'play-circle-o' => 'Play circle o',
			'plug' => 'Plug',
			'plus' => 'Plus',
			'plus-circle' => 'Plus circle',
			'plus-square' => 'Plus square',
			'plus-square-o' => 'Plus square o',
			'power-off' => 'Power off',
			'print' => 'Print',
			'puzzle-piece' => 'Puzzle piece',
			'qq' => 'Qq',
			'qrcode' => 'Qrcode',
			'question' => 'Question',
			'question-circle' => 'Question circle',
			'quote-left' => 'Quote left',
			'quote-right' => 'Quote right',
			'random' => 'Random',
			'rebel' => 'Rebel',
			'recycle' => 'Recycle',
			'reddit' => 'Reddit',
			// 'reddit-square' => 'Reddit square',
			'refresh' => 'Refresh',
			'registered' => 'Registered',
			'renren' => 'Renren',
			'repeat' => 'Repeat',
			'reply' => 'Reply',
			'reply-all' => 'Reply all',
			'retweet' => 'Retweet',
			'road' => 'Road',
			'rocket' => 'Rocket',
			'rss' => 'Rss',
			// 'rss-square' => 'Rss square',
			'rub' => 'Rub',
			'safari' => 'Safari',
			'scissors' => 'Scissors',
			'search' => 'Search',
			'search-minus' => 'Search minus',
			'search-plus' => 'Search plus',
			'sellsy' => 'Sellsy',
			'server' => 'Server',
			'share' => 'Share',
			'share-alt' => 'Share alt',
			'share-alt-square' => 'Share alt square',
			'share-square' => 'Share square',
			'share-square-o' => 'Share square o',
			'shield' => 'Shield',
			'ship' => 'Ship',
			'shirtsinbulk' => 'Shirtsinbulk',
			'shopping-cart' => 'Shopping cart',
			'sign-in' => 'Sign in',
			'sign-out' => 'Sign out',
			'signal' => 'Signal',
			'simplybuilt' => 'Simplybuilt',
			'sitemap' => 'Sitemap',
			'skyatlas' => 'Skyatlas',
			// 'skype' => 'Skype',
			'slack' => 'Slack',
			'sliders' => 'Sliders',
			'slideshare' => 'Slideshare',
			'smile-o' => 'Smile o',
			'sort' => 'Sort',
			'sort-alpha-asc' => 'Sort alpha asc',
			'sort-alpha-desc' => 'Sort alpha desc',
			'sort-amount-asc' => 'Sort amount asc',
			'sort-amount-desc' => 'Sort amount desc',
			'sort-asc' => 'Sort asc',
			'sort-desc' => 'Sort desc',
			'sort-numeric-asc' => 'Sort numeric asc',
			'sort-numeric-desc' => 'Sort numeric desc',
			// 'soundcloud' => 'Soundcloud',
			'space-shuttle' => 'Space shuttle',
			'spinner' => 'Spinner',
			'spoon' => 'Spoon',
			'spotify' => 'Spotify',
			'square' => 'Square',
			'square-o' => 'Square o',
			'stack-exchange' => 'Stack exchange',
			'stack-overflow' => 'Stack overflow',
			'star' => 'Star',
			'star-half' => 'Star half',
			'star-half-o' => 'Star half o',
			'star-o' => 'Star o',
			'steam' => 'Steam',
			'steam-square' => 'Steam square',
			'step-backward' => 'Step backward',
			'step-forward' => 'Step forward',
			'stethoscope' => 'Stethoscope',
			'sticky-note' => 'Sticky note',
			'sticky-note-o' => 'Sticky note o',
			'stop' => 'Stop',
			'street-view' => 'Street view',
			'strikethrough' => 'Strikethrough',
			'stumbleupon' => 'Stumbleupon',
			'stumbleupon-circle' => 'Stumbleupon circle',
			'subscript' => 'Subscript',
			'subway' => 'Subway',
			'suitcase' => 'Suitcase',
			'sun-o' => 'Sun o',
			'superscript' => 'Superscript',
			'table' => 'Table',
			'tablet' => 'Tablet',
			'tachometer' => 'Tachometer',
			'tag' => 'Tag',
			'tags' => 'Tags',
			'tasks' => 'Tasks',
			'taxi' => 'Taxi',
			'television' => 'Television',
			'tencent-weibo' => 'Tencent weibo',
			'terminal' => 'Terminal',
			'text-height' => 'Text height',
			'text-width' => 'Text width',
			'th' => 'Th',
			'th-large' => 'Th large',
			'th-list' => 'Th list',
			'thumb-tack' => 'Thumb tack',
			'thumbs-down' => 'Thumbs down',
			'thumbs-o-down' => 'Thumbs o down',
			'thumbs-o-up' => 'Thumbs o up',
			'thumbs-up' => 'Thumbs up',
			'ticket' => 'Ticket',
			'times' => 'Times',
			'times-circle' => 'Times circle',
			'times-circle-o' => 'Times circle o',
			'tint' => 'Tint',
			'toggle-off' => 'Toggle off',
			'toggle-on' => 'Toggle on',
			'trademark' => 'Trademark',
			'train' => 'Train',
			'transgender' => 'Transgender',
			'transgender-alt' => 'Transgender alt',
			'trash' => 'Trash',
			'trash-o' => 'Trash o',
			'tree' => 'Tree',
			'trello' => 'Trello',
			'tripadvisor' => 'Tripadvisor',
			'trophy' => 'Trophy',
			'truck' => 'Truck',
			'try' => 'Try',
			'tty' => 'Tty',
			'tumblr' => 'Tumblr',
			// 'tumblr-square' => 'Tumblr square',
			'twitch' => 'Twitch',
			'twitter' => 'Twitter',
			// 'twitter-square' => 'Twitter square',
			'umbrella' => 'Umbrella',
			'underline' => 'Underline',
			'undo' => 'Undo',
			'university' => 'University',
			'unlock' => 'Unlock',
			'unlock-alt' => 'Unlock alt',
			'upload' => 'Upload',
			'usd' => 'Usd',
			'user' => 'User',
			'user-md' => 'User md',
			'user-plus' => 'User plus',
			'user-secret' => 'User secret',
			'user-times' => 'User times',
			'users' => 'Users',
			'venus' => 'Venus',
			'venus-double' => 'Venus double',
			'venus-mars' => 'Venus mars',
			'viacoin' => 'Viacoin',
			'video-camera' => 'Video camera',
			'vimeo' => 'Vimeo',
			// 'vimeo-square' => 'Vimeo square',
			'vine' => 'Vine',
			// 'vk' => 'Vk',
			'volume-down' => 'Volume down',
			'volume-off' => 'Volume off',
			'volume-up' => 'Volume up',
			'weibo' => 'Weibo',
			'weixin' => 'Weixin',
			'whatsapp' => 'Whatsapp',
			'wheelchair' => 'Wheelchair',
			'wifi' => 'Wifi',
			'wikipedia-w' => 'Wikipedia w',
			'windows' => 'Windows',
			'wordpress' => 'Wordpress',
			'wrench' => 'Wrench',
			'xing' => 'Xing',
			'xing-square' => 'Xing square',
			'y-combinator' => 'Y combinator',
			'yahoo' => 'Yahoo',
			'yelp' => 'Yelp',
			'youtube' => 'Youtube',
			'youtube-play' => 'Youtube play',
			// 'youtube-square' => 'Youtube square',
			// Add a "custom" entry
			'custom'                 => 'Custom',
		);

		return $fa_array;

	}

	public static function standard_fonts() {

		$standard_fonts = array(
			'Arial, Helvetica, sans-serif' => 'Arial, Helvetica, sans-serif',
			"'Arial Black', Gadget, sans-serif" => "'Arial Black', Gadget, sans-serif",
			"'Bookman Old Style', serif" => "'Bookman Old Style', serif",
			"'Comic Sans MS', cursive" => "'Comic Sans MS', cursive",
			"Courier, monospace" => "Courier, monospace",
			"Garamond, serif" => "Garamond, serif",
			"Georgia, serif" => "Georgia, serif",
			"Impact, Charcoal, sans-serif" => "Impact, Charcoal, sans-serif",
			"'Lucida Console', Monaco, monospace" => "'Lucida Console', Monaco, monospace",
			"'Lucida Sans Unicode', 'Lucida Grande', sans-serif" => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
			"'MS Sans Serif', Geneva, sans-serif" => "'MS Sans Serif', Geneva, sans-serif",
			"'MS Serif', 'New York', sans-serif" => "'MS Serif', 'New York', sans-serif",
			"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
			"Tahoma, Geneva, sans-serif" => "Tahoma, Geneva, sans-serif",
			"'Times New Roman', Times, serif" => "'Times New Roman', Times, serif",
			"'Trebuchet MS', Helvetica, sans-serif" => "'Trebuchet MS', Helvetica, sans-serif",
			"Verdana, Geneva, sans-serif" => "Verdana, Geneva, sans-serif"
		);

		return $standard_fonts;

	}

	public static function font_weights() {

		$font_weights = array(
			'100'	=> 'Thin (100)',
			'200'	=> 'Extra Light (200)',
			'300'	=> 'Light (300)',
			'400'	=> 'Normal (400)',
			'500'	=> 'Medium (500)',
			'600'	=> 'Semi Bold (600)',
			'700'	=> 'Bold (700)',
			'800'	=> 'Bolder (800)',
			'900'	=> 'Extra Bold (900)',
		);

		return $font_weights;

	}

	public static function font_subsets() {
		return array(
			'greek-ext',
			'greek',
			'cyrillic-ext',
			'cyrillic',
			'latin-ext',
			'latin',
			'vietnamese',
			'arabic',
			'gujarati',
			'devanagari',
			'bengali',
			'hebrew',
			'khmer',
			'tamil',
			'telugu',
			'thai',
		);
	}

}

// Omit closing PHP tag to avoid 'Headers already sent' issues.
